/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.memoryanalysis.traceparser;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.ibm.wala.util.collections.HashMapFactory;
import com.samsung.memoryanalysis.traceparser.SourceLocation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class IIDMap {
    public static final int END_OF_PROGRAM_IID = 0;
    public static final int UNKNOWN_IID = -1;
    public static final int INITIAL_DOM_IID = -2;
    private final Map<Integer, SourceLocation> map;

    public static IIDMap parseIIDFile(File traceDirectory) {
        File jsonObject = new File(traceDirectory, "jalangi_sourcemap.json");
        HashMap result = HashMapFactory.make();
        result.put(0, SourceLocation.END_OF_PROGRAM);
        result.put(-1, SourceLocation.UNKNOWN);
        result.put(-2, SourceLocation.INITIAL_DOM);
        if (jsonObject.exists()) {
            JsonObject json;
            try {
                BufferedReader in = new BufferedReader(new FileReader(jsonObject));
                json = new JsonParser().parse((Reader)in).getAsJsonArray().get(0).getAsJsonObject();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error reading jalangi_sourcemap.json", e);
            }
            catch (JsonParseException e) {
                throw new IllegalArgumentException("Parser error in jalangi_sourcemap.json", e);
            }
            for (Map.Entry keyO : json.entrySet()) {
                String key = (String)keyO.getKey();
                JsonArray entry = ((JsonElement)keyO.getValue()).getAsJsonArray();
                String file = entry.get(0).getAsString();
                Long startLine = entry.get(1).getAsLong();
                Long startColumn = entry.get(2).getAsLong();
                Long endLine = entry.get(3).getAsLong();
                Long endColumn = entry.get(4).getAsLong();
                result.put(Integer.parseInt(key), new SourceLocation(file, startLine, startColumn, endLine, endColumn));
            }
        }
        return new IIDMap(result);
    }

    public static IIDMap empty() {
        return new IIDMap(HashMapFactory.make());
    }

    private IIDMap(Map<Integer, SourceLocation> map) {
        this.map = map;
    }

    public SourceLocation get(int iid) {
        SourceLocation result = this.map.get(iid);
        if (result == null) {
            return SourceLocation.UNKNOWN;
        }
        return result;
    }

    public void addMapping(int iid, SourceLocation loc) {
        if (this.map.containsKey(iid)) {
            throw new IllegalArgumentException("already have a mapping for IID " + iid);
        }
        this.map.put(iid, loc);
    }
}

