/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.util.collections.IVector;
import com.ibm.wala.util.collections.SparseVector;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.math.Logs;
import java.util.Iterator;
import java.util.Vector;

public class TwoLevelVector<T>
implements IVector<T> {
    private static final int PAGE_SIZE = 4096;
    private static final int LOG_PAGE_SIZE = Logs.log2(4096);
    private final Vector<SparseVector<T>> data = new Vector(0);
    private int maxPage = -1;

    @Override
    public T get(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("invalid x: " + x);
        }
        int page = this.getPageNumber(x);
        if (page >= this.data.size()) {
            return null;
        }
        IVector v = this.data.get(page);
        if (v == null) {
            return null;
        }
        int localX = x - this.getFirstIndexOnPage(page);
        return v.get(localX);
    }

    private int getFirstIndexOnPage(int page) {
        return page << LOG_PAGE_SIZE;
    }

    private int getPageNumber(int x) {
        return x >> LOG_PAGE_SIZE;
    }

    @Override
    public void set(int x, T value) {
        if (x < 0) {
            throw new IllegalArgumentException("illegal x: " + x);
        }
        int page = this.getPageNumber(x);
        IVector<T> v = this.findOrCreatePage(page);
        int localX = this.toLocalIndex(x, page);
        v.set(localX, value);
    }

    private int toLocalIndex(int x, int page) {
        return x - this.getFirstIndexOnPage(page);
    }

    private IVector<T> findOrCreatePage(int page) {
        if (page >= this.data.size()) {
            SparseVector v = new SparseVector();
            this.data.setSize(page + 1);
            this.data.add(page, v);
            this.maxPage = Math.max(page, this.maxPage);
            return v;
        }
        SparseVector<T> v = this.data.get(page);
        if (v == null) {
            v = new SparseVector();
            this.data.set(page, v);
            this.maxPage = Math.max(page, this.maxPage);
        }
        return v;
    }

    @Override
    public void performVerboseAction() {
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            final Iterator<SparseVector<T>> outer;
            Iterator<T> inner;
            {
                for (IVector v : TwoLevelVector.this.data) {
                    Iterator it;
                    if (v == null || !(it = v.iterator()).hasNext()) continue;
                    this.inner = it;
                    break;
                }
            }

            @Override
            public boolean hasNext() {
                return this.inner != null;
            }

            @Override
            public T next() {
                Object result = this.inner.next();
                if (!this.inner.hasNext()) {
                    this.inner = null;
                    while (this.outer.hasNext()) {
                        Iterator it;
                        IVector v = this.outer.next();
                        if (v == null || !(it = v.iterator()).hasNext()) continue;
                        this.inner = it;
                        break;
                    }
                }
                return result;
            }

            @Override
            public void remove() {
                Assertions.UNREACHABLE();
            }
        };
    }

    @Override
    public int getMaxIndex() {
        if (this.maxPage == -1) {
            return -1;
        }
        IVector v = this.data.get(this.maxPage);
        int localMax = v.getMaxIndex();
        return this.maxPage * 4096 + localMax;
    }
}

