/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.traverse;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.graph.INodeWithNumber;
import com.ibm.wala.util.graph.NumberedGraph;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class WelshPowell<T extends INodeWithNumber> {
    public static <T> Comparator<T> defaultComparator(final NumberedGraph<T> G) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                int o2edges;
                int o1edges = G.getSuccNodeCount(o1) + G.getPredNodeCount(o1);
                if (o1edges != (o2edges = G.getSuccNodeCount(o2) + G.getPredNodeCount(o2))) {
                    return o2edges - o1edges;
                }
                return o2.toString().compareTo(o1.toString());
            }
        };
    }

    public ColoredVertices<T> color(NumberedGraph<T> G) {
        return this.color(G, WelshPowell.defaultComparator(G), Integer.MAX_VALUE);
    }

    public ColoredVertices<T> color(NumberedGraph<T> G, int maxColors) {
        return this.color(G, WelshPowell.defaultComparator(G), maxColors);
    }

    public ColoredVertices<T> color(NumberedGraph<T> G, Comparator<T> order, int maxColors) {
        int[] colors = new int[G.getMaxNumber() + 1];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = -1;
        }
        TreeSet<T> vertices = new TreeSet<T>(order);
        for (INodeWithNumber n : G) {
            vertices.add(n);
        }
        int currentColor = 0;
        int colored = 0;
        for (INodeWithNumber n : vertices) {
            int id = n.getGraphNodeId();
            if (colors[id] != -1) continue;
            colors[id] = currentColor;
            ++colored;
            block3: for (INodeWithNumber m : vertices) {
                if (colors[m.getGraphNodeId()] != -1) continue;
                Iterator<INodeWithNumber> ps = G.getPredNodes(m);
                while (ps.hasNext()) {
                    INodeWithNumber p = ps.next();
                    if (colors[p.getGraphNodeId()] != currentColor) continue;
                    continue block3;
                }
                Iterator<INodeWithNumber> ss = G.getSuccNodes(m);
                while (ss.hasNext()) {
                    INodeWithNumber s = ss.next();
                    if (colors[s.getGraphNodeId()] != currentColor) continue;
                    continue block3;
                }
                colors[m.getGraphNodeId()] = currentColor;
                ++colored;
                if (currentColor != maxColors - 1) continue;
                return new ColoredVertices<T>(false, G, colors, currentColor);
            }
            if (++currentColor != maxColors - 1) continue;
            return new ColoredVertices<T>(false, G, colors, currentColor);
        }
        assert (colored == G.getNumberOfNodes());
        return new ColoredVertices<T>(true, G, colors, currentColor);
    }

    public static class ColoredVertices<T> {
        private final boolean fullColoring;
        private final Map<T, Integer> colors;
        private final int numColors;

        public boolean isFullColoring() {
            return this.fullColoring;
        }

        public Map<T, Integer> getColors() {
            return this.colors;
        }

        public int getNumColors() {
            return this.numColors;
        }

        public ColoredVertices(boolean fullColoring, NumberedGraph<T> G, int[] colors, int numColors) {
            this(fullColoring, ColoredVertices.makeMap(G, colors), numColors);
        }

        private static <T> Map<T, Integer> makeMap(NumberedGraph<T> G, int[] colors) {
            HashMap colorMap = HashMapFactory.make();
            for (int i = 0; i < colors.length; ++i) {
                if (colors[i] == -1) continue;
                colorMap.put(G.getNode(i), colors[i]);
            }
            return colorMap;
        }

        public ColoredVertices(boolean fullColoring, Map<T, Integer> colors, int numColors) {
            this.fullColoring = fullColoring;
            this.colors = colors;
            this.numColors = numColors;
        }
    }
}

