/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.astgen;

import edu.rice.cs.astgen.ASTModel;
import edu.rice.cs.astgen.NodeType;
import edu.rice.cs.astgen.TabPrintWriter;
import edu.rice.cs.astgen.Types;

public class DepthFirstVisitorGenerator
extends edu.rice.cs.astgen.DepthFirstVisitorGenerator {
    public DepthFirstVisitorGenerator(ASTModel ast) {
        super(ast);
    }

    protected void generateVisitor(NodeType root) {
        String visitorName = root.name() + "DepthFirstVisitor";
        TabPrintWriter writer = this.options.createJavaSourceInOutDir(visitorName);
        writer.startLine((Object)("/** A parametric abstract implementation of a visitor over " + root.name()));
        writer.print(" that returns a value.");
        writer.startLine((Object)" ** This visitor implements the visitor interface with methods that");
        writer.startLine((Object)" ** first visit children, and then call forCASEOnly(), passing in");
        writer.startLine((Object)" ** the values of the visits of the children. (CASE is replaced by the case name.)");
        writer.startLine((Object)" ** By default, each of forCASEOnly delegates to a more general case; at the");
        writer.startLine((Object)" ** top of this delegation tree is defaultCase(), which (unless overridden)");
        writer.startLine((Object)" ** throws an exception.");
        writer.startLine((Object)" **/");
        writer.startLine((Object)"@SuppressWarnings({\"unused\", \"unchecked\"})");
        writer.startLine((Object)("public abstract class " + visitorName + "<RetType>"));
        if (this.options.usePLT) {
            writer.print(" extends " + root.name() + "VisitorLambda<RetType>");
        } else {
            writer.print(" implements " + root.name() + "Visitor<RetType>");
        }
        writer.print(" {");
        writer.indent();
        this.outputDefaultCaseMethod(writer, root);
        writer.println();
        writer.startLine((Object)"/* Methods to handle a node after recursion. */");
        for (NodeType t : this.ast.descendents(root)) {
            this.outputForCaseOnly(t, writer, root);
        }
        writer.println();
        writer.startLine((Object)"/** Methods to recur on each child. */");
        for (NodeType t : this.ast.descendents(root)) {
            if (t.isAbstract()) continue;
            this.outputVisitMethod(t, writer, root);
        }
        writer.println();
        this.outputRecurMethod(writer, root, "RetType");
        writer.println();
        for (NodeType t : this.helpers()) {
            writer.println();
            this.generateHelper((Types.TypeName)t, writer, root);
        }
        this.clearHelpers();
        for (NodeType t : this.arraySeeds()) {
            writer.println();
            this.generateArraySeed((Types.TypeName)t, writer);
        }
        this.clearArraySeeds();
        writer.unindent();
        writer.startLine((Object)"}");
        writer.println();
        writer.close();
    }

    protected void outputDefaultCaseMethod(TabPrintWriter writer, NodeType root) {
        super.outputDefaultCaseMethod(writer, root);
    }
}

