/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.bug_detector;

import java.util.ArrayList;
import kr.ac.kaist.jsaf.bug_detector.BugItem;

public class AnalysisResult {
    static final int BUG_TYPE_REFERENCE_ERROR = 1;
    static final int BUG_TYPE_ERROR = 2;
    static final int BUG_TYPE_WARNING = 3;
    static final int BUG_API_ERROR = 4;
    static final int BUG_API_WARNING = 5;
    static final int BUG_CODING_GUIDE = 6;
    static final int BUG_TERMINATION = 100;
    static final int CATEGORY_TYPE_ABSENT_READ = 10;
    static final int CATEGORY_TYPE_BUILT_IN = 11;
    static final int CATEGORY_TYPE_CALL_NON_CONSTRUCTOR = 12;
    static final int CATEGORY_TYPE_CALL_NON_FUNCTION = 13;
    static final int CATEGORY_TYPE_CONVERT_TO_NUMBER = 14;
    static final int CATEGORY_TYPE_DEFAULT_VALUE = 15;
    static final int CATEGORY_TYPE_TYPE_CONVERSION = 16;
    static final int CATEGORY_TYPE_PRIMITIVE_OBJECT = 17;
    static final int CATEGORY_TYPE_ARGUMENTS_TYPE = 18;
    static final int CATEGORY_TYPE_WRONG_THIS = 19;
    static final int CATEGORY_API_INVALID_NAMESPACE = 30;
    static final int CATEGORY_API_WRONG_ARGUMENTS = 31;
    static final int CATEGORY_API_MISSING_ERROR_CB = 32;
    static final int CATEGORY_API_NO_EXECPTION_HANDLING = 33;
    static final int CATEGORY_API_WRONG_ARGUMENTS_TYPE = 34;
    static final int CATEGORY_API_WRONG_DICTIONARY_TYPE = 36;
    static final int CATEGORY_API_NO_MODIFY_OBJECT = 37;
    static final int CATEGORY_API_TIZEN_VERSION = 38;
    static final int CATEGORY_API_TIZEN_PRIVILEGE = 39;
    static final int CATEGORY_CODING_01_ARRAY = 50;
    static final int CATEGORY_CODING_02_VAR = 51;
    static final int CATEGORY_CODING_03_CAPTURE = 52;
    static final int CATEGORY_CODING_04_SEMI = 53;
    static final int CATEGORY_CODING_05_DEL = 54;
    static final int CATEGORY_CODING_06_STR = 55;
    static final int CATEGORY_CODING_07_CONST = 56;
    static final int CATEGORY_CODING_08_BUILT = 57;
    static final int CATEGORY_CODING_09_PIM = 58;
    static final int CATEGORY_CODING_10_FONIN = 59;
    static final int CATEGORY_CODING_11_DOUBLE_QUOTE = 60;
    static final int CATEGORY_CODING_12_OMIT_SEMI = 61;
    static final int CATEGORY_CODING_13_BEGIN_OP = 62;
    static final int CATEGORY_CODING_14_END_COMMA = 63;
    static final int CATEGORY_CODING_15_OPEN_BRACE = 64;
    static final int CATEGORY_CODING_16_MAX_LENGTH = 65;
    static final int CATEGORY_CODING_17_WRONG_INDENT = 66;
    static final int CATEGORY_TIME_LIMIT_EXCEEDED_ERROR = 100;
    static final int CATEGORY_SPACE_LIMIT_EXCEEDED_ERROR = 101;
    static final int CATEGORY_OTHER_ERROR = 102;
    private ArrayList<BugItem> bugInfoList;
    private static final String timeOutMsg = "Time limit %s(min) is exceeded while analyzing.";
    private static final String spaceOutMsg = "Max location count is exceeded while analyzing.";

    public void initBugInfoList() {
        this.bugInfoList = new ArrayList();
    }

    public ArrayList<BugItem> getBugInfoList() {
        return this.bugInfoList;
    }

    public void addBug(int bugLevel, int bugCategory, String message, String filePath, int lineNumber) {
        this.bugInfoList.add(new BugItem(bugLevel, bugCategory, message, filePath, lineNumber));
    }

    public void addInfo(String message) {
        this.bugInfoList.add(new BugItem(100, 102, message, "ERR", 0));
    }

    public void setTimeOut(int timeOut) {
        this.bugInfoList.add(new BugItem(100, 100, String.format(timeOutMsg, Integer.toString(timeOut)), "TIMEOUT", 0));
    }

    public void setSpaceOut() {
        this.bugInfoList.add(new BugItem(100, 101, String.format(spaceOutMsg, new Object[0]), "MEMORYERR", 0));
    }
}

