/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.compiler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.Charset;
import kr.ac.kaist.jsaf.exceptions.JSAFError$;
import kr.ac.kaist.jsaf.exceptions.ParserError;
import kr.ac.kaist.jsaf.exceptions.SyntaxError;
import kr.ac.kaist.jsaf.nodes.RegExpPattern;
import kr.ac.kaist.jsaf.parser.RegExp;
import kr.ac.kaist.jsaf.useful.Files;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import xtc.parser.ParseError;
import xtc.parser.Result;
import xtc.parser.SemanticValue;

public final class RegExpParser$
implements ScalaObject {
    public static final RegExpParser$ MODULE$;

    static {
        new RegExpParser$();
    }

    public RegExpPattern parseFileConvertExn(File file) {
        RegExpPattern exceptionResult1 = null;
        try {
            String filename = file.getCanonicalPath();
            exceptionResult1 = this.parsePattern(file, filename);
            return exceptionResult1;
        }
        catch (IOException iOException) {
            throw this.convertExn(iOException, file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw this.convertExn(fileNotFoundException, file);
        }
    }

    public RegExpPattern parsePattern(String str, String filename) {
        StringReader sr = new StringReader(str);
        BufferedReader in = new BufferedReader(sr);
        RegExpPattern result = this.parsePattern(in, filename);
        in.close();
        sr.close();
        return result;
    }

    public RegExpPattern parsePattern(File file, String filename) {
        FileInputStream fs = new FileInputStream(file);
        InputStreamReader sr = new InputStreamReader((InputStream)fs, Charset.forName("UTF-8"));
        BufferedReader in = new BufferedReader(sr);
        RegExpPattern result = this.parsePattern(in, filename);
        in.close();
        sr.close();
        fs.close();
        return result;
    }

    public RegExpPattern parsePattern(BufferedReader in, String filename) {
        String syntaxLogFile = new StringBuilder().append((Object)filename).append((Object)".log").toString();
        RegExpPattern exceptionResult2 = null;
        try {
            RegExp parser = new RegExp(in, filename);
            Result parseResult = parser.pPattern(0);
            if (!parseResult.hasValue()) {
                throw new ParserError((ParseError)parseResult, parser, new Integer(0));
            }
            exceptionResult2 = (RegExpPattern)((SemanticValue)parseResult).value;
        }
        finally {
            try {
                Files.rm(syntaxLogFile);
            }
            catch (IOException iOException) {}
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return exceptionResult2;
    }

    public SyntaxError convertExn(IOException ioe, File f) {
        String desc = "Unable to read file";
        if (ioe.getMessage() != null) {
            desc = new StringBuilder().append((Object)desc).append((Object)new StringBuilder().append((Object)" (").append((Object)ioe.getMessage()).append((Object)")").toString()).toString();
        }
        return JSAFError$.MODULE$.makeSyntaxError(desc);
    }

    public SyntaxError convertExn(FileNotFoundException fnfe, File f) {
        return JSAFError$.MODULE$.makeSyntaxError(new StringBuilder().append((Object)"Cannot find file ").append((Object)f.getAbsolutePath()).toString());
    }

    private RegExpParser$() {
        MODULE$ = this;
    }
}

