/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes;

import kr.ac.kaist.jsaf.nodes.IRAbstractNodeVisitor;
import kr.ac.kaist.jsaf.nodes.IRAbstractNodeVisitor_void;
import kr.ac.kaist.jsaf.nodes.IRAssign;
import kr.ac.kaist.jsaf.nodes.IRId;
import kr.ac.kaist.jsaf.nodes.IRNodeVisitor;
import kr.ac.kaist.jsaf.nodes.IRNodeVisitor_void;
import kr.ac.kaist.jsaf.nodes.IRSpanInfo;
import kr.ac.kaist.jsaf.nodes.TreeWalker;

public class IRCall
extends IRAssign {
    private final IRId _fun;
    private final IRId _thisB;
    private final IRId _args;

    public IRCall(IRSpanInfo in_info, IRId in_lhs, IRId in_fun, IRId in_thisB, IRId in_args) {
        super(in_info, in_lhs);
        if (in_fun == null) {
            throw new IllegalArgumentException("Parameter 'fun' to the IRCall constructor was null");
        }
        this._fun = in_fun;
        if (in_thisB == null) {
            throw new IllegalArgumentException("Parameter 'thisB' to the IRCall constructor was null");
        }
        this._thisB = in_thisB;
        if (in_args == null) {
            throw new IllegalArgumentException("Parameter 'args' to the IRCall constructor was null");
        }
        this._args = in_args;
    }

    public final IRId getFun() {
        return this._fun;
    }

    public final IRId getThisB() {
        return this._thisB;
    }

    public final IRId getArgs() {
        return this._args;
    }

    @Override
    public <RetType> RetType accept(IRAbstractNodeVisitor<RetType> visitor) {
        return visitor.forIRCall(this);
    }

    @Override
    public <RetType> RetType accept(IRNodeVisitor<RetType> visitor) {
        return visitor.forIRCall(this);
    }

    @Override
    public void accept(IRAbstractNodeVisitor_void visitor) {
        visitor.forIRCall(this);
    }

    @Override
    public void accept(IRNodeVisitor_void visitor) {
        visitor.forIRCall(this);
    }

    public boolean equals(Object obj) {
        IRId casted_args;
        IRId casted_thisB;
        IRId casted_fun;
        IRId casted_lhs;
        IRSpanInfo casted_info;
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass() || obj.hashCode() != this.hashCode()) {
            return false;
        }
        IRCall casted = (IRCall)obj;
        IRSpanInfo temp_info = this.getInfo();
        if (temp_info != (casted_info = casted.getInfo()) && !temp_info.equals(casted_info)) {
            return false;
        }
        IRId temp_lhs = this.getLhs();
        if (temp_lhs != (casted_lhs = casted.getLhs()) && !temp_lhs.equals(casted_lhs)) {
            return false;
        }
        IRId temp_fun = this.getFun();
        if (temp_fun != (casted_fun = casted.getFun()) && !temp_fun.equals(casted_fun)) {
            return false;
        }
        IRId temp_thisB = this.getThisB();
        if (temp_thisB != (casted_thisB = casted.getThisB()) && !temp_thisB.equals(casted_thisB)) {
            return false;
        }
        IRId temp_args = this.getArgs();
        return temp_args == (casted_args = casted.getArgs()) || temp_args.equals(casted_args);
    }

    @Override
    public int generateHashCode() {
        int code = this.getClass().hashCode();
        IRSpanInfo temp_info = this.getInfo();
        code ^= temp_info.hashCode();
        IRId temp_lhs = this.getLhs();
        code ^= temp_lhs.hashCode();
        IRId temp_fun = this.getFun();
        code ^= temp_fun.hashCode();
        IRId temp_thisB = this.getThisB();
        code ^= temp_thisB.hashCode();
        IRId temp_args = this.getArgs();
        return code ^= temp_args.hashCode();
    }

    protected IRCall() {
        this._fun = null;
        this._thisB = null;
        this._args = null;
    }

    @Override
    public void walk(TreeWalker w) {
        if (w.visitNode(this, "IRCall", 5)) {
            IRId temp_args;
            IRId temp_thisB;
            IRId temp_fun;
            IRId temp_lhs;
            IRSpanInfo temp_info = this.getInfo();
            if (w.visitNodeField("info", temp_info)) {
                temp_info.walk(w);
                w.endNodeField("info", temp_info);
            }
            if (w.visitNodeField("lhs", temp_lhs = this.getLhs())) {
                temp_lhs.walk(w);
                w.endNodeField("lhs", temp_lhs);
            }
            if (w.visitNodeField("fun", temp_fun = this.getFun())) {
                temp_fun.walk(w);
                w.endNodeField("fun", temp_fun);
            }
            if (w.visitNodeField("thisB", temp_thisB = this.getThisB())) {
                temp_thisB.walk(w);
                w.endNodeField("thisB", temp_thisB);
            }
            if (w.visitNodeField("args", temp_args = this.getArgs())) {
                temp_args.walk(w);
                w.endNodeField("args", temp_args);
            }
            w.endNode(this, "IRCall", 5);
        }
    }
}

