/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes;

import edu.rice.cs.plt.tuple.Option;
import kr.ac.kaist.jsaf.nodes.IRAbstractNodeVisitor;
import kr.ac.kaist.jsaf.nodes.IRAbstractNodeVisitor_void;
import kr.ac.kaist.jsaf.nodes.IRAssign;
import kr.ac.kaist.jsaf.nodes.IRExpr;
import kr.ac.kaist.jsaf.nodes.IRId;
import kr.ac.kaist.jsaf.nodes.IRNodeVisitor;
import kr.ac.kaist.jsaf.nodes.IRNodeVisitor_void;
import kr.ac.kaist.jsaf.nodes.IRSpanInfo;
import kr.ac.kaist.jsaf.nodes.TreeWalker;

public class IRInternalCall
extends IRAssign {
    private final IRId _fun;
    private final IRExpr _first;
    private final Option<IRId> _second;

    public IRInternalCall(IRSpanInfo in_info, IRId in_lhs, IRId in_fun, IRExpr in_first, Option<IRId> in_second) {
        super(in_info, in_lhs);
        if (in_fun == null) {
            throw new IllegalArgumentException("Parameter 'fun' to the IRInternalCall constructor was null");
        }
        this._fun = in_fun;
        if (in_first == null) {
            throw new IllegalArgumentException("Parameter 'first' to the IRInternalCall constructor was null");
        }
        this._first = in_first;
        if (in_second == null) {
            throw new IllegalArgumentException("Parameter 'second' to the IRInternalCall constructor was null");
        }
        this._second = in_second;
    }

    public final IRId getFun() {
        return this._fun;
    }

    public final IRExpr getFirst() {
        return this._first;
    }

    public final Option<IRId> getSecond() {
        return this._second;
    }

    @Override
    public <RetType> RetType accept(IRAbstractNodeVisitor<RetType> visitor) {
        return visitor.forIRInternalCall(this);
    }

    @Override
    public <RetType> RetType accept(IRNodeVisitor<RetType> visitor) {
        return visitor.forIRInternalCall(this);
    }

    @Override
    public void accept(IRAbstractNodeVisitor_void visitor) {
        visitor.forIRInternalCall(this);
    }

    @Override
    public void accept(IRNodeVisitor_void visitor) {
        visitor.forIRInternalCall(this);
    }

    public boolean equals(Object obj) {
        Option<IRId> casted_second;
        IRExpr casted_first;
        IRId casted_fun;
        IRId casted_lhs;
        IRSpanInfo casted_info;
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass() || obj.hashCode() != this.hashCode()) {
            return false;
        }
        IRInternalCall casted = (IRInternalCall)obj;
        IRSpanInfo temp_info = this.getInfo();
        if (temp_info != (casted_info = casted.getInfo()) && !temp_info.equals(casted_info)) {
            return false;
        }
        IRId temp_lhs = this.getLhs();
        if (temp_lhs != (casted_lhs = casted.getLhs()) && !temp_lhs.equals(casted_lhs)) {
            return false;
        }
        IRId temp_fun = this.getFun();
        if (temp_fun != (casted_fun = casted.getFun()) && !temp_fun.equals(casted_fun)) {
            return false;
        }
        IRExpr temp_first = this.getFirst();
        if (temp_first != (casted_first = casted.getFirst()) && !temp_first.equals(casted_first)) {
            return false;
        }
        Option<IRId> temp_second = this.getSecond();
        return temp_second == (casted_second = casted.getSecond()) || temp_second.equals(casted_second);
    }

    @Override
    public int generateHashCode() {
        int code = this.getClass().hashCode();
        IRSpanInfo temp_info = this.getInfo();
        code ^= temp_info.hashCode();
        IRId temp_lhs = this.getLhs();
        code ^= temp_lhs.hashCode();
        IRId temp_fun = this.getFun();
        code ^= temp_fun.hashCode();
        IRExpr temp_first = this.getFirst();
        code ^= temp_first.hashCode();
        Option<IRId> temp_second = this.getSecond();
        return code ^= temp_second.hashCode();
    }

    protected IRInternalCall() {
        this._fun = null;
        this._first = null;
        this._second = null;
    }

    @Override
    public void walk(TreeWalker w) {
        if (w.visitNode(this, "IRInternalCall", 5)) {
            Option<IRId> temp_second;
            IRExpr temp_first;
            IRId temp_fun;
            IRId temp_lhs;
            IRSpanInfo temp_info = this.getInfo();
            if (w.visitNodeField("info", temp_info)) {
                temp_info.walk(w);
                w.endNodeField("info", temp_info);
            }
            if (w.visitNodeField("lhs", temp_lhs = this.getLhs())) {
                temp_lhs.walk(w);
                w.endNodeField("lhs", temp_lhs);
            }
            if (w.visitNodeField("fun", temp_fun = this.getFun())) {
                temp_fun.walk(w);
                w.endNodeField("fun", temp_fun);
            }
            if (w.visitNodeField("first", temp_first = this.getFirst())) {
                temp_first.walk(w);
                w.endNodeField("first", temp_first);
            }
            if (w.visitNodeField("second", temp_second = this.getSecond())) {
                if (temp_second.isNone()) {
                    w.visitEmptyOption(temp_second);
                } else if (w.visitNonEmptyOption(temp_second)) {
                    IRId elt_temp_second = (IRId)temp_second.unwrap();
                    if (elt_temp_second == null) {
                        w.visitNull();
                    } else {
                        elt_temp_second.walk(w);
                    }
                    w.endNonEmptyOption(temp_second);
                }
                w.endNodeField("second", temp_second);
            }
            w.endNode(this, "IRInternalCall", 5);
        }
    }
}

