/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes;

import kr.ac.kaist.jsaf.nodes.IRAbstractNodeVisitor;
import kr.ac.kaist.jsaf.nodes.IRAbstractNodeVisitor_void;
import kr.ac.kaist.jsaf.nodes.IRExpr;
import kr.ac.kaist.jsaf.nodes.IRId;
import kr.ac.kaist.jsaf.nodes.IRNodeVisitor;
import kr.ac.kaist.jsaf.nodes.IRNodeVisitor_void;
import kr.ac.kaist.jsaf.nodes.IRSpanInfo;
import kr.ac.kaist.jsaf.nodes.IRStmt;
import kr.ac.kaist.jsaf.nodes.TreeWalker;

public class IRStore
extends IRStmt {
    private final IRId _obj;
    private final IRExpr _index;
    private final IRExpr _rhs;

    public IRStore(IRSpanInfo in_info, IRId in_obj, IRExpr in_index, IRExpr in_rhs) {
        super(in_info);
        if (in_obj == null) {
            throw new IllegalArgumentException("Parameter 'obj' to the IRStore constructor was null");
        }
        this._obj = in_obj;
        if (in_index == null) {
            throw new IllegalArgumentException("Parameter 'index' to the IRStore constructor was null");
        }
        this._index = in_index;
        if (in_rhs == null) {
            throw new IllegalArgumentException("Parameter 'rhs' to the IRStore constructor was null");
        }
        this._rhs = in_rhs;
    }

    public final IRId getObj() {
        return this._obj;
    }

    public final IRExpr getIndex() {
        return this._index;
    }

    public final IRExpr getRhs() {
        return this._rhs;
    }

    @Override
    public <RetType> RetType accept(IRAbstractNodeVisitor<RetType> visitor) {
        return visitor.forIRStore(this);
    }

    @Override
    public <RetType> RetType accept(IRNodeVisitor<RetType> visitor) {
        return visitor.forIRStore(this);
    }

    @Override
    public void accept(IRAbstractNodeVisitor_void visitor) {
        visitor.forIRStore(this);
    }

    @Override
    public void accept(IRNodeVisitor_void visitor) {
        visitor.forIRStore(this);
    }

    public boolean equals(Object obj) {
        IRExpr casted_rhs;
        IRExpr casted_index;
        IRId casted_obj;
        IRSpanInfo casted_info;
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass() || obj.hashCode() != this.hashCode()) {
            return false;
        }
        IRStore casted = (IRStore)obj;
        IRSpanInfo temp_info = this.getInfo();
        if (temp_info != (casted_info = casted.getInfo()) && !temp_info.equals(casted_info)) {
            return false;
        }
        IRId temp_obj = this.getObj();
        if (temp_obj != (casted_obj = casted.getObj()) && !temp_obj.equals(casted_obj)) {
            return false;
        }
        IRExpr temp_index = this.getIndex();
        if (temp_index != (casted_index = casted.getIndex()) && !temp_index.equals(casted_index)) {
            return false;
        }
        IRExpr temp_rhs = this.getRhs();
        return temp_rhs == (casted_rhs = casted.getRhs()) || temp_rhs.equals(casted_rhs);
    }

    @Override
    public int generateHashCode() {
        int code = this.getClass().hashCode();
        IRSpanInfo temp_info = this.getInfo();
        code ^= temp_info.hashCode();
        IRId temp_obj = this.getObj();
        code ^= temp_obj.hashCode();
        IRExpr temp_index = this.getIndex();
        code ^= temp_index.hashCode();
        IRExpr temp_rhs = this.getRhs();
        return code ^= temp_rhs.hashCode();
    }

    protected IRStore() {
        this._obj = null;
        this._index = null;
        this._rhs = null;
    }

    @Override
    public void walk(TreeWalker w) {
        if (w.visitNode(this, "IRStore", 4)) {
            IRExpr temp_rhs;
            IRExpr temp_index;
            IRId temp_obj;
            IRSpanInfo temp_info = this.getInfo();
            if (w.visitNodeField("info", temp_info)) {
                temp_info.walk(w);
                w.endNodeField("info", temp_info);
            }
            if (w.visitNodeField("obj", temp_obj = this.getObj())) {
                temp_obj.walk(w);
                w.endNodeField("obj", temp_obj);
            }
            if (w.visitNodeField("index", temp_index = this.getIndex())) {
                temp_index.walk(w);
                w.endNodeField("index", temp_index);
            }
            if (w.visitNodeField("rhs", temp_rhs = this.getRhs())) {
                temp_rhs.walk(w);
                w.endNodeField("rhs", temp_rhs);
            }
            w.endNode(this, "IRStore", 4);
        }
    }
}

