/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes;

import edu.rice.cs.plt.tuple.Option;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.StringReader;
import kr.ac.kaist.jsaf.nodes.RegExpAlternative;
import kr.ac.kaist.jsaf.nodes.RegExpAssertionCaret;
import kr.ac.kaist.jsaf.nodes.RegExpAssertionDollar;
import kr.ac.kaist.jsaf.nodes.RegExpAssertionEqual;
import kr.ac.kaist.jsaf.nodes.RegExpAssertionExcla;
import kr.ac.kaist.jsaf.nodes.RegExpAssertionLowerCaseB;
import kr.ac.kaist.jsaf.nodes.RegExpAssertionUpperCaseB;
import kr.ac.kaist.jsaf.nodes.RegExpAtom;
import kr.ac.kaist.jsaf.nodes.RegExpAtomQuantifier;
import kr.ac.kaist.jsaf.nodes.RegExpBaseDisjunction;
import kr.ac.kaist.jsaf.nodes.RegExpCapturingParensInfo;
import kr.ac.kaist.jsaf.nodes.RegExpCharacterClassEscape;
import kr.ac.kaist.jsaf.nodes.RegExpCharacterClassExclusion;
import kr.ac.kaist.jsaf.nodes.RegExpCharacterClassInclusion;
import kr.ac.kaist.jsaf.nodes.RegExpCharacterEscape;
import kr.ac.kaist.jsaf.nodes.RegExpClassAtom;
import kr.ac.kaist.jsaf.nodes.RegExpClassAtomDash;
import kr.ac.kaist.jsaf.nodes.RegExpClassAtomNoDashCharacter;
import kr.ac.kaist.jsaf.nodes.RegExpClassCharacterClassEscape;
import kr.ac.kaist.jsaf.nodes.RegExpClassCharacterEscape;
import kr.ac.kaist.jsaf.nodes.RegExpClassDecimalEscape;
import kr.ac.kaist.jsaf.nodes.RegExpClassEscapeB;
import kr.ac.kaist.jsaf.nodes.RegExpClassRanges;
import kr.ac.kaist.jsaf.nodes.RegExpClassRangesInfo;
import kr.ac.kaist.jsaf.nodes.RegExpConsAlternative;
import kr.ac.kaist.jsaf.nodes.RegExpConsDisjunction;
import kr.ac.kaist.jsaf.nodes.RegExpControlEscape;
import kr.ac.kaist.jsaf.nodes.RegExpControlLetter;
import kr.ac.kaist.jsaf.nodes.RegExpDecimalEscape;
import kr.ac.kaist.jsaf.nodes.RegExpDisjunction;
import kr.ac.kaist.jsaf.nodes.RegExpDot;
import kr.ac.kaist.jsaf.nodes.RegExpEmptyAlternative;
import kr.ac.kaist.jsaf.nodes.RegExpEmptyClassRanges;
import kr.ac.kaist.jsaf.nodes.RegExpHexEscapeSequence;
import kr.ac.kaist.jsaf.nodes.RegExpIdentityEscape;
import kr.ac.kaist.jsaf.nodes.RegExpNode;
import kr.ac.kaist.jsaf.nodes.RegExpNodeInfo;
import kr.ac.kaist.jsaf.nodes.RegExpNonemptyClassRanges;
import kr.ac.kaist.jsaf.nodes.RegExpNonemptyClassRangesAtom;
import kr.ac.kaist.jsaf.nodes.RegExpNonemptyClassRangesAtoms;
import kr.ac.kaist.jsaf.nodes.RegExpNonemptyClassRangesDash;
import kr.ac.kaist.jsaf.nodes.RegExpParen;
import kr.ac.kaist.jsaf.nodes.RegExpParenOpt;
import kr.ac.kaist.jsaf.nodes.RegExpPattern;
import kr.ac.kaist.jsaf.nodes.RegExpPatternChar;
import kr.ac.kaist.jsaf.nodes.RegExpQuantifier;
import kr.ac.kaist.jsaf.nodes.RegExpQuantifierNumber;
import kr.ac.kaist.jsaf.nodes.RegExpQuantifierPlus;
import kr.ac.kaist.jsaf.nodes.RegExpQuantifierPrefix;
import kr.ac.kaist.jsaf.nodes.RegExpQuantifierQuest;
import kr.ac.kaist.jsaf.nodes.RegExpQuantifierStar;
import kr.ac.kaist.jsaf.nodes.RegExpTerm;
import kr.ac.kaist.jsaf.nodes.RegExpUnicodeEscapeSequence;

public class RegExpNodeReader {
    protected BufferedReader in;
    protected char currentChar = (char)32;

    public static RegExpNode read(String s) throws IOException {
        return RegExpNodeReader.read(new StringReader(s));
    }

    public static RegExpNode read(Reader r) throws IOException {
        return new RegExpNodeReader(new BufferedReader(r)).readRegExpNode();
    }

    protected RegExpNodeReader(BufferedReader r) {
        this.in = r;
    }

    public RegExpNode readRegExpNode() throws IOException {
        String name = this.readWord();
        if (name.equals("_")) {
            return null;
        }
        if (name.equals("RegExpPattern:")) {
            return this.readRegExpPatternBody();
        }
        if (name.equals("RegExpBaseDisjunction:")) {
            return this.readRegExpBaseDisjunctionBody();
        }
        if (name.equals("RegExpConsDisjunction:")) {
            return this.readRegExpConsDisjunctionBody();
        }
        if (name.equals("RegExpEmptyAlternative:")) {
            return this.readRegExpEmptyAlternativeBody();
        }
        if (name.equals("RegExpConsAlternative:")) {
            return this.readRegExpConsAlternativeBody();
        }
        if (name.equals("RegExpAssertionCaret:")) {
            return this.readRegExpAssertionCaretBody();
        }
        if (name.equals("RegExpAssertionDollar:")) {
            return this.readRegExpAssertionDollarBody();
        }
        if (name.equals("RegExpAssertionLowerCaseB:")) {
            return this.readRegExpAssertionLowerCaseBBody();
        }
        if (name.equals("RegExpAssertionUpperCaseB:")) {
            return this.readRegExpAssertionUpperCaseBBody();
        }
        if (name.equals("RegExpAssertionEqual:")) {
            return this.readRegExpAssertionEqualBody();
        }
        if (name.equals("RegExpAssertionExcla:")) {
            return this.readRegExpAssertionExclaBody();
        }
        if (name.equals("RegExpPatternChar:")) {
            return this.readRegExpPatternCharBody();
        }
        if (name.equals("RegExpDot:")) {
            return this.readRegExpDotBody();
        }
        if (name.equals("RegExpDecimalEscape:")) {
            return this.readRegExpDecimalEscapeBody();
        }
        if (name.equals("RegExpControlEscape:")) {
            return this.readRegExpControlEscapeBody();
        }
        if (name.equals("RegExpControlLetter:")) {
            return this.readRegExpControlLetterBody();
        }
        if (name.equals("RegExpHexEscapeSequence:")) {
            return this.readRegExpHexEscapeSequenceBody();
        }
        if (name.equals("RegExpUnicodeEscapeSequence:")) {
            return this.readRegExpUnicodeEscapeSequenceBody();
        }
        if (name.equals("RegExpIdentityEscape:")) {
            return this.readRegExpIdentityEscapeBody();
        }
        if (name.equals("RegExpCharacterClassEscape:")) {
            return this.readRegExpCharacterClassEscapeBody();
        }
        if (name.equals("RegExpCharacterClassInclusion:")) {
            return this.readRegExpCharacterClassInclusionBody();
        }
        if (name.equals("RegExpCharacterClassExclusion:")) {
            return this.readRegExpCharacterClassExclusionBody();
        }
        if (name.equals("RegExpEmptyClassRanges:")) {
            return this.readRegExpEmptyClassRangesBody();
        }
        if (name.equals("RegExpNonemptyClassRangesAtom:")) {
            return this.readRegExpNonemptyClassRangesAtomBody();
        }
        if (name.equals("RegExpNonemptyClassRangesAtoms:")) {
            return this.readRegExpNonemptyClassRangesAtomsBody();
        }
        if (name.equals("RegExpNonemptyClassRangesDash:")) {
            return this.readRegExpNonemptyClassRangesDashBody();
        }
        if (name.equals("RegExpClassAtomDash:")) {
            return this.readRegExpClassAtomDashBody();
        }
        if (name.equals("RegExpClassAtomNoDashCharacter:")) {
            return this.readRegExpClassAtomNoDashCharacterBody();
        }
        if (name.equals("RegExpClassDecimalEscape:")) {
            return this.readRegExpClassDecimalEscapeBody();
        }
        if (name.equals("RegExpClassEscapeB:")) {
            return this.readRegExpClassEscapeBBody();
        }
        if (name.equals("RegExpClassCharacterEscape:")) {
            return this.readRegExpClassCharacterEscapeBody();
        }
        if (name.equals("RegExpClassCharacterClassEscape:")) {
            return this.readRegExpClassCharacterClassEscapeBody();
        }
        if (name.equals("RegExpParen:")) {
            return this.readRegExpParenBody();
        }
        if (name.equals("RegExpParenOpt:")) {
            return this.readRegExpParenOptBody();
        }
        if (name.equals("RegExpAtomQuantifier:")) {
            return this.readRegExpAtomQuantifierBody();
        }
        if (name.equals("RegExpQuantifier:")) {
            return this.readRegExpQuantifierBody();
        }
        if (name.equals("RegExpQuantifierStar:")) {
            return this.readRegExpQuantifierStarBody();
        }
        if (name.equals("RegExpQuantifierPlus:")) {
            return this.readRegExpQuantifierPlusBody();
        }
        if (name.equals("RegExpQuantifierQuest:")) {
            return this.readRegExpQuantifierQuestBody();
        }
        if (name.equals("RegExpQuantifierNumber:")) {
            return this.readRegExpQuantifierNumberBody();
        }
        if (name.equals("RegExpCapturingParensInfo:")) {
            return this.readRegExpCapturingParensInfoBody();
        }
        if (name.equals("RegExpClassRangesInfo:")) {
            return this.readRegExpClassRangesInfoBody();
        }
        throw this.error();
    }

    private RegExpPattern readRegExpPatternBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        this.readFieldDelim("disjunction = ");
        RegExpDisjunction read_disjunction = (RegExpDisjunction)this.readRegExpNode();
        return new RegExpPattern(read_info, read_disjunction);
    }

    private RegExpBaseDisjunction readRegExpBaseDisjunctionBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        this.readFieldDelim("a = ");
        RegExpAlternative read_a = (RegExpAlternative)this.readRegExpNode();
        return new RegExpBaseDisjunction(read_info, read_a);
    }

    private RegExpConsDisjunction readRegExpConsDisjunctionBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        this.readFieldDelim("a = ");
        RegExpAlternative read_a = (RegExpAlternative)this.readRegExpNode();
        this.readFieldDelim("d = ");
        RegExpDisjunction read_d = (RegExpDisjunction)this.readRegExpNode();
        return new RegExpConsDisjunction(read_info, read_a, read_d);
    }

    private RegExpEmptyAlternative readRegExpEmptyAlternativeBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        return new RegExpEmptyAlternative(read_info);
    }

    private RegExpConsAlternative readRegExpConsAlternativeBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        this.readFieldDelim("a = ");
        RegExpAlternative read_a = (RegExpAlternative)this.readRegExpNode();
        this.readFieldDelim("t = ");
        RegExpTerm read_t = (RegExpTerm)this.readRegExpNode();
        return new RegExpConsAlternative(read_info, read_a, read_t);
    }

    private RegExpAssertionCaret readRegExpAssertionCaretBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        return new RegExpAssertionCaret(read_info);
    }

    private RegExpAssertionDollar readRegExpAssertionDollarBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        return new RegExpAssertionDollar(read_info);
    }

    private RegExpAssertionLowerCaseB readRegExpAssertionLowerCaseBBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        return new RegExpAssertionLowerCaseB(read_info);
    }

    private RegExpAssertionUpperCaseB readRegExpAssertionUpperCaseBBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        return new RegExpAssertionUpperCaseB(read_info);
    }

    private RegExpAssertionEqual readRegExpAssertionEqualBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        this.readFieldDelim("d = ");
        RegExpDisjunction read_d = (RegExpDisjunction)this.readRegExpNode();
        return new RegExpAssertionEqual(read_info, read_d);
    }

    private RegExpAssertionExcla readRegExpAssertionExclaBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        this.readFieldDelim("d = ");
        RegExpDisjunction read_d = (RegExpDisjunction)this.readRegExpNode();
        return new RegExpAssertionExcla(read_info, read_d);
    }

    private RegExpPatternChar readRegExpPatternCharBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        this.readFieldDelim("str = ");
        String read_str = this.readString();
        return new RegExpPatternChar(read_info, read_str);
    }

    private RegExpDot readRegExpDotBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        return new RegExpDot(read_info);
    }

    private RegExpDecimalEscape readRegExpDecimalEscapeBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        this.readFieldDelim("str = ");
        String read_str = this.readString();
        return new RegExpDecimalEscape(read_info, read_str);
    }

    private RegExpControlEscape readRegExpControlEscapeBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        this.readFieldDelim("str = ");
        String read_str = this.readString();
        return new RegExpControlEscape(read_info, read_str);
    }

    private RegExpControlLetter readRegExpControlLetterBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        this.readFieldDelim("str = ");
        String read_str = this.readString();
        return new RegExpControlLetter(read_info, read_str);
    }

    private RegExpHexEscapeSequence readRegExpHexEscapeSequenceBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        this.readFieldDelim("str = ");
        String read_str = this.readString();
        return new RegExpHexEscapeSequence(read_info, read_str);
    }

    private RegExpUnicodeEscapeSequence readRegExpUnicodeEscapeSequenceBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        this.readFieldDelim("str = ");
        String read_str = this.readString();
        return new RegExpUnicodeEscapeSequence(read_info, read_str);
    }

    private RegExpIdentityEscape readRegExpIdentityEscapeBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        this.readFieldDelim("str = ");
        String read_str = this.readString();
        return new RegExpIdentityEscape(read_info, read_str);
    }

    private RegExpCharacterClassEscape readRegExpCharacterClassEscapeBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        this.readFieldDelim("str = ");
        String read_str = this.readString();
        return new RegExpCharacterClassEscape(read_info, read_str);
    }

    private RegExpCharacterClassInclusion readRegExpCharacterClassInclusionBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        this.readFieldDelim("r = ");
        RegExpClassRanges read_r = (RegExpClassRanges)this.readRegExpNode();
        return new RegExpCharacterClassInclusion(read_info, read_r);
    }

    private RegExpCharacterClassExclusion readRegExpCharacterClassExclusionBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        this.readFieldDelim("r = ");
        RegExpClassRanges read_r = (RegExpClassRanges)this.readRegExpNode();
        return new RegExpCharacterClassExclusion(read_info, read_r);
    }

    private RegExpEmptyClassRanges readRegExpEmptyClassRangesBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        return new RegExpEmptyClassRanges(read_info);
    }

    private RegExpNonemptyClassRangesAtom readRegExpNonemptyClassRangesAtomBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        this.readFieldDelim("a = ");
        RegExpClassAtom read_a = (RegExpClassAtom)this.readRegExpNode();
        return new RegExpNonemptyClassRangesAtom(read_info, read_a);
    }

    private RegExpNonemptyClassRangesAtoms readRegExpNonemptyClassRangesAtomsBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        this.readFieldDelim("a = ");
        RegExpClassAtom read_a = (RegExpClassAtom)this.readRegExpNode();
        this.readFieldDelim("r = ");
        RegExpNonemptyClassRanges read_r = (RegExpNonemptyClassRanges)this.readRegExpNode();
        return new RegExpNonemptyClassRangesAtoms(read_info, read_a, read_r);
    }

    private RegExpNonemptyClassRangesDash readRegExpNonemptyClassRangesDashBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        this.readFieldDelim("a1 = ");
        RegExpClassAtom read_a1 = (RegExpClassAtom)this.readRegExpNode();
        this.readFieldDelim("a2 = ");
        RegExpClassAtom read_a2 = (RegExpClassAtom)this.readRegExpNode();
        this.readFieldDelim("r = ");
        RegExpClassRanges read_r = (RegExpClassRanges)this.readRegExpNode();
        return new RegExpNonemptyClassRangesDash(read_info, read_a1, read_a2, read_r);
    }

    private RegExpClassAtomDash readRegExpClassAtomDashBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        return new RegExpClassAtomDash(read_info);
    }

    private RegExpClassAtomNoDashCharacter readRegExpClassAtomNoDashCharacterBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        this.readFieldDelim("str = ");
        String read_str = this.readString();
        return new RegExpClassAtomNoDashCharacter(read_info, read_str);
    }

    private RegExpClassDecimalEscape readRegExpClassDecimalEscapeBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        this.readFieldDelim("esc = ");
        RegExpDecimalEscape read_esc = (RegExpDecimalEscape)this.readRegExpNode();
        return new RegExpClassDecimalEscape(read_info, read_esc);
    }

    private RegExpClassEscapeB readRegExpClassEscapeBBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        return new RegExpClassEscapeB(read_info);
    }

    private RegExpClassCharacterEscape readRegExpClassCharacterEscapeBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        this.readFieldDelim("esc = ");
        RegExpCharacterEscape read_esc = (RegExpCharacterEscape)this.readRegExpNode();
        return new RegExpClassCharacterEscape(read_info, read_esc);
    }

    private RegExpClassCharacterClassEscape readRegExpClassCharacterClassEscapeBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        this.readFieldDelim("esc = ");
        RegExpCharacterClassEscape read_esc = (RegExpCharacterClassEscape)this.readRegExpNode();
        return new RegExpClassCharacterClassEscape(read_info, read_esc);
    }

    private RegExpParen readRegExpParenBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        this.readFieldDelim("disjunction = ");
        RegExpDisjunction read_disjunction = (RegExpDisjunction)this.readRegExpNode();
        return new RegExpParen(read_info, read_disjunction);
    }

    private RegExpParenOpt readRegExpParenOptBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        this.readFieldDelim("disjunction = ");
        RegExpDisjunction read_disjunction = (RegExpDisjunction)this.readRegExpNode();
        return new RegExpParenOpt(read_info, read_disjunction);
    }

    private RegExpAtomQuantifier readRegExpAtomQuantifierBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        this.readFieldDelim("atom = ");
        RegExpAtom read_atom = (RegExpAtom)this.readRegExpNode();
        this.readFieldDelim("quant = ");
        RegExpQuantifier read_quant = (RegExpQuantifier)this.readRegExpNode();
        return new RegExpAtomQuantifier(read_info, read_atom, read_quant);
    }

    private RegExpQuantifier readRegExpQuantifierBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        this.readFieldDelim("prefix = ");
        RegExpQuantifierPrefix read_prefix = (RegExpQuantifierPrefix)this.readRegExpNode();
        this.readFieldDelim("greedy = ");
        boolean read_greedy = this.readBoolean();
        return new RegExpQuantifier(read_info, read_prefix, read_greedy);
    }

    private RegExpQuantifierStar readRegExpQuantifierStarBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        return new RegExpQuantifierStar(read_info);
    }

    private RegExpQuantifierPlus readRegExpQuantifierPlusBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        return new RegExpQuantifierPlus(read_info);
    }

    private RegExpQuantifierQuest readRegExpQuantifierQuestBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        return new RegExpQuantifierQuest(read_info);
    }

    private RegExpQuantifierNumber readRegExpQuantifierNumberBody() throws IOException {
        this.readFieldDelim("info = ");
        RegExpNodeInfo read_info = (RegExpNodeInfo)this.readRegExpNode();
        this.readFieldDelim("first = ");
        Integer read_first = (Integer)this.readUnknownObject();
        this.readFieldDelim("second = ");
        Option<Integer> read_second = this.readOptionOfInteger();
        return new RegExpQuantifierNumber(read_info, read_first, read_second);
    }

    private RegExpCapturingParensInfo readRegExpCapturingParensInfoBody() throws IOException {
        this.readFieldDelim("parenCount = ");
        int read_parenCount = this.readInt();
        return new RegExpCapturingParensInfo(read_parenCount);
    }

    private RegExpClassRangesInfo readRegExpClassRangesInfoBody() throws IOException {
        this.readFieldDelim("noCaret = ");
        boolean read_noCaret = this.readBoolean();
        return new RegExpClassRangesInfo(read_noCaret);
    }

    private Option<Integer> readOptionOfInteger() throws IOException {
        if (this.readOptionHeader()) {
            Integer elt_result = (Integer)this.readUnknownObject();
            this.readExpected(")");
            return Option.some((Object)elt_result);
        }
        return Option.none();
    }

    protected boolean readBoolean() throws IOException {
        char c;
        char t = c = this.readCharWord();
        while (!Character.isWhitespace(t)) {
            t = this.next();
        }
        if (c == 't') {
            return true;
        }
        if (c == 'f') {
            return false;
        }
        throw this.error();
    }

    protected char readChar() throws IOException {
        this.readExpected("\"");
        String word = this.readTo('\"', true);
        String result = this.unescape(word);
        if (result.length() != 1) {
            throw this.error();
        }
        return result.charAt(0);
    }

    protected byte readByte() throws IOException {
        String word = this.readNum();
        try {
            return Byte.parseByte(word);
        }
        catch (NumberFormatException e) {
            throw this.error();
        }
    }

    protected short readShort() throws IOException {
        String word = this.readNum();
        try {
            return Short.parseShort(word);
        }
        catch (NumberFormatException e) {
            throw this.error();
        }
    }

    protected int readInt() throws IOException {
        String word = this.readNum();
        try {
            return Integer.parseInt(word);
        }
        catch (NumberFormatException e) {
            throw this.error();
        }
    }

    protected long readLong() throws IOException {
        String word = this.readNum();
        try {
            return Long.parseLong(word);
        }
        catch (NumberFormatException e) {
            throw this.error();
        }
    }

    protected float readFloat() throws IOException {
        String word = this.readWord();
        try {
            return Float.parseFloat(word);
        }
        catch (NumberFormatException e) {
            throw this.error();
        }
    }

    protected double readDouble() throws IOException {
        String word = this.readWord();
        try {
            return Double.parseDouble(word);
        }
        catch (NumberFormatException e) {
            throw this.error();
        }
    }

    protected String readString() throws IOException {
        char delim = this.readCharWord();
        if (delim == '_') {
            return null;
        }
        if (delim != '\"') {
            throw this.error();
        }
        this.next();
        String word = this.readTo('\"', true);
        return this.unescape(word);
    }

    protected Object wordToUnknownObject(String word) throws IOException {
        if (word.equals("_")) {
            return null;
        }
        ObjectInputStream objIn = this.toObjectStream(word);
        try {
            Object object = objIn.readObject();
            return object;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("ClassNotFoundException: " + e.getMessage());
        }
        finally {
            try {
                objIn.close();
            }
            catch (IOException e) {}
        }
    }

    protected Object readUnknownObject() throws IOException {
        String word = this.readWord();
        this.readToNewline();
        return this.wordToUnknownObject(word);
    }

    protected String readWord() throws IOException {
        char c = this.readCharWord();
        StringBuilder result = new StringBuilder();
        do {
            result.append(c);
        } while (!Character.isWhitespace(c = this.next()));
        return result.toString();
    }

    protected String readNum() throws IOException {
        char c = this.readCharWord();
        StringBuilder result = new StringBuilder();
        if (c != '-' && !Character.isDigit(c)) {
            throw this.error();
        }
        do {
            result.append(c);
        } while (Character.isDigit(c = this.next()));
        return result.toString();
    }

    protected char readCharWord() throws IOException {
        char c = this.currentChar;
        while (Character.isWhitespace(c)) {
            c = this.next();
        }
        return c;
    }

    protected void readExpected(String s) throws IOException {
        char c = this.readCharWord();
        for (int i = 0; i < s.length(); ++i) {
            if (c != s.charAt(i)) {
                System.out.println("Was expecting '" + s + "', saw '" + c + "' instead of '" + s.charAt(i) + "'");
                throw this.error();
            }
            c = this.next();
        }
    }

    protected void readFieldDelim(String s) throws IOException {
        this.readExpected(s);
    }

    protected boolean readMoreListElements() throws IOException {
        char c = this.readCharWord();
        if (c == '}') {
            this.next();
            return false;
        }
        if (c == '*') {
            this.next();
            return true;
        }
        throw this.error();
    }

    protected boolean readOptionHeader() throws IOException {
        char c = this.readCharWord();
        if (c == '~') {
            this.next();
            return false;
        }
        if (c == '(') {
            this.next();
            return true;
        }
        throw this.error();
    }

    protected String readTo(char delim, boolean skipEscape) throws IOException {
        StringBuilder result = new StringBuilder();
        boolean escape2 = false;
        char c = this.curr();
        while (escape2 || c != delim) {
            if (c == '\n' || c == '\r') {
                throw this.error();
            }
            result.append(c);
            if (escape2) {
                escape2 = false;
            } else if (skipEscape && c == '\\') {
                escape2 = true;
            }
            c = this.next();
        }
        this.next();
        return result.toString();
    }

    protected char skipTo(char ... delims) throws IOException {
        char c = this.currentChar;
        while (true) {
            if (c == '\n' || c == '\r') {
                throw this.error();
            }
            for (char delim : delims) {
                if (c != delim) continue;
                return delim;
            }
            c = this.next();
        }
    }

    protected String readToNewline() throws IOException {
        String result = this.in.readLine();
        if (result == null) {
            throw this.error();
        }
        this.readCharWord();
        return result;
    }

    protected char next() throws IOException {
        int c = this.in.read();
        if (c == -1) {
            throw this.error();
        }
        this.currentChar = (char)c;
        return this.currentChar;
    }

    protected char curr() {
        return this.currentChar;
    }

    protected String unescape(String s) throws IOException {
        boolean escape2 = false;
        StringBuilder digits = new StringBuilder();
        boolean changed = false;
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (escape2) {
                switch (c) {
                    case 'b': {
                        result.append('\b');
                        break;
                    }
                    case 't': {
                        result.append('\t');
                        break;
                    }
                    case 'n': {
                        result.append('\n');
                        break;
                    }
                    case 'f': {
                        result.append('\f');
                        break;
                    }
                    case 'r': {
                        result.append('\r');
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        result.append(c);
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        digits.append(c);
                        if (digits.length() != 3) break;
                        result.append((char)Integer.parseInt(digits.toString(), 8));
                        digits.setLength(0);
                        break;
                    }
                    default: {
                        throw this.error();
                    }
                }
                if (digits.length() != 0) continue;
                escape2 = false;
                continue;
            }
            if (c == '\\') {
                escape2 = true;
                changed = true;
                continue;
            }
            result.append(c);
        }
        if (escape2) {
            throw this.error();
        }
        return changed ? result.toString() : s;
    }

    protected ObjectInputStream toObjectStream(String byteString) throws IOException {
        if (byteString.length() % 2 != 0) {
            throw this.error();
        }
        int length2 = byteString.length() / 2;
        byte[] bytes = new byte[length2];
        for (int i = 0; i < length2; ++i) {
            String b = byteString.substring(i * 2, i * 2 + 2);
            try {
                int unsigned = Integer.parseInt(b, 16);
                if (unsigned < 128) {
                    bytes[i] = (byte)unsigned;
                    continue;
                }
                bytes[i] = (byte)(unsigned - 256);
                continue;
            }
            catch (NumberFormatException e) {
                throw this.error();
            }
        }
        return new ObjectInputStream(new ByteArrayInputStream(bytes));
    }

    protected IOException error() {
        return new IOException("Serialized data is not properly encoded");
    }
}

