/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class TabPrintWriter
extends PrintWriter {
    private final int _tabSize;
    private int _numSpaces;

    public TabPrintWriter(Writer writer, int tabSize) {
        super(writer);
        this._tabSize = tabSize;
        this._numSpaces = 0;
    }

    public void indent() {
        this._numSpaces += this._tabSize;
    }

    public void unindent() {
        this._numSpaces -= this._tabSize;
    }

    public void startLine(Object s) {
        this.startLine();
        this.print(s);
    }

    public void startLine() {
        this.println();
        for (int i = 0; i < this._numSpaces; ++i) {
            this.print(' ');
        }
    }

    public void printEscaped(Object o) {
        this.printEscaped(o.toString());
    }

    public void printEscaped(String s) {
        block10: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\b': {
                    this.print("\\b");
                    continue block10;
                }
                case '\t': {
                    this.print("\\t");
                    continue block10;
                }
                case '\n': {
                    this.print("\\n");
                    continue block10;
                }
                case '\f': {
                    this.print("\\f");
                    continue block10;
                }
                case '\r': {
                    this.print("\\r");
                    continue block10;
                }
                case '\"': {
                    this.print("\\\"");
                    continue block10;
                }
                case '\'': {
                    this.print("\\'");
                    continue block10;
                }
                case '\\': {
                    this.print("\\\\");
                    continue block10;
                }
                default: {
                    if (c < ' ' || c == '\u007f') {
                        this.print('\\');
                        String num = Integer.toOctalString(c);
                        while (num.length() < 3) {
                            num = "0" + num;
                        }
                        this.print(num);
                        continue block10;
                    }
                    this.print(c);
                }
            }
        }
    }

    public void printPossiblyEscaped(String s, boolean lossless) {
        if (lossless) {
            this.print("\"");
            this.printEscaped(s);
            this.print("\"");
        } else {
            this.print(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printSerialized(Object o) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        try (ObjectOutputStream objOut = new ObjectOutputStream(bs);){
            objOut.writeObject(o);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.printBytes(bs.toByteArray());
    }

    public void printPossiblySerialized(Object o, boolean lossless) {
        if (lossless) {
            this.printSerialized(o);
            this.print(" ");
            this.printEscaped(o);
        } else {
            this.print(o);
        }
    }

    private void printBytes(byte[] bs) {
        for (byte b : bs) {
            int unsigned = b & 0xFF;
            String num = Integer.toHexString(unsigned);
            if (num.length() == 1) {
                this.print("0");
            }
            this.print(num);
        }
    }

    public void startObject(String name) {
        this.print(name);
        this.indent();
    }
}

