/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes_util;

import edu.rice.cs.plt.tuple.Option;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import kr.ac.kaist.jsaf.exceptions.JSAFError;
import kr.ac.kaist.jsaf.nodes.ASTNode;
import kr.ac.kaist.jsaf.nodes.ASTSpanInfo;
import kr.ac.kaist.jsaf.nodes.AbstractNode;
import kr.ac.kaist.jsaf.nodes.IRInfoNode;
import kr.ac.kaist.jsaf.nodes.Node;
import kr.ac.kaist.jsaf.nodes.ScopeBody;
import kr.ac.kaist.jsaf.nodes_util.Lex;
import kr.ac.kaist.jsaf.nodes_util.NodeFactory;
import kr.ac.kaist.jsaf.nodes_util.NodeReflection;
import kr.ac.kaist.jsaf.nodes_util.NodeUtil;
import kr.ac.kaist.jsaf.nodes_util.SourceLocRats;
import kr.ac.kaist.jsaf.nodes_util.Span;
import kr.ac.kaist.jsaf.nodes_util.Unicode;
import kr.ac.kaist.jsaf.useful.Pair;
import kr.ac.kaist.jsaf.useful.Useful;

public class Unprinter
extends NodeReflection {
    public Span lastSpan = NodeFactory.makeSpan("Unprinter generated.");
    Lex l;
    static Class[] oneSpanArg = new Class[]{Span.class};
    private static final int NORMAL = 0;
    private static final int SAW_BACKSLASH = 1;
    private static final int SAW_BACKSLASH_TICK = 2;

    public Unprinter(Lex l) {
        this.l = l;
    }

    public String lexAfter(String expected) throws IOException {
        this.expectPrefix(expected);
        return this.l.name(false);
    }

    public String readSpan() throws IOException {
        String fname = this.lastSpan.begin.getFileName();
        String next = this.l.name(false);
        if (next.startsWith("\"") && next.endsWith("\"")) {
            fname = Unprinter.deQuote(next).intern();
            next = this.lexAfter(":");
        }
        int line = Integer.parseInt(next, 10);
        int column = Integer.parseInt(this.lexAfter(":"), 10);
        SourceLocRats beginning = new SourceLocRats(fname, line, column, 0);
        next = this.l.name(false);
        SourceLocRats ending = beginning;
        if ("~".equals(next)) {
            next = this.l.name(false);
            boolean sawFile = false;
            if (next.startsWith("\"") && next.endsWith("\"")) {
                fname = Unprinter.deQuote(next).intern();
                next = this.lexAfter(":");
                sawFile = true;
            }
            int lineOrCol = Integer.parseInt(next);
            next = this.l.name(false);
            if (":".equals(next)) {
                line = lineOrCol;
                column = Integer.parseInt(this.l.name(false), 10);
                next = this.l.name(false);
            } else if (sawFile) {
                JSAFError.error("Saw f:l:c~f:l with no following colon");
            } else {
                column = lineOrCol;
            }
            ending = new SourceLocRats(fname, line, column, 0);
        }
        this.lastSpan = new Span(beginning, ending);
        if (next.length() == 0) {
            next = this.l.name();
        } else if (!")".equals(next)) {
            JSAFError.error("Did we expect this?");
        }
        return next;
    }

    @Override
    protected Constructor defaultConstructorFor(Class cl) {
        try {
            return cl.getDeclaredConstructor(oneSpanArg);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public Node read() throws IOException {
        this.l.lp();
        return this.readNode(this.l.name());
    }

    public Node readNode(String class_name) throws IOException {
        this.classFor(class_name);
        Node node = null;
        String next = this.l.name();
        if ("@".equals(next)) {
            next = this.readSpan();
        }
        try {
            node = this.makeNodeFromSpan(class_name, null, this.lastSpan);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            JSAFError.error("Error reading node type " + class_name);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            JSAFError.error("Error reading node type " + class_name);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            JSAFError.error("Error reading node type " + class_name);
        }
        try {
            while (!")".equals(next)) {
                Field f = this.fieldFor(class_name, next);
                this.expectPrefix("=");
                if (f.getType() == List.class) {
                    this.expectPrefix("[");
                    f.set(node, this.readList());
                } else if (f.getType() == Map.class) {
                    this.expectPrefix("(Map");
                    f.set(node, this.readMap());
                } else if (f.getType() == Pair.class) {
                    this.expectPrefix("(Pair");
                    f.set(node, this.readPair());
                } else if (f.getType() == String.class) {
                    f.set(node, Unprinter.deQuote(this.l.name()).intern());
                } else if (f.getType() == Integer.TYPE) {
                    f.setInt(node, this.readInt(this.l.name()));
                } else if (f.getType() == Boolean.TYPE) {
                    f.setBoolean(node, this.readBoolean(this.l.name()));
                } else if (f.getType() == Double.TYPE) {
                    f.setDouble(node, this.readDouble(this.l.string()));
                } else if (f.getType() == BigInteger.class) {
                    f.set(node, this.readBigInteger(this.l.name()));
                } else if (f.getType() == Double.class) {
                    f.set(node, this.readDouble(this.l.name() + "." + this.lexAfter(".")));
                } else if (Option.class.isAssignableFrom(f.getType())) {
                    f.set(node, this.readOption());
                } else if (ASTSpanInfo.class.isAssignableFrom(f.getType())) {
                    f.set(node, this.readASTSpanInfo(NodeUtil.getSpan((ASTNode)node)));
                } else if (AbstractNode.class.isAssignableFrom(f.getType()) || ScopeBody.class.isAssignableFrom(f.getType()) || IRInfoNode.class.isAssignableFrom(f.getType())) {
                    this.expectPrefix("(");
                    f.set(node, this.readNode(this.l.name()));
                }
                next = this.l.name();
            }
            for (Field f : this.fieldArrayFor(class_name)) {
                Class<?> fcl = f.getType();
                if (fcl.isPrimitive() || f.get(node) != null) continue;
                if (fcl == List.class) {
                    f.set(node, Collections.EMPTY_LIST);
                    continue;
                }
                if (fcl == String.class) {
                    f.set(node, "");
                    continue;
                }
                if (fcl == Option.class) {
                    f.set(node, Option.none());
                    continue;
                }
                JSAFError.error("Unexpected missing data, field " + f.getName() + " of class " + class_name);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            JSAFError.error("Error reading node type " + class_name);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            JSAFError.error("Error reading node type " + class_name);
        }
        catch (IOException e) {
            e.printStackTrace();
            JSAFError.error("Error reading node type " + class_name);
        }
        return node;
    }

    public void expectPrefix(String string) throws IOException {
        this.l.expectPrefix(string);
    }

    public static String deQuote(CharSequence s) {
        int l = s.length();
        if (s.charAt(0) != '\"') {
            JSAFError.error("Malformed input, missing initial \"");
        }
        if (s.charAt(l - 1) != '\"') {
            JSAFError.error("Malformed input, missing final \"");
        }
        StringBuilder sb = new StringBuilder(l - 2);
        StringBuilder escaped = null;
        int state = 0;
        for (int i = 1; i < l - 1; ++i) {
            char c = s.charAt(i);
            if (state == 0) {
                if (c == '\"') {
                    JSAFError.error("Malformed input, unescaped \" seen at position " + i);
                    continue;
                }
                if (c == '\\') {
                    state = 1;
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (state == 1) {
                if (c == 'b') {
                    sb.append('\b');
                    state = 0;
                    continue;
                }
                if (c == 't') {
                    sb.append('\t');
                    state = 0;
                    continue;
                }
                if (c == 'n') {
                    sb.append('\n');
                    state = 0;
                    continue;
                }
                if (c == 'f') {
                    sb.append('\f');
                    state = 0;
                    continue;
                }
                if (c == 'r') {
                    sb.append('\r');
                    state = 0;
                    continue;
                }
                if (c == 'v') {
                    sb.append('\u000b');
                    state = 0;
                    continue;
                }
                if (c == '\"') {
                    sb.append('\"');
                    state = 0;
                    continue;
                }
                if (c == '\\') {
                    sb.append("\\\\");
                    state = 0;
                    continue;
                }
                if (c == '\'') {
                    state = 2;
                    escaped = new StringBuilder();
                    continue;
                }
                if (File.separator.equals("\\")) {
                    sb.append('\\');
                    state = 0;
                    continue;
                }
                JSAFError.error("Malformed input, unexpected backslash escape " + c + "(hex " + Integer.toHexString(c) + ") at index " + i);
                continue;
            }
            if (state != 2) continue;
            if (c == '\'') {
                state = 0;
                if (escaped.length() == 0) {
                    sb.append('\'');
                    continue;
                }
                if (Character.isDigit(escaped.charAt(0))) {
                    try {
                        int fromHex = Integer.parseInt(escaped.toString(), 16);
                        if (fromHex < 0 || fromHex > 65535) {
                            JSAFError.error("Unicode " + escaped + " too large for Java-hosted tool");
                        }
                        sb.append((char)fromHex);
                    }
                    catch (NumberFormatException ex) {
                        JSAFError.error("Malformed hex encoding " + escaped);
                    }
                    continue;
                }
                Unprinter.translateUnicode(escaped.toString(), sb);
                continue;
            }
            escaped.append(c);
        }
        return sb.toString();
    }

    private static void translateUnicode(String escaped, StringBuilder sb) {
        StringTokenizer st = new StringTokenizer(escaped, "&", false);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            String mapped = Unicode.byNameLC(tok);
            if (Character.isUpperCase(tok.charAt(0))) {
                mapped = mapped.toUpperCase();
            }
            sb.append(mapped);
        }
    }

    public static String enQuote(CharSequence s) {
        StringBuilder sb = new StringBuilder(s.length() + 2);
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            char c = s.charAt(i);
            if (Unprinter.needsBackslash(c)) {
                sb.append('\\');
                sb.append(Unprinter.afterBackslash(c).charValue());
                continue;
            }
            if (Unprinter.needsUnicoding(c)) {
                sb.append('\\');
                sb.append('\'');
                String hex = Integer.toHexString(c);
                if (hex.length() < 2 || hex.charAt(0) > '9') {
                    sb.append('0');
                }
                sb.append(hex);
                sb.append('\'');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static boolean needsUnicoding(char c) {
        return c < ' ' || c > '~';
    }

    private static boolean needsBackslash(char c) {
        return c == '\b' || c == '\t' || c == '\n' || c == '\f' || c == '\r' || c == '\u000b' || c == '\"' || c == '\\';
    }

    private static Character afterBackslash(char c) {
        switch (c) {
            case '\b': {
                return Character.valueOf('b');
            }
            case '\t': {
                return Character.valueOf('t');
            }
            case '\n': {
                return Character.valueOf('n');
            }
            case '\f': {
                return Character.valueOf('f');
            }
            case '\r': {
                return Character.valueOf('r');
            }
            case '\u000b': {
                return Character.valueOf('v');
            }
            case '\"': {
                return Character.valueOf('\"');
            }
            case '\'': {
                return Character.valueOf('\'');
            }
            case '\\': {
                return Character.valueOf('\\');
            }
        }
        JSAFError.error("Invalid input, character value 0x" + Integer.toHexString(c));
        return Character.valueOf(' ');
    }

    private Pair<Object, Object> readPair() throws IOException {
        Object x = this.readElement();
        Object y = this.readElement();
        this.expectPrefix(")");
        return new Pair<Object, Object>(x, y);
    }

    public ASTSpanInfo readASTSpanInfo(Span span) throws IOException {
        ASTSpanInfo info;
        this.expectPrefix("(");
        String s = this.l.name();
        if ("ASTSpanInfo".equals(s)) {
            this.expectPrefix("(");
            s = this.l.name(false);
            if (")".equals(s)) {
                info = NodeFactory.makeSpanInfo(span);
            } else {
                info = NodeFactory.makeSpanInfo(span, Unprinter.deQuote(s).intern());
                s = this.l.name(false);
            }
            this.expectPrefix(")");
        } else {
            JSAFError.error(s + " is not a valid subclass of ASTSpanInfo.");
            info = NodeFactory.makeSpanInfo(span);
        }
        return info;
    }

    public Map<String, Object> readMap() throws IOException {
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        String s = this.l.name();
        while (true) {
            if ("!".equals(s)) {
                String name = this.readIdentifier();
                this.expectPrefix("=");
                Object obj = this.readElement();
                map2.put(name, obj);
            } else if (")".equals(s)) {
                return map2;
            }
            s = this.l.name();
        }
    }

    private Object readElement() throws IOException {
        String a = this.l.name();
        if ("(".equals(a)) {
            return this.readThing();
        }
        if ("[".equals(a)) {
            return this.readList();
        }
        if (a.startsWith("\"")) {
            return Unprinter.deQuote(a).intern();
        }
        JSAFError.error("Pair of unknown stuff beginning " + a);
        return null;
    }

    int readInt(String s) throws IOException {
        return Integer.parseInt(s, 10);
    }

    private String readIdentifier() throws IOException {
        return this.l.name();
    }

    double readDouble(String s) throws IOException {
        if (s.endsWith("e") || s.endsWith("E")) {
            return Double.parseDouble(s + this.l.string());
        }
        return Double.parseDouble(s);
    }

    boolean readBoolean(String s) throws IOException {
        return Boolean.parseBoolean(s);
    }

    BigInteger readBigInteger(String s) throws IOException {
        return new BigInteger(s);
    }

    public List<Object> readList() throws IOException {
        String s = this.l.name();
        ArrayList<List<Object>> a = new ArrayList<List<Object>>();
        while (true) {
            Object x;
            if ("(".equals(s)) {
                x = this.readThing();
            } else if ("[".equals(s)) {
                x = this.readList();
            } else if (s.startsWith("\"")) {
                x = Unprinter.deQuote(s).intern();
            } else {
                if (s.startsWith("]")) {
                    return Useful.immutableTrimmedList(a);
                }
                JSAFError.error("List of unknown element beginning " + s);
                return Useful.list();
            }
            a.add((List<Object>)x);
            s = this.l.name();
        }
    }

    private Object readThing() throws IOException {
        String s2 = this.l.name();
        Object x = "Pair".equals(s2) ? this.readPair() : ("Some".equals(s2) ? this.readOptionTail() : ("Map".equals(s2) ? this.readMap() : this.readNode(s2)));
        return x;
    }

    public Option<Object> readOption() throws IOException {
        this.expectPrefix("(Some");
        return this.readOptionTail();
    }

    private Option<Object> readOptionTail() throws IOException {
        String s = this.l.name();
        if (")".equals(s)) {
            return Option.none();
        }
        if (!"_value".equals(s)) {
            JSAFError.error("Expected '_value' saw '" + s + "'");
            return Option.none();
        }
        this.expectPrefix("=");
        s = this.l.name();
        Object x = "(".equals(s) ? this.readThing() : ("[".equals(s) ? this.readList() : (s.startsWith("\"") ? Unprinter.deQuote(s).intern() : null));
        this.expectPrefix(")");
        return Option.some(x);
    }
}

