/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.useful;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class Files {
    public static void rm(String name) throws IOException {
        File file = new File(name);
        if (file.exists() && !file.delete()) {
            throw new IOException();
        }
    }

    public static void mkdir(String name) throws IOException {
        if (!new File(name).mkdir()) {
            throw new IOException();
        }
    }

    public static void mv(String src, String dest) throws IOException {
        if (!new File(src).renameTo(new File(dest))) {
            throw new IOException();
        }
    }

    public static File[] ls(String name) {
        return new File(name).listFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cp(String src, String dest) throws FileNotFoundException, IOException {
        FileInputStream input = null;
        FileOutputStream output = null;
        try {
            input = new FileInputStream(new File(src));
            output = new FileOutputStream(new File(dest));
            int next = input.read();
            while (next != -1) {
                output.write(next);
                next = input.read();
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            finally {
                if (output != null) {
                    output.close();
                }
            }
        }
    }

    public static BufferedReader reader(String fileName) throws IOException {
        return new BufferedReader(new FileReader(fileName));
    }

    public static BufferedWriter writer(String fileName) throws IOException {
        return new BufferedWriter(new FileWriter(fileName));
    }

    public static String windowPathToUnixPath(String filename) {
        String result = filename.replaceAll("\\\\", "/");
        char drive = result.charAt(0);
        if (Character.isUpperCase(drive)) {
            result = Character.toLowerCase(drive) + result.substring(1);
        }
        return result;
    }

    public static String[] recursivelyMatchedls(String dirName, String regexStr) {
        File[] files = new File(dirName).listFiles();
        ArrayList<String> ret = new ArrayList<String>();
        for (File file : files) {
            if (file.getName().matches(regexStr)) {
                ret.add(file.getAbsolutePath());
            }
            if (!file.isDirectory()) continue;
            for (String fileName : Files.recursivelyMatchedls(file.getAbsolutePath(), regexStr)) {
                ret.add(fileName);
            }
        }
        return ret.toArray(new String[ret.size()]);
    }
}

