/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.useful;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import kr.ac.kaist.jsaf.useful.Useful;

public interface StringMap {
    public String get(String var1);

    public boolean isEmpty();

    public String getCompletely(String var1, int var2);

    public String getCompletely(String var1);

    public int getInt(String var1, int var2);

    public long getLong(String var1, long var2);

    public boolean getBoolean(String var1, boolean var2);

    public String get(String var1, String var2);

    public static class FromPair
    extends FromBase {
        private final String from;
        private final String to;

        public FromPair(String from, String to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public String get(String s) {
            return s.equals(this.from) ? this.to : null;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    public static class ComposedMaps
    extends FromBase
    implements StringMap {
        private final StringMap[] ma;

        @Override
        public String get(String s) {
            String a = null;
            for (StringMap m : this.ma) {
                a = m.get(s);
                if (a == null) continue;
                return a;
            }
            return a;
        }

        @Override
        public boolean isEmpty() {
            return this.ma.length == 0;
        }

        public ComposedMaps(StringMap ... maps) {
            int ne = 0;
            for (StringMap m : maps) {
                if (m.isEmpty()) continue;
                ++ne;
            }
            this.ma = new StringMap[ne];
            ne = 0;
            for (StringMap m : maps) {
                if (m.isEmpty()) continue;
                this.ma[ne] = m;
                ++ne;
            }
        }
    }

    public static class FromReflection
    extends FromBase
    implements StringMap {
        private final Class mapClass;
        private final String optionalPrefix;

        public FromReflection(Class cl) {
            this.mapClass = cl;
            this.optionalPrefix = null;
        }

        public FromReflection(Class cl, String optional_prefix) {
            this.mapClass = cl;
            this.optionalPrefix = optional_prefix;
        }

        @Override
        public String get(String s) {
            String result = this.getOne(s);
            if (result == null && this.optionalPrefix != null && s.startsWith(this.optionalPrefix)) {
                result = this.getOne(s.substring(this.optionalPrefix.length()));
            }
            return result;
        }

        private String getOne(String s) {
            try {
                s = FromEnv.asEnvOrReflect(s);
                Field f = this.mapClass.getDeclaredField(s);
                return f.get(null).toString();
            }
            catch (SecurityException e) {
                return null;
            }
            catch (NoSuchFieldException e) {
                return null;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
            catch (NullPointerException e) {
                return null;
            }
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    public static class FromFileProps
    extends FromProps
    implements StringMap {
        static Properties fromFile(String filename) {
            Properties p = null;
            try {
                FileInputStream fs = new FileInputStream(filename);
                InputStreamReader ir = new InputStreamReader((InputStream)fs, Charset.forName("UTF-8"));
                BufferedReader bis = new BufferedReader(ir);
                Properties tmp_p = new Properties();
                tmp_p.load(bis);
                p = tmp_p;
                bis.close();
                ir.close();
                fs.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return p;
        }

        public FromFileProps(String filename) {
            super(FromFileProps.fromFile(filename));
        }
    }

    public static class FromSysProps
    extends FromBase
    implements StringMap {
        @Override
        public String get(String s) {
            return System.getProperty(s);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    public static class FromMap
    extends FromBase
    implements StringMap {
        Map<String, String> p;

        public FromMap(Map<String, String> p) {
            this.p = p;
        }

        @Override
        public String get(String s) {
            return this.p.get(s);
        }

        @Override
        public boolean isEmpty() {
            return this.p == null;
        }
    }

    public static class FromProps
    extends FromBase
    implements StringMap {
        Properties p;

        FromProps(Properties p) {
            this.p = p;
        }

        @Override
        public String get(String s) {
            return this.p.getProperty(s);
        }

        @Override
        public boolean isEmpty() {
            return this.p == null;
        }
    }

    public static class FromEnv
    extends FromBase
    implements StringMap {
        @Override
        public String get(String s) {
            s = FromEnv.asEnvOrReflect(s);
            String t = System.getenv(s);
            return t;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        public static String asEnvOrReflect(String s) {
            s = s.toUpperCase();
            s = s.replace('.', '_');
            s = s.replace('-', '_');
            return s;
        }
    }

    public static abstract class FromBase
    implements StringMap {
        @Override
        public String getCompletely(String s, int limit) {
            if (s == null) {
                return s;
            }
            return Useful.substituteVarsCompletely(s, this, limit);
        }

        @Override
        public int getInt(String s, int ifMissing) {
            String result = this.get(s);
            if (result != null) {
                result = this.getCompletely(result, 1000);
            }
            if (result == null) {
                return ifMissing;
            }
            if (result.length() == 0) {
                return ifMissing;
            }
            int base = 10;
            int underat = result.indexOf(95);
            if (underat != -1) {
                base = Integer.parseInt(result.substring(underat + 1));
                result = result.substring(0, underat);
            }
            return Integer.parseInt(result, base);
        }

        @Override
        public long getLong(String s, long ifMissing) {
            String result = this.get(s);
            if (result != null) {
                result = this.getCompletely(result, 1000);
            }
            if (result == null) {
                return ifMissing;
            }
            if (result.length() == 0) {
                return ifMissing;
            }
            int base = 10;
            int underat = result.indexOf(95);
            if (underat != -1) {
                base = Integer.parseInt(result.substring(underat + 1));
                result = result.substring(0, underat);
            }
            return Long.parseLong(result, base);
        }

        @Override
        public final boolean getBoolean(String s, boolean ifMissing) {
            String result = this.get(s);
            if (result != null) {
                result = this.getCompletely(result, 1000);
            }
            if (result == null) {
                return ifMissing;
            }
            if (result.length() == 0) {
                return true;
            }
            s = result.toLowerCase();
            char c = result.charAt(0);
            if (c == 'y' || c == 't' || c == '1') {
                return true;
            }
            if (c == 'n' || c == 'f' || c == '0') {
                return false;
            }
            throw new Error("Unexpected definition of prop/env " + s + ", got " + result + ", need t/f/y/n/1/0[...]");
        }

        @Override
        public final String get(String s, String ifMissing) {
            String result = this.get(s);
            if (result == null) {
                result = ifMissing;
            }
            if (result != null) {
                result = this.getCompletely(result, 1000);
            }
            if (result == null) {
                throw new Error("Must supply a definition (as property, environment variable, or repository configuration property) for " + s);
            }
            return result;
        }

        @Override
        public String getCompletely(String s) {
            return this.getCompletely(s, 1000);
        }

        @Override
        public abstract String get(String var1);

        @Override
        public abstract boolean isEmpty();
    }
}

