/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.useful;

import java.io.IOException;
import java.io.PrintStream;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import kr.ac.kaist.jsaf.useful.WireTappedPrintStream;

public abstract class TestCaseWrapper
extends TestCase
implements TestListener {
    private static final boolean failsOnly = true;
    private boolean anyFail;
    PrintStream oldOut;
    PrintStream oldErr;
    WireTappedPrintStream wt_err;
    WireTappedPrintStream wt_out;

    public void run(TestResult result) {
        result.addListener((TestListener)this);
        this.anyFail = false;
        this.oldOut = System.out;
        this.oldErr = System.err;
        this.wt_err = WireTappedPrintStream.make(System.err, true);
        this.wt_out = WireTappedPrintStream.make(System.out, true);
        System.setErr(this.wt_err);
        System.setOut(this.wt_out);
        super.run(result);
        System.setErr(this.oldErr);
        System.setOut(this.oldOut);
        System.out.println("  " + this.toString() + (this.anyFail ? " FAIL" : " OK"));
        try {
            this.wt_err.flush(this.anyFail);
            this.wt_out.flush(this.anyFail);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        result.removeListener((TestListener)this);
    }

    public TestCaseWrapper() {
    }

    public TestCaseWrapper(String arg0) {
        super(arg0);
    }

    public void addError(Test test, Throwable t) {
        this.anyFail = true;
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.anyFail = true;
    }

    public void endTest(Test test) {
    }

    public void startTest(Test test) {
    }
}

