/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.memoryanalysis.referencecounter.heap;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.functions.VoidFunction;
import com.samsung.memoryanalysis.context.Context;
import com.samsung.memoryanalysis.referencecounter.heap.ContextOrObjectId;
import com.samsung.memoryanalysis.referencecounter.heap.HeapEdge;
import com.samsung.memoryanalysis.referencecounter.heap.NamedEdge;
import com.samsung.memoryanalysis.referencecounter.heap.NamedMultiEdge;
import com.samsung.memoryanalysis.referencecounter.heap.Unreachability;
import com.samsung.memoryanalysis.traceparser.Timer;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ReferenceCountedHeapGraph {
    private static final String DOM_CHILD_EDGE_NAME = "~dom-child~";
    public static final String PARENT_CONTEXT_FIELD = "~PARENT-CONTEXT~";
    private final Deque<Set<ContextOrObjectId>> candidates = new ArrayDeque<Set<ContextOrObjectId>>();
    private final Map<ContextOrObjectId, IIDAndTime> cycleQueue = HashMapFactory.make();
    private final Set<ContextOrObjectId> markSet = HashSetFactory.make();
    protected VoidFunction<Unreachability> unreachableCallback;
    private int cycleQueueLimit = 50000;
    private Timer timer = null;
    private final Map<Long, ParentContextAndFunId> resurrectedContexts = HashMapFactory.make();
    private boolean noCycleCollection = false;

    public ReferenceCountedHeapGraph() {
        this.unreachableCallback = new VoidFunction<Unreachability>(){

            public void apply(Unreachability v) {
            }
        };
    }

    public void setCycleQueueLimit(int cycleQueueLimit) {
        this.cycleQueueLimit = cycleQueueLimit;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public abstract void newNode(ContextOrObjectId var1);

    protected abstract void addEdge(NamedEdge var1, ContextOrObjectId var2);

    protected abstract void addNamedMultiEdge(NamedMultiEdge var1);

    protected abstract void removeEdge(HeapEdge var1);

    protected abstract void removeNode(ContextOrObjectId var1);

    protected abstract Iterator<ContextOrObjectId> bfsIterator(ContextOrObjectId var1);

    protected abstract Iterator<ContextOrObjectId> bfsIterator();

    public abstract Set<HeapEdge> getOutEdges(ContextOrObjectId var1);

    public abstract Set<NamedEdge> getNamedOutEdges(ContextOrObjectId var1);

    public abstract ContextOrObjectId getTarget(HeapEdge var1);

    protected abstract int referenceCount(ContextOrObjectId var1);

    public void setUnreachableCallback(VoidFunction<Unreachability> f) {
        this.unreachableCallback = f;
    }

    public void newObject(int objectId) {
        this.newNode(ContextOrObjectId.make(objectId));
    }

    public void newContext(Context ctx, int funId) {
        Context parentOp = ctx.getParent();
        this.candidates.push(HashSetFactory.make());
        this.newNode(ContextOrObjectId.make(ctx));
        if (parentOp != null) {
            this.addParentReference(ctx, parentOp, funId);
        }
    }

    protected boolean isCandidate(ContextOrObjectId node) {
        for (Set<ContextOrObjectId> candidateSet : this.candidates) {
            if (!candidateSet.contains(node)) continue;
            return true;
        }
        return false;
    }

    private void addParentReference(Context child, Context parent, int funId) {
        ContextOrObjectId childNode = ContextOrObjectId.make(child);
        ContextOrObjectId parentNode = ContextOrObjectId.make(parent);
        if (!this.containsNode(parentNode)) {
            this.reMakeContext(parentNode);
            this.resurrectedContexts.put(this.timer.currentTime(), new ParentContextAndFunId(parent.toString(), funId));
        }
        NamedEdge newEdge = new NamedEdge(childNode, PARENT_CONTEXT_FIELD);
        this.addEdge(newEdge, parentNode);
    }

    private void reMakeContext(ContextOrObjectId parentNode) {
        assert (parentNode.type == ContextOrObjectId.Type.CONTEXT);
        assert (!this.containsNode(parentNode));
        this.newNode(parentNode);
        Context iter = parentNode.getContext();
        while (!iter.isGlobal()) {
            ContextOrObjectId iterNode = ContextOrObjectId.make(iter);
            Context parent = iter.getParent();
            ContextOrObjectId pn = ContextOrObjectId.make(parent);
            boolean stop = true;
            if (!this.containsNode(pn)) {
                this.newNode(pn);
                stop = false;
            }
            NamedEdge newEdge = new NamedEdge(iterNode, PARENT_CONTEXT_FIELD);
            this.addEdge(newEdge, pn);
            if (stop) break;
            iter = parent;
        }
    }

    public void addObjectReference(int fromId, String name, int toId, int iid) {
        NamedEdge e;
        ContextOrObjectId old;
        ContextOrObjectId to;
        ContextOrObjectId from = ContextOrObjectId.make(fromId);
        if (!this.containsNode(from)) {
            this.newNode(from);
        }
        if (!this.containsNode(to = ContextOrObjectId.make(toId))) {
            this.newNode(to);
        }
        if ((old = this.getTarget(e = new NamedEdge(from, name))) != null) {
            this.decrementReference(e, old, iid);
        }
        if (!this.isNull(toId)) {
            this.addEdge(e, to);
        }
    }

    private void decrementReference(HeapEdge e, ContextOrObjectId recv, int iid) {
        this.removeEdge(e);
        if (this.referenceCount(recv) > 0) {
            this.addToCycleQueue(recv, iid);
        } else if (this.referenceCount(recv) == 0) {
            this.addToFlushQueue(recv);
        }
    }

    private void addToCycleQueue(ContextOrObjectId o, int iid) {
        IIDAndTime r = this.cycleQueue.get(o);
        if (r == null) {
            r = new IIDAndTime(iid, this.timer.currentTime());
            this.cycleQueue.put(o, r);
        } else {
            r.time = this.timer.currentTime();
            r.iid = iid;
        }
    }

    private void markReachable(List<ContextOrObjectId> roots) {
        ArrayDeque<ContextOrObjectId> wl = new ArrayDeque<ContextOrObjectId>();
        for (ContextOrObjectId start : roots) {
            assert (this.containsNode(start));
            wl.add(start);
            while (!wl.isEmpty()) {
                ContextOrObjectId node = (ContextOrObjectId)wl.pop();
                if (this.markSet.contains(node)) continue;
                this.markSet.add(node);
                for (HeapEdge edge : this.getOutEdges(node)) {
                    ContextOrObjectId target = this.getTarget(edge);
                    if (target == null) continue;
                    wl.add(target);
                }
            }
            wl.clear();
        }
    }

    public void flushCycleQueue(Set<Integer> dontFlush, FlushType flushType, Collection<Context> liveContext) {
        Iterator<ContextOrObjectId> iter = this.cycleQueue.keySet().iterator();
        while (iter.hasNext()) {
            ContextOrObjectId c = iter.next();
            if (c.type == ContextOrObjectId.Type.CONTEXT && c.getContext().isLive()) {
                iter.remove();
            }
            if (this.referenceCount(c) != 0) continue;
            iter.remove();
        }
        if (this.cycleQueue.size() < this.cycleQueueLimit && flushType == FlushType.REGULAR) {
            return;
        }
        ArrayList<Map.Entry<ContextOrObjectId, IIDAndTime>> realQueue = new ArrayList<Map.Entry<ContextOrObjectId, IIDAndTime>>(this.cycleQueue.entrySet());
        Collections.sort(realQueue, new Comparator<Map.Entry<ContextOrObjectId, IIDAndTime>>(){

            @Override
            public int compare(Map.Entry<ContextOrObjectId, IIDAndTime> a, Map.Entry<ContextOrObjectId, IIDAndTime> b) {
                return (int)(b.getValue().time - a.getValue().time);
            }
        });
        if (flushType != FlushType.END_EXECUTION) {
            ArrayList<ContextOrObjectId> roots = new ArrayList<ContextOrObjectId>(liveContext.size());
            for (Context c : liveContext) {
                roots.add(ContextOrObjectId.make(c));
            }
            this.markReachable(roots);
        }
        for (Map.Entry entry : realQueue) {
            ContextOrObjectId node = (ContextOrObjectId)entry.getKey();
            IIDAndTime insertionInfo = (IIDAndTime)entry.getValue();
            if (this.markSet.contains(node)) continue;
            this.collectUnmarked(node, insertionInfo);
        }
        this.markSet.clear();
        this.cycleQueue.clear();
    }

    private void collectUnmarked(ContextOrObjectId startNode, IIDAndTime startTime) {
        ArrayDeque<ContextOrObjectId> wl = new ArrayDeque<ContextOrObjectId>();
        wl.push(startNode);
        while (!wl.isEmpty()) {
            ContextOrObjectId current = (ContextOrObjectId)wl.pop();
            IIDAndTime g = this.cycleQueue.get(current);
            long time = startTime.time;
            int iid = startTime.iid;
            if (g != null) {
                time = Math.max(startTime.time, g.time);
                int n = iid = time == g.time ? g.iid : startTime.iid;
            }
            if (current.type == ContextOrObjectId.Type.ID) {
                this.unreachableCallback.apply((Object)new Unreachability(current.getId(), iid, time));
            }
            this.markSet.add(current);
            for (HeapEdge edge : this.getOutEdges(current)) {
                ContextOrObjectId target = this.getTarget(edge);
                if (target == null || this.markSet.contains(target)) continue;
                wl.push(target);
            }
            this.removeNode(current);
        }
    }

    public abstract boolean containsNode(ContextOrObjectId var1);

    public abstract Set<HeapEdge> incoming(ContextOrObjectId var1);

    public boolean isNull(int id) {
        return id == 0;
    }

    public boolean isGlobalObject(int id) {
        return id == 1;
    }

    public void addContextReference(Context ctx, String name, int toId, int iid) {
        NamedEdge e;
        ContextOrObjectId target;
        ContextOrObjectId to;
        ContextOrObjectId from = ContextOrObjectId.make(ctx);
        if (!this.containsNode(from)) {
            this.newNode(from);
        }
        if (!this.containsNode(to = ContextOrObjectId.make(toId))) {
            this.newNode(to);
        }
        if ((target = this.getTarget(e = new NamedEdge(from, name))) != null) {
            this.decrementReference(e, target, iid);
        }
        if (!this.isNull(toId)) {
            this.addEdge(e, to);
        }
    }

    public int referenceCount(int objectId) {
        return this.referenceCount(ContextOrObjectId.make(objectId));
    }

    public int referenceCount(Context c) {
        return this.referenceCount(ContextOrObjectId.make(c));
    }

    public void flush(int iid, Set<Integer> dontFlush, Collection<Context> live) {
        Set<ContextOrObjectId> c = this.candidates.peek();
        Iterator<ContextOrObjectId> i = c.iterator();
        while (i.hasNext()) {
            ContextOrObjectId e = i.next();
            i.remove();
            if (e.type == ContextOrObjectId.Type.CONTEXT && e.getContext().isLive() || this.isCandidate(e) || e.type == ContextOrObjectId.Type.ID && dontFlush.contains(e.getId())) continue;
            if (this.referenceCount(e) == 0) {
                this.decrementReachable(iid, e);
                continue;
            }
            this.addToCycleQueue(e, iid);
        }
        if (this.cycleQueue.size() > this.cycleQueueLimit && !this.noCycleCollection) {
            this.flushCycleQueue(dontFlush, FlushType.REGULAR, live);
        }
    }

    private Set<ContextOrObjectId> decrementReachable(int iid, ContextOrObjectId o) {
        assert (this.referenceCount(o) == 0);
        HashSet res = HashSetFactory.make();
        ArrayDeque<ContextOrObjectId> stack = new ArrayDeque<ContextOrObjectId>();
        stack.push(o);
        while (!stack.isEmpty()) {
            ContextOrObjectId s = (ContextOrObjectId)stack.pop();
            if (this.isCandidate(s) || s.getContext() != null && s.getContext().isLive()) continue;
            if (this.referenceCount(s) == 0) {
                int id = s.getId();
                if (id != -1) {
                    this.unreachableCallback.apply((Object)new Unreachability(id, iid, this.timer.currentTime()));
                }
                for (HeapEdge succ : this.getOutEdges(s)) {
                    ContextOrObjectId target = this.getTarget(succ);
                    if (target == null) continue;
                    stack.push(target);
                }
                this.removeNode(s);
                continue;
            }
            this.addToCycleQueue(s, iid);
        }
        return res;
    }

    public void addClosureReference(int funId, Context context) {
        ContextOrObjectId func = ContextOrObjectId.make(funId);
        ContextOrObjectId ctx = ContextOrObjectId.make(context);
        this.addEdge(new NamedEdge(func, "_CONTEXT_"), ctx);
    }

    public void contextSealed(Context functionContext, Set<String> unReferenced, int iid) {
        ContextOrObjectId c = ContextOrObjectId.make(functionContext);
        Set<NamedEdge> namedOut = this.getNamedOutEdges(c);
        HashSet toDelete = HashSetFactory.make();
        for (NamedEdge e : namedOut) {
            if (!unReferenced.contains(e.getName())) continue;
            toDelete.add(e);
        }
        for (NamedEdge e : toDelete) {
            ContextOrObjectId to = this.getTarget(e);
            if (to == null) continue;
            this.decrementReference(e, to, iid);
            this.removeEdge(e);
        }
        if (this.referenceCount(c) == 0) {
            this.addToFlushQueue(c);
        } else {
            this.addToCycleQueue(c, iid);
        }
    }

    public void handleValue(int objectId) {
        if (this.referenceCount(objectId) == 0) {
            this.addObjectIdToCandidates(this.candidates.peek(), ContextOrObjectId.make(objectId), objectId);
        }
    }

    private void addObjectIdToCandidates(Set<ContextOrObjectId> curCandidates, ContextOrObjectId c, int id) {
        if (!this.isNull(id) && !this.isGlobalObject(id)) {
            curCandidates.add(c);
        }
    }

    public void addToFlushQueue(ContextOrObjectId c) {
        Context cc;
        Integer id = c.getId();
        if (id != null) {
            this.addObjectIdToCandidates(this.candidates.peek(), c, id);
        }
        if ((cc = c.getContext()) != null) {
            this.candidates.peek().add(c);
        }
    }

    public abstract void toDot(Writer var1);

    public void functionExit(Set<Integer> returnValues) {
        this.candidates.pop();
        Set<ContextOrObjectId> s = this.candidates.peek();
        if (this.candidates.size() > 0) {
            for (Integer i : returnValues) {
                this.addObjectIdToCandidates(s, ContextOrObjectId.make(i), i);
            }
        }
        returnValues.clear();
    }

    public void endFlush(int iid, Set<Integer> returnValues, Collection<Context> liveContexts) {
        this.noCycleCollection = true;
        this.flush(iid, returnValues, liveContexts);
        this.flushCycleQueue(returnValues, FlushType.END_EXECUTION, liveContexts);
        this.removeNode(ContextOrObjectId.make(0));
        if (System.getProperty("testing", "").equals("yes") && !this.resurrectedContexts.isEmpty()) {
            System.out.println("The following contexts were re-added during execution");
            System.out.printf("Time   toString\n", new Object[0]);
            for (Map.Entry<Long, ParentContextAndFunId> e : this.resurrectedContexts.entrySet()) {
                System.out.printf("%-6d %s\n", e.getKey(), e.getValue());
            }
        }
    }

    public abstract Set<ContextOrObjectId> getAllNodes();

    public boolean checkEmpty() {
        Set<ContextOrObjectId> nodes = this.getAllNodes();
        if (nodes.isEmpty()) {
            return true;
        }
        System.out.println("Heap not empty: remaining objects");
        for (ContextOrObjectId n : nodes) {
            System.out.println(n);
        }
        return false;
    }

    public void addDOMChildReference(int parentId, int childId) {
        assert (!this.isNull(parentId));
        assert (!this.isNull(childId));
        this.addToChildSet(ContextOrObjectId.make(parentId), DOM_CHILD_EDGE_NAME, ContextOrObjectId.make(childId));
    }

    public void addToChildSet(ContextOrObjectId parent, String name, ContextOrObjectId child) {
        if (!this.containsNode(parent)) {
            this.newNode(parent);
        }
        if (!this.containsNode(child)) {
            this.newNode(child);
        }
        NamedMultiEdge e = new NamedMultiEdge(parent, name, child);
        this.addNamedMultiEdge(e);
    }

    public void removeFromChildSet(ContextOrObjectId parent, String name, ContextOrObjectId child, int iid) {
        assert (this.containsNode(parent) && this.containsNode(child));
        NamedMultiEdge e = new NamedMultiEdge(parent, name, child);
        this.decrementReference(e, child, iid);
    }

    public void removeDOMChildReference(int parentId, int childId) {
        assert (!this.isNull(parentId));
        assert (!this.isNull(childId));
        this.removeFromChildSet(ContextOrObjectId.make(parentId), DOM_CHILD_EDGE_NAME, ContextOrObjectId.make(childId), -1);
    }

    public int getOutDegree(int objId) {
        ContextOrObjectId obj = ContextOrObjectId.make(objId);
        return this.getOutDegree(obj);
    }

    protected abstract int getOutDegree(ContextOrObjectId var1);

    private class IIDAndTime {
        public int iid;
        public long time;

        public IIDAndTime(int iid, long time) {
            this.iid = iid;
            this.time = time;
        }

        public String toString() {
            return String.format("(%d,%d)", this.iid, this.time);
        }
    }

    private static enum NodeColor {
        GREEN,
        RED,
        BLUE;

    }

    public static enum FlushType {
        REGULAR,
        FORCE,
        END_EXECUTION;

    }

    private class ParentContextAndFunId {
        public String parentContext;
        public int funId;

        public ParentContextAndFunId(String parentContext, int funId) {
            this.parentContext = parentContext;
            this.funId = funId;
        }

        public String toString() {
            return "(" + this.parentContext + "," + this.funId + ")";
        }
    }
}

