/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util.cache;

import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Widget;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.SWTUtil;

public class ImageCache {
    private static final String ICON_ROOT_PATH = "icons/";
    private static final HashMap<String, Image> _ImageMap = new HashMap();

    public static Image getImage(String fileName) {
        Image image = _ImageMap.get(fileName = ICON_ROOT_PATH + fileName);
        if (image == null) {
            image = ImageCache.createImage(fileName);
            _ImageMap.put(fileName, image);
        }
        return image;
    }

    private static synchronized Image createImage(String fileName) {
        InputStream is;
        block4: {
            ClassLoader classLoader = ImageCache.class.getClassLoader();
            is = classLoader.getResourceAsStream(fileName);
            try {
                if (is == null) {
                    is = classLoader.getResourceAsStream(fileName.substring(1));
                }
                if (is != null || (is = classLoader.getResourceAsStream(fileName)) != null || (is = classLoader.getResourceAsStream(fileName.substring(1))) != null) break block4;
            }
            catch (Throwable throwable) {
                IOUtil.tryClose(is);
                throw throwable;
            }
            IOUtil.tryClose(is);
            return null;
        }
        Image image = new Image((Device)SWTUtil.getDisplay(), is);
        IOUtil.tryClose(is);
        return image;
    }

    public static synchronized void dispose() {
        SWTUtil.tryDispose(_ImageMap.values().toArray(new Widget[0]));
        _ImageMap.clear();
    }
}

