/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.resconfig.model;

import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativecommon.resconfig.model.GroupContainer;
import org.tizen.nativecommon.resconfig.model.ObjectFactory;
import org.tizen.nativecommon.resconfig.model.Res;
import org.tizen.nativecommon.rm.model.ResConfig;
import org.tizen.sdblib.util.StringUtil;

public class ResConfigHandler {
    private static final Logger logger = LoggerFactory.getLogger(ResConfigHandler.class);
    private static String FILE_NAME = "res/res.xml";
    private IProject project;
    static ObjectFactory objFactory = new ObjectFactory();
    static JAXBContext jaxbContext = null;

    static {
        try {
            jaxbContext = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
        }
        catch (JAXBException e) {
            String message = "cannot create JAXBContext instance (" + ResConfigHandler.class.getName() + ")";
            logger.error(message, (Throwable)e);
        }
    }

    public ResConfigHandler(IProject project) {
        this.project = project;
    }

    public boolean marshal(ResConfig resConfig) {
        return this.marshal(resConfig, null);
    }

    public boolean marshal(ResConfig resConfig, String location) {
        if (this.project == null) {
            return false;
        }
        Res res = this.makeModel(resConfig);
        File file = null;
        file = StringUtil.isEmpty((CharSequence)location) ? this.project.getFile(FILE_NAME).getLocation().toFile() : this.project.getFile(String.valueOf(location) + "/" + FILE_NAME).getLocation().toFile();
        try {
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)res, file);
        }
        catch (JAXBException e) {
            logger.error("cannot marshal in " + this.project.getName(), (Throwable)e);
            return false;
        }
        try {
            this.project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            logger.warn("cannot excute resfreshLocal method of " + this.project, (Throwable)e);
        }
        return true;
    }

    public boolean removeResFile() {
        File file = this.project.getFile(FILE_NAME).getLocation().toFile();
        if (file.exists()) {
            return file.delete();
        }
        return true;
    }

    public static String getResName() {
        return FILE_NAME;
    }

    private Res makeModel(ResConfig resConfig) {
        String defaultBinDir;
        ResConfig.Item defaultBin;
        String defaultEdjeDir;
        ResConfig.Item defaultEdje;
        String defaultSoundDir;
        ResConfig.Item defaultSound;
        String defaultImageDir;
        ObjectFactory objFactory = new ObjectFactory();
        Res res = objFactory.createRes();
        ResConfig.Item defaultImage = resConfig.getDefaultImage();
        if (defaultImage.getResource().exists() && !(defaultImageDir = resConfig.getDefaultDirForImage()).isEmpty()) {
            res.setGroupImage(this.makeGroupContainer(defaultImageDir, objFactory));
        }
        if ((defaultSound = resConfig.getDefaultSound()).getResource().exists() && !(defaultSoundDir = resConfig.getDefaultDirForSound()).isEmpty()) {
            res.setGroupSound(this.makeGroupContainer(defaultSoundDir, objFactory));
        }
        if ((defaultEdje = resConfig.getDefaultEdje()).getResource().exists() && !(defaultEdjeDir = resConfig.getDefaultDirForEdje()).isEmpty()) {
            res.setGroupLayout(this.makeGroupContainer(defaultEdjeDir, objFactory));
        }
        if ((defaultBin = resConfig.getDefaultBin()).getResource().exists() && !(defaultBinDir = resConfig.getDefaultDirForBin()).isEmpty()) {
            res.setGroupBin(this.makeGroupContainer(defaultBinDir, objFactory));
        }
        if (res.getGroupImage() != null) {
            this.makeNode(resConfig.getChildrenOfImage(), res.getGroupImage().getNode(), objFactory);
        }
        if (res.getGroupSound() != null) {
            this.makeNode(resConfig.getChildrenOfSound(), res.getGroupSound().getNode(), objFactory);
        }
        if (res.getGroupLayout() != null) {
            this.makeNode(resConfig.getChildrenOfEdje(), res.getGroupLayout().getNode(), objFactory);
        }
        if (res.getGroupBin() != null) {
            this.makeNode(resConfig.getChildrenOfBin(), res.getGroupBin().getNode(), objFactory);
        }
        return res;
    }

    private void makeNode(Set<ResConfig.Item> items, List<GroupContainer.Node> nodeList, ObjectFactory objFactory) {
        if (items.isEmpty()) {
            return;
        }
        for (ResConfig.Item item : items) {
            GroupContainer.Node node = objFactory.createGroupContainerNode();
            node.setFolder(item.getDirForResXml());
            if (!item.getLocaleValue().isEmpty()) {
                node.setLanguage(item.getLocaleValue());
            }
            if (!item.getResolutionValue().isEmpty()) {
                node.setScreenDpiRange(item.getResolutionValue());
            }
            nodeList.add(node);
        }
        Collections.sort(nodeList, new Comparator<GroupContainer.Node>(){

            @Override
            public int compare(GroupContainer.Node o1, GroupContainer.Node o2) {
                boolean isCommonLang2;
                if (o1.getLanguage() == null && o2.getLanguage() == null) {
                    return 0;
                }
                if (o1.getLanguage() == null) {
                    return -1;
                }
                if (o2.getLanguage() == null) {
                    return 1;
                }
                boolean isCommonLang1 = !o1.getLanguage().contains("_");
                boolean bl = isCommonLang2 = !o2.getLanguage().contains("_");
                if (isCommonLang1 == isCommonLang2) {
                    return 0;
                }
                if (isCommonLang1) {
                    return 1;
                }
                return -1;
            }
        });
    }

    private GroupContainer makeGroupContainer(String dir, ObjectFactory objFactory) {
        if (objFactory == null) {
            objFactory = new ObjectFactory();
        }
        GroupContainer groupContainer = objFactory.createGroupContainer();
        groupContainer.setFolder(dir);
        return groupContainer;
    }
}

