/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.ArrayUtil;
import org.tizen.common.util.Assert;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.OSChecker;
import org.tizen.common.util.ObjectUtil;
import org.tizen.common.util.StringUtil;

public class FilenameUtil {
    public static final char SEPARATOR_DIRECTORY = '/';
    public static final int IS_VALID_NAME = 0;
    public static final int HAS_INVALID_CHARACTER = 1;
    public static final int HAS_NO_NAME = 2;
    public static final int IS_NULL = 3;
    protected static final Logger logger = LoggerFactory.getLogger(FilenameUtil.class);

    public static String[] getCanonicalFragments(String path) {
        ArrayList<String> ret = new ArrayList<String>();
        char[] characters = path.toCharArray();
        StringBuilder buffer = new StringBuilder();
        int status = 0;
        int i = 0;
        int n = characters.length;
        while (i < n) {
            char ch = characters[i];
            switch (status) {
                case 0: {
                    if ('/' == ch || File.separatorChar == ch) {
                        String fragment = buffer.toString();
                        if (!StringUtil.isEmpty(fragment)) {
                            ret.add(fragment);
                        }
                        buffer.delete(0, buffer.length());
                        break;
                    }
                    if ('\'' == ch) {
                        status = 3;
                        break;
                    }
                    buffer.append(ch);
                    break;
                }
                case 2: {
                    if ('\'' != ch) {
                        buffer.append('\\');
                        buffer.append(ch);
                    }
                    status = 3;
                    break;
                }
                case 3: {
                    if ('\'' == ch) {
                        status = 0;
                        break;
                    }
                    if ('\\' == ch) {
                        status = 2;
                        break;
                    }
                    buffer.append(ch);
                    break;
                }
            }
            ++i;
        }
        if (buffer.length() > 0) {
            String fragment = buffer.toString();
            if (!StringUtil.isEmpty(fragment)) {
                ret.add(fragment);
            }
            buffer.delete(0, buffer.length());
        }
        return ret.toArray(new String[0]);
    }

    public static String[] getCanonicalFragmentsWithNoEscape(String path) {
        ArrayList<String> ret = new ArrayList<String>();
        char[] characters = path.toCharArray();
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        int n = characters.length;
        while (i < n) {
            char ch = characters[i];
            if ('/' == ch || File.separatorChar == ch) {
                String fragment = buffer.toString();
                if (!StringUtil.isEmpty(fragment)) {
                    ret.add(fragment);
                }
                buffer.delete(0, buffer.length());
            } else {
                buffer.append(ch);
            }
            ++i;
        }
        if (buffer.length() > 0) {
            String fragment = buffer.toString();
            if (!StringUtil.isEmpty(fragment)) {
                ret.add(fragment);
            }
            buffer.delete(0, buffer.length());
        }
        return ret.toArray(new String[0]);
    }

    public static String getTailingPath(String path, int start) {
        String[] fragments = FilenameUtil.getCanonicalFragments(path);
        StringBuilder buffer = new StringBuilder();
        int i = Math.max(0, ArrayUtil.size(fragments) - start);
        int n = ArrayUtil.size(fragments);
        while (i < n) {
            buffer.append(fragments[i]);
            if (i < ArrayUtil.size(fragments) - 1) {
                buffer.append('/');
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String removeTailingPath(String path, int numberOfPath) {
        logger.trace("Path :{}, Index :{}", (Object)path, (Object)numberOfPath);
        String[] fragments = FilenameUtil.getCanonicalFragments(path);
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        int n = Math.max(0, ArrayUtil.size(fragments) - numberOfPath);
        while (i < n) {
            buffer.append('/');
            buffer.append(fragments[i]);
            ++i;
        }
        String ret = buffer.toString();
        if (ret.length() > 0) {
            return buffer.toString().substring(path.startsWith("/") || path.startsWith(File.separator) ? 0 : 1);
        }
        return "";
    }

    public static String addTailingPath(String path, String pathToAdd) {
        return String.valueOf(StringUtil.trimTrailingCharacter(path, '/')) + '/' + StringUtil.trimLeadingCharacter(pathToAdd, '/');
    }

    public static boolean isAncestor(String root, String filePath) {
        String[] rootFragments = FilenameUtil.getCanonicalFragments(root);
        String[] fileFragments = FilenameUtil.getCanonicalFragments(filePath);
        if (fileFragments.length < rootFragments.length) {
            return false;
        }
        int i = 0;
        int n = rootFragments.length;
        while (i < n) {
            if (!ObjectUtil.equals(rootFragments[i], fileFragments[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getRelativePath2(String root, String filePath) {
        int nLoop;
        String[] rootFragments = FilenameUtil.getCanonicalFragmentsWithNoEscape(root);
        String[] fileFragments = FilenameUtil.getCanonicalFragmentsWithNoEscape(filePath);
        int nRoot = rootFragments.length;
        int nFile = fileFragments.length;
        StringBuilder buffer = new StringBuilder();
        int nStartDiffer = nLoop = nRoot < nFile ? nRoot : nFile;
        int i = 0;
        while (i < nLoop) {
            if (!ObjectUtil.equals(rootFragments[i], fileFragments[i])) {
                nStartDiffer = i;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < nRoot - nStartDiffer) {
            if (buffer.length() > 0) {
                buffer.append('/');
            }
            buffer.append("..");
            ++i;
        }
        i = nStartDiffer;
        while (i < fileFragments.length) {
            if (buffer.length() > 0) {
                buffer.append('/');
            }
            buffer.append(fileFragments[i]);
            ++i;
        }
        logger.debug("Calculated relative path: {}", (Object)buffer.toString());
        return buffer.toString();
    }

    public static String getRelativePath(String root, String filePath) {
        int nLoop;
        String[] rootFragments = FilenameUtil.getCanonicalFragments(root);
        String[] fileFragments = FilenameUtil.getCanonicalFragments(filePath);
        int nRoot = rootFragments.length;
        int nFile = fileFragments.length;
        StringBuilder buffer = new StringBuilder();
        int nStartDiffer = nLoop = nRoot < nFile ? nRoot : nFile;
        int i = 0;
        while (i < nLoop) {
            if (!ObjectUtil.equals(rootFragments[i], fileFragments[i])) {
                nStartDiffer = i;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < nRoot - nStartDiffer) {
            if (buffer.length() > 0) {
                buffer.append('/');
            }
            buffer.append("..");
            ++i;
        }
        i = nStartDiffer;
        while (i < fileFragments.length) {
            if (buffer.length() > 0) {
                buffer.append('/');
            }
            buffer.append(fileFragments[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static String getCanonicalPath(File file) throws IOException {
        String osCanonicalPath = file.getCanonicalPath();
        return FilenameUtil.getCanonicalForm(osCanonicalPath);
    }

    public static String getCanonicalPath(String path) throws IOException {
        if (!FileUtil.isExist(path)) {
            return null;
        }
        File file = new File(path);
        return FilenameUtil.getCanonicalPath(file);
    }

    public static String getCanonicalForm(String path) {
        logger.trace("Path :{}", (Object)path);
        String[] fragments = FilenameUtil.getCanonicalFragments(path.replace(File.separatorChar, '/'));
        Stack<String> stack = new Stack<String>();
        int i = 0;
        int n = ArrayUtil.size(fragments);
        while (i < n) {
            String fragment = fragments[i];
            if (!".".equals(fragment)) {
                if ("..".equals(fragment)) {
                    if (!stack.isEmpty()) {
                        stack.pop();
                    }
                } else {
                    stack.push(fragment);
                }
            }
            ++i;
        }
        if (stack.isEmpty()) {
            return "/";
        }
        StringBuilder buffer = new StringBuilder();
        for (String f : stack) {
            buffer.append("/");
            buffer.append(f);
        }
        return buffer.toString();
    }

    public static String getFilename(String path) {
        return FilenameUtil.getTailingPath(path, 1);
    }

    public static String getEscapedName(String fileName) {
        Pattern sEscapePattern = Pattern.compile("([\\\\\"$])");
        return sEscapePattern.matcher(fileName).replaceAll("\\\\$1");
    }

    public static int isVaildName(String fileName, int os) {
        int result = 0;
        if (fileName == null) {
            result = 3;
        } else if (fileName.trim().length() == 0) {
            result = 2;
        } else {
            Pattern invalidPattern;
            switch (os) {
                case 256: {
                    invalidPattern = Pattern.compile("([\\\\/:*?\"<>|])");
                    break;
                }
                default: {
                    invalidPattern = Pattern.compile("([/])");
                }
            }
            if (invalidPattern.matcher(fileName).find()) {
                result = 1;
            }
        }
        return result;
    }

    public static boolean isVaildName(String fileName) {
        return FilenameUtil.isVaildName(fileName, OSChecker.getOSID()) == 0;
    }

    public static String getInvalidCharacters(int os) {
        switch (os) {
            case 256: {
                return "\\\\/:*?\"<>|";
            }
            case 1024: {
                return "/";
            }
        }
        return "/";
    }

    public static String getInvalidCharacters() {
        return FilenameUtil.getInvalidCharacters(OSChecker.getOSID());
    }

    public static String addDoubleQuote(String str) {
        return "\"" + str + "\"";
    }

    public static String getName(String nameWithExt) {
        Assert.notNull(nameWithExt);
        int index = nameWithExt.lastIndexOf(46);
        if (index < 0) {
            return nameWithExt;
        }
        return nameWithExt.substring(0, index);
    }

    public static String getExtension(String nameWithExt) {
        Assert.notNull(nameWithExt);
        int index = nameWithExt.lastIndexOf(46);
        if (index < 0) {
            return "";
        }
        return nameWithExt.substring(index + 1);
    }

    public static boolean equals(File file1, File file2) {
        try {
            return ObjectUtil.equals(FilenameUtil.getCanonicalPath(file1), FilenameUtil.getCanonicalPath(file2));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean equals(String path1, String path2) {
        return ObjectUtil.equals(path1, path2);
    }

    public static boolean hasExtension(String name, String ext) {
        if (StringUtil.isEmpty(name)) {
            return false;
        }
        return FilenameUtil.getExtension(name).equalsIgnoreCase(ext);
    }
}

