/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGUniverse;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.ImageInputStream;
import net.sf.image4j.codec.bmp.BMPDecoder;
import net.sf.image4j.codec.bmp.BMPEncoder;
import net.sf.image4j.codec.ico.ICODecoder;
import net.sf.image4j.codec.ico.ICOEncoder;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.SurrogateWithArgument;
import org.tizen.common.rds.RdsDeltaDetector;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.StringUtil;

public class ImageUtil {
    private static final Logger logger = LoggerFactory.getLogger(RdsDeltaDetector.class);
    public static final String[] supportedImageExtension = new String[]{"*.gif;*.png;*.jpeg;*.jpg;*.tiff;*.tif;*.ico;*.bmp;*.rle", "*.gif", "*.png", "*.jpeg;*.jpg", "*.tiff;*.tif", "*.ico", "*.bmp", "*.rle"};
    public static final String ICO = "ico";
    public static final String BMP = "bmp";
    public static final String SVG = "svg";
    public static final String JPG = "jpg";
    public static final String JPEG = "jpeg";
    protected static SurrogateWithArgument<Bundle, String> platformSurrogate = new SurrogateWithArgument<Bundle, String>(){

        @Override
        public Bundle getAdapter(String pluginId) {
            return Platform.getBundle((String)pluginId);
        }
    };
    protected static SurrogateWithArgument<Bundle, Plugin> pluginSurrogate = new SurrogateWithArgument<Bundle, Plugin>(){

        @Override
        public Bundle getAdapter(Plugin plugin) {
            return plugin.getBundle();
        }
    };

    protected static ImageDescriptor getImageDescriptor(Bundle bundle, String filePath) {
        URL url = bundle.getEntry(filePath);
        if (url == null) {
            url = bundle.getResource(filePath);
        }
        return ImageDescriptor.createFromURL((URL)url);
    }

    public static ImageDescriptor getImageDescriptor(String pluginID, String filePath) {
        return ImageUtil.getImageDescriptor(platformSurrogate.getAdapter(pluginID), filePath);
    }

    public static ImageDescriptor getImageDescriptor(Plugin plugin, String filePath) {
        return ImageUtil.getImageDescriptor(pluginSurrogate.getAdapter(plugin), filePath);
    }

    public static org.eclipse.swt.graphics.Image getImage(ImageDescriptor descriptor) {
        return descriptor != null ? descriptor.createImage() : null;
    }

    public static ImageData getImageData(ImageDescriptor descriptor) {
        return descriptor != null ? descriptor.getImageData() : null;
    }

    public static org.eclipse.swt.graphics.Image getImage(Plugin plugin, String filePath) {
        ImageDescriptor descriptor = ImageUtil.getImageDescriptor(plugin, filePath);
        return ImageUtil.getImage(descriptor);
    }

    public static ImageData getImageData(Plugin plugin, String filePath) {
        ImageDescriptor descriptor = ImageUtil.getImageDescriptor(plugin, filePath);
        return ImageUtil.getImageData(descriptor);
    }

    public static org.eclipse.swt.graphics.Image getImage(String pluginID, String filePath) {
        ImageDescriptor descriptor = ImageUtil.getImageDescriptor(pluginID, filePath);
        return ImageUtil.getImage(descriptor);
    }

    public static ImageData getImageData(String pluginID, String filePath) {
        ImageDescriptor descriptor = ImageUtil.getImageDescriptor(pluginID, filePath);
        return ImageUtil.getImageData(descriptor);
    }

    public static BufferedImage getScaledImage(BufferedImage src, int width, int height) {
        return ImageUtil.getScaledImage(src, width, height, 2);
    }

    public static BufferedImage getScaledImage(BufferedImage src, int width, int height, int imgType) {
        Image scaledImage = src.getScaledInstance(width, height, 4);
        BufferedImage bi = new BufferedImage(width, height, imgType);
        Graphics g = bi.getGraphics();
        g.drawImage(scaledImage, 0, 0, null);
        g.dispose();
        return bi;
    }

    public static BufferedImage getBufferedImage(URL url) {
        BufferedImage bImage;
        InputStream input;
        block9: {
            if (url == null) {
                return null;
            }
            input = null;
            bImage = null;
            int contentLength = 0;
            if (url.getProtocol().equalsIgnoreCase("file")) {
                url = URIUtil.toURI((URL)url).toURL();
            }
            URLConnection con = url.openConnection();
            con.setConnectTimeout(100);
            contentLength = con.getContentLength();
            if (contentLength != 0 && contentLength != -1) break block9;
            IOUtil.tryClose(input);
            return null;
        }
        try {
            input = url.openStream();
            bImage = ImageUtil.getBufferedImage(input);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            IOUtil.tryClose(input);
        }
        catch (URISyntaxException e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.tryClose(input);
                throw throwable;
            }
            IOUtil.tryClose(input);
        }
        IOUtil.tryClose(input);
        return bImage;
    }

    public static List<BufferedImage> getAWTImages(InputStream is, String iconFilePath) throws IOException {
        List<BufferedImage> images;
        block14: {
            images = new ArrayList<BufferedImage>();
            BufferedInputStream bis = new BufferedInputStream(is);
            bis.mark(Integer.MAX_VALUE);
            String formatName = ImageUtil.getFormatName(bis, iconFilePath);
            bis.reset();
            if (!StringUtil.isEmpty(formatName)) {
                if (formatName.equalsIgnoreCase(ICO)) {
                    images = ICODecoder.read((InputStream)bis);
                } else if (formatName.equalsIgnoreCase(BMP)) {
                    images.add(BMPDecoder.read((InputStream)bis));
                } else {
                    if (formatName.equalsIgnoreCase(SVG)) {
                        SVGUniverse svgUnverse = new SVGUniverse();
                        URI iconUri = svgUnverse.loadSVG((InputStream)bis, formatName);
                        if (iconUri == null) {
                            return images;
                        }
                        SVGDiagram diagram = svgUnverse.getDiagram(iconUri);
                        if (diagram == null) {
                            return images;
                        }
                        BufferedImage image = new BufferedImage((int)diagram.getWidth(), (int)diagram.getHeight(), 2);
                        Graphics2D graphics = null;
                        try {
                            try {
                                graphics = image.createGraphics();
                                diagram.render(graphics);
                                images.add(image);
                                break block14;
                            }
                            catch (SVGException e) {
                                throw new IOException(e);
                            }
                        }
                        finally {
                            if (graphics != null) {
                                graphics.dispose();
                            }
                        }
                    }
                    images.add(ImageIO.read(bis));
                }
            }
        }
        return images;
    }

    public static BufferedImage getBufferedImage(InputStream input) {
        BufferedImage bImage;
        block13: {
            if (input == null) {
                return null;
            }
            bImage = null;
            ImageInputStream stream = null;
            try {
                try {
                    stream = ImageIO.createImageInputStream(input);
                    Iterator<ImageReader> iter = ImageIO.getImageReaders(stream);
                    while (iter.hasNext()) {
                        ImageReader reader;
                        block11: {
                            reader = null;
                            try {
                                reader = iter.next();
                                ImageReadParam param = reader.getDefaultReadParam();
                                reader.setInput(stream, true, true);
                                Iterator<ImageTypeSpecifier> imageTypes = reader.getImageTypes(0);
                                while (imageTypes.hasNext()) {
                                    ImageTypeSpecifier imageTypeSpecifier = imageTypes.next();
                                    int bufferedImageType = imageTypeSpecifier.getBufferedImageType();
                                    if (bufferedImageType != 10) continue;
                                    param.setDestinationType(imageTypeSpecifier);
                                    break;
                                }
                                bImage = reader.read(0, param);
                                if (bImage == null) break block11;
                            }
                            catch (Exception e) {
                                try {
                                    throw e;
                                }
                                catch (Throwable throwable) {
                                    IOUtil.tryClose(reader);
                                    throw throwable;
                                }
                            }
                            IOUtil.tryClose(reader);
                            break;
                        }
                        IOUtil.tryClose(reader);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    IOUtil.tryClose(stream);
                    break block13;
                }
            }
            catch (Throwable throwable) {
                IOUtil.tryClose(stream);
                throw throwable;
            }
            IOUtil.tryClose(stream);
        }
        return bImage;
    }

    public static BufferedImage getAWTImage(String path, boolean isRelativePath) {
        List<BufferedImage> images;
        block6: {
            InputStream is = null;
            images = null;
            try {
                try {
                    is = isRelativePath ? ImageUtil.class.getResourceAsStream(path) : new FileInputStream(new File(path));
                    images = ImageUtil.getAWTImages(is, path);
                }
                catch (IOException e) {
                    logger.error("Failed to read", (Throwable)e);
                    IOUtil.tryClose(is);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtil.tryClose(is);
                throw throwable;
            }
            IOUtil.tryClose(is);
        }
        if (images == null || images.isEmpty()) {
            return new BufferedImage(1, 1, 2);
        }
        return images.get(0);
    }

    public static org.eclipse.swt.graphics.Image getSWTImage(Display display, String relativePath) {
        org.eclipse.swt.graphics.Image image;
        if (StringUtil.isEmpty(relativePath)) {
            return new org.eclipse.swt.graphics.Image((Device)display, 1, 1);
        }
        InputStream is = ImageUtil.class.getResourceAsStream(relativePath);
        try {
            org.eclipse.swt.graphics.Image image2;
            image = image2 = new org.eclipse.swt.graphics.Image((Device)Display.getDefault(), is);
        }
        catch (Throwable throwable) {
            IOUtil.tryClose(is);
            throw throwable;
        }
        IOUtil.tryClose(is);
        return image;
    }

    public static org.eclipse.swt.graphics.Image getScaledSWTImage(org.eclipse.swt.graphics.Image src, int width, int height) {
        if (src == null) {
            return null;
        }
        if (src.isDisposed()) {
            SWT.error((int)24);
        }
        org.eclipse.swt.graphics.Image scaledImage = new org.eclipse.swt.graphics.Image(src.getDevice(), width, height);
        GC gc = new GC((Drawable)scaledImage);
        gc.setAntialias(1);
        gc.setInterpolation(2);
        gc.drawImage(src, 0, 0, src.getBounds().width, src.getBounds().height, 0, 0, width, height);
        gc.dispose();
        return scaledImage;
    }

    public static org.eclipse.swt.graphics.Image getSimpleScaledSWTImage(org.eclipse.swt.graphics.Image src, int width, int height) {
        org.eclipse.swt.graphics.Image scaledImage = null;
        if (src != null) {
            ImageData srcData = src.getImageData();
            scaledImage = srcData.width == width && srcData.height == height ? new org.eclipse.swt.graphics.Image(src.getDevice(), src, 0) : new org.eclipse.swt.graphics.Image(src.getDevice(), srcData.scaledTo(width, height));
        }
        return scaledImage;
    }

    public static org.eclipse.swt.graphics.Image convertImageToSWT(Display display, BufferedImage bImage) {
        int width = bImage.getWidth();
        int height = bImage.getHeight();
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(bImage, 0, 0, null);
        graphics.dispose();
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel colorModel = (DirectColorModel)bufferedImage.getColorModel();
            PaletteData palette = new PaletteData(colorModel.getRedMask(), colorModel.getGreenMask(), colorModel.getBlueMask());
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int rgb = bufferedImage.getRGB(x, y);
                    int pixel = palette.getPixel(new RGB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF));
                    data.setPixel(x, y, pixel);
                    if (colorModel.hasAlpha()) {
                        data.setAlpha(x, y, rgb >> 24 & 0xFF);
                    }
                    ++x;
                }
                ++y;
            }
            return new org.eclipse.swt.graphics.Image((Device)display, data);
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel colorModel = (IndexColorModel)bufferedImage.getColorModel();
            int size = colorModel.getMapSize();
            byte[] reds = new byte[size];
            byte[] greens = new byte[size];
            byte[] blues = new byte[size];
            colorModel.getReds(reds);
            colorModel.getGreens(greens);
            colorModel.getBlues(blues);
            RGB[] rgbs = new RGB[size];
            int i = 0;
            while (i < rgbs.length) {
                rgbs[i] = new RGB(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
                ++i;
            }
            PaletteData palette = new PaletteData(rgbs);
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            data.transparentPixel = colorModel.getTransparentPixel();
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[1];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    data.setPixel(x, y, pixelArray[0]);
                    ++x;
                }
                ++y;
            }
            return new org.eclipse.swt.graphics.Image((Device)display, data);
        }
        return null;
    }

    public static BufferedImage pileUp(BufferedImage bottom, Point bottomPoint, BufferedImage top, Point topPoint, int width, int height, int imgType) {
        BufferedImage img = new BufferedImage(width, height, imgType);
        boolean result = false;
        Graphics2D g = null;
        try {
            g = img.createGraphics();
            result = g.drawImage((Image)bottom, (int)bottomPoint.getX(), (int)bottomPoint.getY(), null);
            if (!result) {
                return null;
            }
            result = g.drawImage((Image)top, (int)topPoint.getX(), (int)topPoint.getY(), null);
            if (!result) {
                return null;
            }
        }
        finally {
            if (g != null) {
                g.dispose();
            }
        }
        return img;
    }

    public static BufferedImage convertToAWT(ImageData data) {
        IndexColorModel colorModel = null;
        PaletteData palette = data.palette;
        if (palette.isDirect) {
            BufferedImage bufferedImage = new BufferedImage(data.width, data.height, 2);
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int pixel = data.getPixel(x, y);
                    RGB rgb = palette.getRGB(pixel);
                    bufferedImage.setRGB(x, y, data.getAlpha(x, y) << 24 | rgb.red << 16 | rgb.green << 8 | rgb.blue);
                    ++x;
                }
                ++y;
            }
            return bufferedImage;
        }
        RGB[] rgbs = palette.getRGBs();
        byte[] red = new byte[rgbs.length];
        byte[] green = new byte[rgbs.length];
        byte[] blue = new byte[rgbs.length];
        int i = 0;
        while (i < rgbs.length) {
            RGB rgb = rgbs[i];
            red[i] = (byte)rgb.red;
            green[i] = (byte)rgb.green;
            blue[i] = (byte)rgb.blue;
            ++i;
        }
        colorModel = data.transparentPixel != -1 ? new IndexColorModel(data.depth, rgbs.length, red, green, blue, data.transparentPixel) : new IndexColorModel(data.depth, rgbs.length, red, green, blue);
        BufferedImage bufferedImage = new BufferedImage(colorModel, ((ColorModel)colorModel).createCompatibleWritableRaster(data.width, data.height), false, null);
        WritableRaster raster = bufferedImage.getRaster();
        int[] pixelArray = new int[1];
        int y = 0;
        while (y < data.height) {
            int x = 0;
            while (x < data.width) {
                int pixel;
                pixelArray[0] = pixel = data.getPixel(x, y);
                raster.setPixel(x, y, pixelArray);
                ++x;
            }
            ++y;
        }
        return bufferedImage;
    }

    public static void write(BufferedImage bImg, String formatName, OutputStream os) throws IOException {
        if (ICO.equalsIgnoreCase(formatName)) {
            ICOEncoder.write((BufferedImage)bImg, (OutputStream)os);
        } else if (BMP.equalsIgnoreCase(formatName)) {
            BMPEncoder.write((BufferedImage)bImg, (OutputStream)os);
        } else if (!SVG.equalsIgnoreCase(formatName)) {
            ImageIO.write((RenderedImage)bImg, formatName, os);
        }
    }

    public static void writeICO(List<BufferedImage> bImgs, OutputStream os) throws IOException {
        ICOEncoder.write(bImgs, (OutputStream)os);
    }

    public static String getFormatName(InputStream is, String path) throws IOException {
        if (is == null) {
            return null;
        }
        String extension = FilenameUtil.getExtension(path);
        if (ICO.equalsIgnoreCase(extension)) {
            return ICO;
        }
        String result = null;
        result = ImageUtil.getRawFormatName(is);
        if (result == null) {
            result = extension;
        }
        return result;
    }

    public static String getFormatName(String fullPath) throws IOException {
        String string;
        File file = new File(fullPath);
        if (!file.exists()) {
            return null;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(fullPath);
            string = ImageUtil.getFormatName(is, fullPath);
        }
        catch (Throwable throwable) {
            IOUtil.tryClose(is);
            throw throwable;
        }
        IOUtil.tryClose(is);
        return string;
    }

    public static String getRawFormatName(InputStream is) throws IOException {
        if (is == null) {
            return null;
        }
        ImageInputStream iis = null;
        String result = null;
        try {
            iis = ImageIO.createImageInputStream(is);
            result = ImageUtil.getRawFormatName(iis);
        }
        catch (Throwable throwable) {
            IOUtil.tryClose(iis);
            throw throwable;
        }
        IOUtil.tryClose(iis);
        return result;
    }

    public static String getRawFormatName(ImageInputStream iis) throws IOException {
        if (iis == null) {
            return null;
        }
        String result = null;
        Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
        while (readers.hasNext()) {
            ImageReader read = readers.next();
            String formatName = read.getFormatName();
            if (formatName == null) continue;
            return formatName;
        }
        return result;
    }

    public static void tryDispose(org.eclipse.swt.graphics.Image image) {
        if (image != null) {
            image.dispose();
        }
    }

    public static class PlatformSurrogate {
        public Bundle getBundle(String pluginID) {
            return Platform.getBundle((String)pluginID);
        }
    }

    public static class PluginSurrogate {
        public Bundle getBundle(Plugin plugin) {
            return plugin.getBundle();
        }
    }
}

