/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.apihover;

import java.io.File;
import java.io.IOException;
import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IDelayedInputChangeProvider;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IInputChangedListener;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.util.FileUtil;
import org.tizen.nativecommon.apihover.doxygen.DoxygenHandler;

public class BrowserInformationControl
extends AbstractInformationControl
implements IInformationControlExtension2,
IDelayedInputChangeProvider {
    private static final Logger logger = LoggerFactory.getLogger(BrowserInformationControl.class);
    private static final String JS_FILENAME = "format-apidoc.js";
    private static String javascript;
    private static Stack<String> redoStack;
    private static Stack<String> undoStack;
    private static boolean naviactionPressed;
    private static boolean mouseClicked;
    private static boolean isGohomeEnabled;
    private static boolean isOpenbrowserEnabled;
    private static String UNKNOWNPAGE;
    private static boolean fgIsAvailable;
    private static boolean fgAvailabilityChecked;
    private static Point fgScrollBarSize;
    protected Browser fBrowser;
    private boolean fBrowserHasContent;
    private String fInput;
    private String currentInput;
    private boolean fCompleted = false;
    private IInputChangedListener fDelayedInputChangeListener;
    private ListenerList fInputChangeListeners = new ListenerList(1);

    static {
        redoStack = new Stack();
        undoStack = new Stack();
        naviactionPressed = false;
        mouseClicked = false;
        isGohomeEnabled = true;
        isOpenbrowserEnabled = true;
        UNKNOWNPAGE = "file://404page";
        fgIsAvailable = false;
        fgAvailabilityChecked = false;
    }

    public static boolean isAvailable(Composite parent) {
        if (!fgAvailabilityChecked) {
            try {
                try {
                    Browser browser = new Browser(parent, 0);
                    browser.dispose();
                    fgIsAvailable = true;
                    Slider sliderV = new Slider(parent, 512);
                    Slider sliderH = new Slider(parent, 256);
                    int width = sliderV.computeSize((int)-1, (int)-1).x;
                    int height = sliderH.computeSize((int)-1, (int)-1).y;
                    fgScrollBarSize = new Point(width, height);
                    sliderV.dispose();
                    sliderH.dispose();
                    javascript = DoxygenHandler.getJavaScript(JS_FILENAME);
                }
                catch (SWTError sWTError) {
                    fgIsAvailable = false;
                    fgAvailabilityChecked = true;
                }
            }
            finally {
                fgAvailabilityChecked = true;
            }
        }
        return fgIsAvailable;
    }

    public BrowserInformationControl(Shell parent, ToolBarManager toolBarManager) {
        super(parent, toolBarManager);
        this.create();
    }

    protected void createContent(Composite parent) {
        this.fBrowser = new Browser(parent, 0);
        Display display = this.getShell().getDisplay();
        this.fBrowser.setForeground(display.getSystemColor(28));
        this.fBrowser.setBackground(display.getSystemColor(29));
        this.fBrowser.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    BrowserInformationControl.this.getShell().dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.fBrowser.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                mouseClicked = true;
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.fBrowser.addProgressListener((ProgressListener)new ProgressAdapter(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
                boolean result;
                if (javascript != null && javascript.length() != 0 && !(result = BrowserInformationControl.this.fBrowser.execute(javascript))) {
                    logger.info("Script was not executed.");
                }
                BrowserInformationControl.this.fCompleted = true;
            }
        });
        this.fBrowser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                String[] page;
                if (event.location == null || event.location.startsWith("about:blank")) {
                    return;
                }
                if (event.location.startsWith(UNKNOWNPAGE)) {
                    BrowserInformationControl.this.fBrowser.setText(BrowserInformationControl.this.fInput);
                    return;
                }
                String current = null;
                String absPath = null;
                String urlProtocol = "file";
                absPath = event.location.startsWith(urlProtocol) ? event.location.substring("file://".length()) : (event.location.startsWith("about:") ? event.location.substring("about:".length()) : event.location);
                current = !absPath.startsWith(InstallPathConfig.getSDKPath()) ? ((page = absPath.split("#")).length != 2 ? String.valueOf(DoxygenHandler.getParentPath(BrowserInformationControl.this.fInput)) + "/" + page[0] : (page[0].contains("htm") ? String.valueOf(DoxygenHandler.getParentPath(BrowserInformationControl.this.fInput)) + "/" + page[0] + "#" + page[1] : String.valueOf(DoxygenHandler.getParentPath(BrowserInformationControl.this.fInput)) + "/" + page[1])) : absPath;
                if (mouseClicked) {
                    redoStack.clear();
                    mouseClicked = false;
                }
                if (!current.equals(BrowserInformationControl.this.currentInput)) {
                    undoStack.push(BrowserInformationControl.this.currentInput);
                    BrowserInformationControl.this.currentInput = current;
                }
                BrowserInformationControl.this.setInputContents(current);
            }

            public void changed(LocationEvent event) {
            }
        });
        this.fBrowser.setMenu(new Menu((Decorations)this.getShell(), 0));
    }

    public void setInput(Object input) {
        Assert.isLegal((input == null || input instanceof String ? 1 : 0) != 0);
        if (input instanceof String) {
            this.fInput = (String)input;
            this.currentInput = (String)input;
        }
        this.fCompleted = false;
        if (this.fInput.startsWith("<html>")) {
            this.fBrowserHasContent = this.fBrowser.setUrl(UNKNOWNPAGE);
            this.fBrowser.setText(this.fInput);
            isGohomeEnabled = false;
            isOpenbrowserEnabled = false;
        } else {
            this.fBrowserHasContent = this.fBrowser.setUrl(this.fInput);
            undoStack.clear();
            redoStack.clear();
            naviactionPressed = false;
            isGohomeEnabled = true;
            isOpenbrowserEnabled = true;
            this.setInputContents(this.fInput);
        }
    }

    private void setInputContents(String input) {
        String absPath = DoxygenHandler.getAbsolutePath(input);
        String html = null;
        try {
            html = FileUtil.readTextFile((File)new File(absPath), null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuilder contents = new StringBuilder();
        String parentUrl = "file://" + DoxygenHandler.getParentPath(input);
        contents.append(DoxygenHandler.getHtmlPrologue(parentUrl));
        String id = DoxygenHandler.getUrlId(input);
        String contentBody = DoxygenHandler.grepInputHtml(html, id);
        if (contentBody == null) {
            contents.append(DoxygenHandler.grepBodyHtml(html));
        } else {
            contents.append(contentBody);
        }
        contents.append(DoxygenHandler.getHtmlEpilogue());
        this.fBrowser.setText(contents.toString());
    }

    public void dispose() {
        this.fBrowser = null;
        super.dispose();
    }

    public void addLocationListener(LocationListener listener) {
        this.fBrowser.addLocationListener(listener);
    }

    public boolean hasContents() {
        return this.fBrowserHasContent;
    }

    public void setDelayedInputChangeListener(IInputChangedListener inputChangeListener) {
        this.fDelayedInputChangeListener = inputChangeListener;
    }

    public boolean hasDelayedInputChangeListener() {
        return this.fDelayedInputChangeListener != null;
    }

    public void notifyDelayedInputChange(Object newInput) {
        if (this.fDelayedInputChangeListener != null) {
            this.fDelayedInputChangeListener.inputChanged(newInput);
        }
    }

    public String toString() {
        String style = (this.getShell().getStyle() & 0x10) == 0 ? "fixed" : "resizeable";
        return String.valueOf(super.toString()) + " -  style: " + style;
    }

    public String getInput() {
        return this.fInput;
    }

    public void goToHome() {
        this.setInput(this.fInput);
        redoStack.empty();
        undoStack.empty();
    }

    public String getURL() {
        return "file://" + this.currentInput;
    }

    public void back() {
        if (!undoStack.isEmpty()) {
            String input = undoStack.pop();
            this.setInputContents(input);
            redoStack.push(this.currentInput);
            this.currentInput = input;
            naviactionPressed = true;
        }
    }

    public void forward() {
        if (!redoStack.isEmpty()) {
            String input = redoStack.pop();
            this.setInputContents(input);
            undoStack.push(this.currentInput);
            this.currentInput = input;
            naviactionPressed = true;
        }
    }

    public boolean isBackEnabled() {
        return !undoStack.isEmpty();
    }

    public boolean isForwardEnabled() {
        return !redoStack.isEmpty();
    }

    public boolean isGohomeEnabled() {
        return isGohomeEnabled;
    }

    public boolean isOpenbrowserEnabled() {
        return isOpenbrowserEnabled;
    }

    public void stop() {
        this.fBrowser.stop();
    }
}

