/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.command;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.sdb.command.ApplicationCommand;
import org.tizen.common.sdb.command.InstallCommand;
import org.tizen.common.ui.view.console.ITizenConsoleManager;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.PlatformCapability;
import org.tizen.sdblib.service.ApplicationCmdService;

public class NativeInstallCommand
extends InstallCommand {
    private static Logger logger = LoggerFactory.getLogger(NativeInstallCommand.class);
    private File tepPkgFile = null;
    private File pkgFile = null;
    private String pkgDirPath = "";

    public NativeInstallCommand(IDevice device, File pkgFile, File tepFile, ITizenConsoleManager console) {
        super(device, console);
        this.pkgType = ApplicationCmdService.PackageType.NativePkg;
        this.pkgFile = pkgFile;
        this.tepPkgFile = tepFile;
        this.pkgDirPath = TizenPlatformConstants.getAppTmpDirectory((IDevice)device);
    }

    protected String getPath() {
        return String.valueOf(this.pkgDirPath) + "/" + this.pkgFile.getName();
    }

    protected void executeCommand() throws Exception {
        if (ApplicationCommand.isAppCmdSupported((IDevice)this.getDevice())) {
            String tepFilePath;
            ApplicationCmdService appcmd = this.getApplicationCmdService();
            String sourceTpkPath = this.pkgFile.getAbsolutePath();
            String string = tepFilePath = this.tepPkgFile != null ? this.tepPkgFile.getAbsolutePath() : null;
            if (!appcmd.installPackage(ApplicationCmdService.PackageType.NativePkg, sourceTpkPath, null, tepFilePath, (IShellOutputReceiver)this.receiver)) {
                this.newCoreException("NativeInstall command failed- package path: " + sourceTpkPath + "   tep path: " + tepFilePath, null);
            }
        } else {
            super.executeCommand();
        }
    }

    protected String getArgs() {
        if (this.isDebugMode()) {
            this.args = String.valueOf(this.args) + "-G";
        }
        if (this.tepPkgFile != null) {
            this.args = String.valueOf(this.args) + " -e " + this.pkgDirPath + "/" + this.tepPkgFile.getName();
        }
        return this.args;
    }

    private boolean isDebugMode() {
        PlatformCapability capa = null;
        boolean isDebugMode = false;
        try {
            capa = this.device.getPlatformCapability();
            isDebugMode = "enabled".equals(capa.getPkgcmdDebugModeSupport());
        }
        catch (Exception e) {
            isDebugMode = false;
            logger.debug("Failed to get platform capability.", (Throwable)e);
        }
        return isDebugMode;
    }
}

