/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.preferences;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class SigningProfileItem {
    protected String keyLocation;
    protected String caPath;
    protected String rootCAPath;
    protected String id;
    protected char[] password;
    protected boolean bAuthor;

    public SigningProfileItem() {
        this("", "", false, "", "");
    }

    public SigningProfileItem(String keyLocation, String id, boolean bAuthor) {
        this(keyLocation, id, bAuthor, "", "");
    }

    public SigningProfileItem(String keyLocation, String id, boolean bAuthor, String caPath, String rootCAPath) {
        this.keyLocation = keyLocation;
        this.id = id;
        this.bAuthor = bAuthor;
        this.caPath = caPath;
        this.rootCAPath = rootCAPath;
        this.password = "".toCharArray();
    }

    public String getIdentifier() {
        return this.id;
    }

    public void setIdentifier(String id) {
        this.id = id;
    }

    public String getKeyLocation() {
        return this.keyLocation;
    }

    public boolean hasKeyLocation() {
        if (this.keyLocation == null) {
            return false;
        }
        return !this.keyLocation.trim().isEmpty();
    }

    public void setKeyLocation(String keyLocation) {
        this.keyLocation = keyLocation;
    }

    public String getCAPath() {
        return this.caPath;
    }

    public void setCAPath(String caPath) {
        this.caPath = caPath;
    }

    public String getRootCAPath() {
        return this.rootCAPath;
    }

    public void setRootCAPath(String rootCAPath) {
        this.rootCAPath = rootCAPath;
    }

    public InputStream openKeyInputStream() throws IOException {
        return new FileInputStream(this.keyLocation);
    }

    public boolean isAuthor() {
        return this.bAuthor;
    }

    public void setAuthor(boolean isAuthor) {
        this.bAuthor = isAuthor;
    }

    public char[] getPassword() {
        if (this.password == null) {
            return null;
        }
        char[] password = new char[this.password.length];
        System.arraycopy(this.password, 0, password, 0, this.password.length);
        return password;
    }

    public boolean hasPassword() {
        if (this.password == null) {
            return false;
        }
        return !new String(this.password).trim().isEmpty();
    }

    public void setPassword(char[] password) {
        if (password == null) {
            this.password = password;
            return;
        }
        this.password = new char[password.length];
        System.arraycopy(password, 0, this.password, 0, password.length);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.bAuthor).append((Object)this.id).append((Object)this.keyLocation).append((Object)this.caPath).append((Object)this.rootCAPath).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SigningProfileItem)) {
            return false;
        }
        SigningProfileItem profileItem = (SigningProfileItem)obj;
        return new EqualsBuilder().append(this.bAuthor, profileItem.bAuthor).append((Object)this.id, (Object)profileItem.id).append((Object)this.keyLocation, (Object)profileItem.keyLocation).append((Object)this.caPath, (Object)profileItem.caPath).append((Object)this.rootCAPath, (Object)profileItem.rootCAPath).isEquals();
    }
}

