/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.po.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.tizen.nativecommon.po.editor.POConstants;
import org.tizen.nativecommon.po.model.MsgEntry;
import org.tizen.nativecommon.po.model.MsgReference;
import org.tizen.nativecommon.po.model.POParser;

public class POFile {
    private List<String> headerComments;
    private Map<String, String> headerEntries;
    private List<MsgEntry> msgEntries;
    private File pofile = null;

    public POFile(File pofile) {
        if (pofile == null) {
            throw new NullPointerException("PO file has no content.");
        }
        this.pofile = pofile;
        this.headerComments = new ArrayList<String>();
        this.headerEntries = new LinkedHashMap<String, String>();
        this.msgEntries = new ArrayList<MsgEntry>();
    }

    public File getFile() {
        return this.pofile;
    }

    public void open() throws FileNotFoundException {
        BufferedReader br = null;
        try {
            FileReader reader = new FileReader(this.pofile);
            br = new BufferedReader(reader);
            POParser parser = new POParser(this.headerEntries, this.msgEntries, this.headerComments);
            parser.parse(br);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean exists() {
        return this.pofile.exists();
    }

    public void save() throws IOException {
        try (FileWriter writer = null;){
            writer = new FileWriter(this.pofile);
            this.printContents(writer);
            writer.flush();
        }
    }

    public List<MsgEntry> getMsgEntries() {
        return this.msgEntries;
    }

    public String getMsgValue(String msgId) {
        for (MsgEntry entry : this.msgEntries) {
            if (!entry.getMsgId().equals(msgId)) continue;
            return entry.getMsgStr();
        }
        return "";
    }

    public void setMsgEntries(List<MsgEntry> entries) {
        this.msgEntries = entries;
    }

    public void addMsgEntry(MsgEntry entry) {
        if (this.existsMsg(entry.getMsgId())) {
            return;
        }
        this.msgEntries.add(entry);
    }

    public void addMsgEntryFirst(MsgEntry entry) {
        if (this.existsMsg(entry.getMsgId())) {
            return;
        }
        this.msgEntries.add(0, entry);
    }

    public boolean existsMsg(String id) {
        for (MsgEntry entry : this.msgEntries) {
            if (!entry.getMsgId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public Map<String, String> getHeaderEntries() {
        return this.headerEntries;
    }

    public void setHeaderEntries(Map<String, String> headers) {
        this.headerEntries = headers;
    }

    public List<String> getHeaderComments() {
        return this.headerComments;
    }

    public void setHeaderComments(List<String> comments) {
        this.headerComments = comments;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        this.printContents(writer);
        writer.flush();
        return writer.toString();
    }

    public void addHeaderWarningMessage() {
        if (!this.headerComments.isEmpty() && this.headerComments.get(0).equals(POConstants.HEADER_WARNING_MODIFY[0]) && this.headerComments.get(1).equals(POConstants.HEADER_WARNING_MODIFY[1])) {
            return;
        }
        this.headerComments.add(0, POConstants.HEADER_WARNING_MODIFY[0]);
        this.headerComments.add(1, POConstants.HEADER_WARNING_MODIFY[1]);
    }

    public void printContents(Writer writer) {
        PrintWriter outWriter = new PrintWriter(writer);
        this.addHeaderWarningMessage();
        for (String comment : this.headerComments) {
            outWriter.println(comment);
        }
        outWriter.println();
        for (MsgEntry entry : this.msgEntries) {
            for (String translator : entry.getTranslatorComments()) {
                if (translator.trim().equals("")) continue;
                outWriter.println("# " + translator);
            }
            for (String extComment : entry.getExtractedComments()) {
                if (extComment.trim().equals("")) continue;
                outWriter.println("#. " + extComment);
            }
            for (MsgReference reference : entry.getMsgRefs()) {
                outWriter.println("#: " + reference.getFilename() + ":" + reference.getLinenumber());
            }
            for (String flag : entry.getFlags()) {
                if (flag.trim().equals("")) continue;
                outWriter.println("#, " + flag);
            }
            String msgId = entry.getMsgId();
            if (msgId.contains("\n")) {
                boolean firstline = true;
                StringTokenizer stMsgId = new StringTokenizer(msgId, "\n");
                while (stMsgId.hasMoreTokens()) {
                    String partMsgId = stMsgId.nextToken();
                    if (firstline) {
                        outWriter.println("msgid \"" + partMsgId + "\"");
                        firstline = false;
                        continue;
                    }
                    outWriter.println("\"" + partMsgId + "\"");
                }
            } else {
                outWriter.println("msgid \"" + msgId + "\"");
            }
            String msgstr = entry.getMsgStr();
            if (msgstr.contains("\n")) {
                boolean firstline = true;
                StringTokenizer stMsgStr = new StringTokenizer(msgstr, "\n");
                while (stMsgStr.hasMoreTokens()) {
                    String msgStr = stMsgStr.nextToken();
                    if (firstline) {
                        outWriter.println("msgstr \"" + msgStr + "\"");
                        firstline = false;
                        continue;
                    }
                    outWriter.println("\"" + msgStr + "\"");
                }
            } else {
                outWriter.println("msgstr \"" + msgstr + "\"");
            }
            outWriter.println();
        }
    }
}

