/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.sign.preferences.Messages;
import org.tizen.common.sign.preferences.SigningProfileItem;
import org.tizen.common.util.Assert;
import org.tizen.common.util.StringUtil;

public class ProfileItemDialog
extends StatusDialog {
    protected final String[] filterExt_p12 = new String[]{"*.p12"};
    protected final String[] filterExt_cer = new String[]{"*.cer"};
    protected int minimumWidth = 600;
    protected Map<ItemDataKey, String> data = new HashMap<ItemDataKey, String>();
    protected boolean bEnableCA;
    protected SigningProfileItem item;
    private Text txtPassword;

    public ProfileItemDialog(Shell parent, SigningProfileItem item) {
        super(parent);
        this.setTitle("Edit Security Profile Item");
        this.setHelpAvailable(false);
        Assert.notNull((Object)item);
        this.item = item;
        this.data.put(ItemDataKey.keyPath, item.getKeyLocation());
        this.data.put(ItemDataKey.password, new String(item.getPassword()));
        this.data.put(ItemDataKey.caPath, item.getCAPath());
        this.data.put(ItemDataKey.rootCaPath, item.getRootCAPath());
        this.bEnableCA = !item.isAuthor();
    }

    public String getKeyPath() {
        return this.data.get((Object)ItemDataKey.keyPath);
    }

    public char[] getPassword() {
        return this.data.get((Object)ItemDataKey.password).toCharArray();
    }

    public String getCaPath() {
        return this.data.get((Object)ItemDataKey.caPath);
    }

    public String getRootPath() {
        return this.data.get((Object)ItemDataKey.rootCaPath);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gridData = (GridData)composite.getLayoutData();
        gridData.minimumWidth = this.minimumWidth;
        gridData.widthHint = this.minimumWidth;
        this.createTextWithBrowse(composite, ItemDataKey.keyPath, this.filterExt_p12, true);
        this.createPasswordText(composite, ItemDataKey.password);
        this.createTextWithBrowse(composite, ItemDataKey.caPath, this.filterExt_cer, true);
        this.createTextWithBrowse(composite, ItemDataKey.rootCaPath, this.filterExt_cer, this.bEnableCA);
        return composite;
    }

    protected Composite createPasswordText(Composite parent, final ItemDataKey key) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 0);
        label.setText(key.getTitle());
        GridData labelLayoutData = new GridData();
        labelLayoutData.horizontalSpan = 3;
        label.setLayoutData((Object)labelLayoutData);
        this.txtPassword = new Text(composite, 0x400804);
        GridData textLayoutData = new GridData(768);
        textLayoutData.horizontalSpan = 2;
        this.txtPassword.setLayoutData((Object)textLayoutData);
        this.txtPassword.setText(this.data.get((Object)key));
        this.txtPassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyevent) {
                ProfileItemDialog.this.data.put(key, ProfileItemDialog.this.txtPassword.getText());
            }
        });
        return composite;
    }

    protected Composite createTextWithBrowse(Composite parent, final ItemDataKey key, final String[] filterExtension, boolean bEnable) {
        final Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 0);
        label.setText(key.getTitle());
        GridData labelLayoutData = new GridData();
        labelLayoutData.horizontalSpan = 3;
        label.setLayoutData((Object)labelLayoutData);
        final Text text = new Text(composite, 2052);
        GridData textLayoutData = new GridData(768);
        textLayoutData.horizontalSpan = 2;
        text.setLayoutData((Object)textLayoutData);
        text.setText(this.data.get((Object)key));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyevent) {
                ProfileItemDialog.this.data.put(key, text.getText());
            }
        });
        text.setEnabled(bEnable);
        Button browseButton = new Button(composite, 8);
        browseButton.setText("Browse...");
        browseButton.setLayoutData((Object)new GridData());
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String value = ProfileItemDialog.this.handleBrowseButtonPressed(composite, filterExtension, ProfileItemDialog.this.data.get((Object)key));
                if (value != null) {
                    text.setText(value);
                    if (key == ItemDataKey.keyPath) {
                        ProfileItemDialog.this.txtPassword.setText("");
                    }
                }
            }
        });
        browseButton.setEnabled(bEnable);
        return composite;
    }

    protected String handleBrowseButtonPressed(Composite parent, String[] filterExtensions, String initialFileName) {
        FileDialog dialog = new FileDialog(parent.getShell(), 0);
        dialog.setFilterExtensions(filterExtensions);
        dialog.setText(Messages.FileBrowserCellEditor_2);
        if (!StringUtil.isEmpty((CharSequence)initialFileName)) {
            dialog.setFileName(initialFileName);
        }
        return dialog.open();
    }

    private static enum ItemDataKey {
        keyPath("Certificate Path", true),
        password("Password", true),
        caPath("CA Path", false),
        rootCaPath("Root CA Path", false);

        private String title;
        private boolean required;

        private ItemDataKey(String title, boolean required) {
            this.title = title;
            this.required = required;
        }

        public String getTitle() {
            return this.getRequired() ? String.valueOf(this.title) + " (*)" : this.title;
        }

        public boolean getRequired() {
            return this.required;
        }
    }
}

