/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.build;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildProperty;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.TizenProjectType;
import org.tizen.common.core.application.Version;
import org.tizen.common.util.OSChecker;
import org.tizen.common.util.SWTUtil;
import org.tizen.nativeappcommon.build.DevPackageManager;
import org.tizen.nativecommon.IXMLStore;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.TizenNativeConstants;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativecommon.build.CommonProjectDependentBuilder;
import org.tizen.nativecommon.build.ProjectTypeManager;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativecommon.build.exception.SBIException;
import org.tizen.nativecore.build.Messages;
import org.tizen.nativecore.build.NativeCoreConfigurationManagerConstants;
import org.tizen.sbilib.ide.PluginManager;
import org.tizen.sbilib.ide.Rootstrap;
import org.tizen.sbilib.ide.TPKException;
import org.tizen.sbilib.ide.Toolchain;
import org.tizen.tpklib.lib.PathUtil;
import org.tizen.tpklib.lib.file.FileSearch;
import org.tizen.tpklib.lib.file.FileUtil;

public class NativeCoreConfigurationManager
extends CommonConfigurationManager {
    private static final String PROPERTY_TIZEN_SETTINGS_PAGE_ID = "org.tizen.nativecommon.build.ui.TizenSettingsPage";
    public static final String CURRENT_SLP_PROJECT_VERSION = "1.0.0";
    public static final String TIZEN_APPLICATION_ARTIFACT_TYPE = "org.tizen.nativecore.buildArtefactType.app";
    public static final String TIZEN_SHARED_LIB_ARTIFACT_TYPE = "org.tizen.nativecore.buildArtefactType.sharedLib";
    public static final String TIZEN_STATIC_LIB_ARTIFACT_TYPE = "org.tizen.nativecore.buildArtefactType.staticLib";
    public static final String GNU_C_UNDEF_SYMBOLS_OPTION_ID = "gnu.c.compiler.option.preprocessor.undef.symbol";
    public static final String GNU_CPP_UNDEF_SYMBOLS_OPTION_ID = "gnu.cpp.compiler.option.preprocessor.undef";
    public static final String SBI_C_DEF_SYMBOLS_OPTION_ID = "sbi.gnu.c.compiler.option.preprocessor.def.symbols.deprecation";
    public static final String SBI_CPP_DEF_SYMBOLS_OPTION_ID = "sbi.gnu.cpp.compiler.option.preprocessor.def.deprecation";
    public static final String SBI_C_COMPILER_TOOL_ID = "org.tizen.nativecore.tool.sbi.gnu.c.compiler";
    public static final String SBI_CPP_COMPILER_TOOL_ID = "org.tizen.nativecore.tool.sbi.gnu.cpp.compiler";
    public static final String SBI_C_DEV_PACKAGE_OPTION_ID = "sbi.gnu.c.compiler.option.frameworks.core";
    public static final String SBI_C_DEV_PACKAGE_OPTION_INCLUDE_ID = "sbi.gnu.c.compiler.option.frameworks_inc.core";
    public static final String SBI_C_DEV_PACKAGE_OPTION_CFLAGS_ID = "sbi.gnu.c.compiler.option.frameworks_cflags.core";
    public static final String SBI_C_COMPILER_DYNAMICANALYSIS_OPTION_ID = "sbi.gnu.c.compiler.option.dynamicanalysis.core";
    public static final String SBI_C_COMPILER_DYNAMICANALYSIS_FLAGS_ID = "sbi.gnu.c.compiler.option.dynamicanalysis_flags.core";
    public static final String SBI_CPP_DEV_PACKAGE_OPTION_ID = "sbi.gnu.cpp.compiler.option.frameworks.core";
    public static final String SBI_CPP_DEV_PACKAGE_OPTION_INCLUDE_ID = "sbi.gnu.cpp.compiler.option.frameworks_inc.core";
    public static final String SBI_CPP_DEV_PACKAGE_OPTION_CFLAGS_ID = "sbi.gnu.cpp.compiler.option.frameworks_cflags.core";
    public static final String SBI_CPP_COMPILER_DYNAMICANALYSIS_OPTION_ID = "sbi.gnu.cpp.compiler.option.dynamicanalysis.core";
    public static final String SBI_CPP_COMPILER_DYNAMICANALYSIS_FLAGS_ID = "sbi.gnu.cpp.compiler.option.dynamicanalysis_flags.core";
    public static final String SBI_CPP_DEV_PACKAGE_OPTION_LFALGS_ID = "sbi.gnu.cpp.linker.option.frameworks_lflags.core";
    public static final String SBI_CPP_LINKER_DYNAMICANALYSIS_FLAGS_ID = "sbi.gnu.cpp.linker.option.dynamicanalysis_flags.core";
    public static final String SBI_C_OTHER_FPIC_ID = "sbi.gnu.c.compiler.option.misc.pic.core";
    public static final String SBI_CPP_OTHER_FPIC_ID = "sbi.gnu.cpp.compiler.option.misc.pic.core";
    public static final String SBI_CPP_LINKER_OTHER_SHARED_ID = "sbi.gnu.cpp.linker.option.shared_flag.core";
    public static final String SBI_C_BUILT_IN_CFLAGS_OPTION_ID = "sbi.gnu.c.compiler.option.built_in_cflags.core";
    public static final String SBI_CPP_BUILT_IN_CFLAGS_OPTION_ID = "sbi.gnu.cpp.compiler.option.built_in_cflags.core";
    public static final String SBI_C_COMPILER_CORE_STATIC_OPTION_ID = "sbi.gnu.c.compiler.option.wi.app.core";
    public static final String SBI_CPP_COMPILER_CORE_STATIC_OPTION_ID = "sbi.gnu.cpp.compiler.option.wi.app.core";
    public static final String SBI_CPP_LINKER_CORE_STATIC_OPTION_ID = "sbi.gnu.cpp.linker.option.app_flag.core";
    public static final String SBI_CPP_LINKER_TOOL_ID = "org.tizen.nativecore.tool.sbi.gnu.cpp.linker";
    public static final String SBI_PO_COMPILER_TOOL_ID = "org.tizen.nativecore.tool.sbi.po.compiler";
    public static final String SBI_ARCHIVE_TOOL_ID = "org.tizen.nativecore.tool.sbi.gnu.archiver";
    public static final String SBI_STATIC_LIB_MERGE_TOOL_ID = "org.tizen.nativecore.tool.sbi.gnu.archiver.mergelib";
    public static final String SBI_STATIC_LIB_MERGE_TOOL_OPTIONS = "org.tizen.nativecore.tool.sbi.gnu.archiver.mergelib.general";
    public static final String SBI_STATIC_LIB_MERGE_TOOL_LIBS = "org.tizen.nativecore.tool.sbi.gnu.archiver.mergelib.otherlibs";
    public static final String GNU_C_INCLUDE_FILE_OPTION_ID = "gnu.c.compiler.option.include.files";
    public static final String GNU_CPP_INCLUDE_FILE_OPTION_ID = "gnu.cpp.compiler.option.include.files";
    public static final String GNU_C_OPTIMIZATION_LEVEL_OPTION_ID = "gnu.c.compiler.option.optimization.level";
    public static final String GNU_CPP_OPTIMIZATION_LEVEL_OPTION_ID = "gnu.cpp.compiler.option.optimization.level";
    public static final String SBI_C_COMPILER_DEBUG_LEVEL_OPTION_ID = "sbi.gnu.c.compiler.option.debugging.level.core";
    public static final String SBI_CPP_COMPILER_DEBUG_LEVEL_OPTION_ID = "sbi.gnu.cpp.compiler.option.debugging.level.core";
    public static final String GNU_CPP_LINKER_SONAME_OPTION_ID = "gnu.cpp.link.option.soname";
    public static final String GNU_CPP_LINKER_IMPLNAME_OPTION_ID = "gnu.cpp.link.option.implname";
    public static final String GNU_CPP_LINKER_DEFNAME_OPTION_ID = "gnu.cpp.link.option.defname";
    public static final String DEFAULT_INCLUDE_PATH = "\"${workspace_loc:/${ProjName}/inc}\"";
    public static final String DEFAULT_LIBRARY_PATH = "\"${workspace_loc:/${ProjName}/lib}\"";
    public static final String MACRO_PLATFORM_DEFAULT_GCC_PATH = "PLATFORM_DEFAULT_GCC_PATH";
    public static final String MACRO_PLATFORM_DEFAULT_TOOLCHAIN_PREFIX = "PLATFORM_DEFAULT_GCC_PREFIX";
    public static final String LLVM_NAME_PREFIX = "llvm-";
    public static final String GCC_NAME_PREFIX = "gcc-";
    private static final String LIB_PREFIX = "lib";
    private static final String LIBSO_EXT = ".so";
    private static final String LIBA_EXT = ".a";
    private static final String ASTERISK = "*";
    private static final String NATIVE_API_FRAMEWORK = "Native_API";
    private static String exportMapFileName = ".exportMap";
    private static Logger logger = LoggerFactory.getLogger(NativeCoreConfigurationManager.class);

    public static String getBuildTargetName(IConfiguration config, ITool tool) {
        String[] targetList;
        String target = "";
        String tool_id = tool.getBaseId();
        String option_id = "";
        if (tool_id.contains(SBI_C_COMPILER_TOOL_ID)) {
            option_id = "sbi.gnu.c.compiler.option";
        } else if (tool_id.contains(SBI_CPP_COMPILER_TOOL_ID)) {
            option_id = "sbi.gnu.cpp.compiler.option";
        }
        IOption targetOption = tool.getOptionBySuperClassId(option_id);
        try {
            targetList = targetOption.getUserObjects();
        }
        catch (BuildException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
        if (targetList.length != 1) {
            return null;
        }
        target = targetList[0];
        return NativeCoreConfigurationManager.verifyTarget((IConfiguration)config, (String)target);
    }

    public static String getTargetIdFromConfiguration(IConfiguration config, Tool tool) {
        String[] targetList;
        String target = "";
        String tool_id = tool.getBaseId();
        String option_id = "";
        if (tool_id.contains(SBI_C_COMPILER_TOOL_ID)) {
            option_id = "sbi.gnu.c.compiler.option";
        } else if (tool_id.contains(SBI_CPP_COMPILER_TOOL_ID)) {
            option_id = "sbi.gnu.cpp.compiler.option";
        }
        IOption targetOption = tool.getOptionBySuperClassId(option_id);
        try {
            targetList = targetOption.getUserObjects();
        }
        catch (BuildException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
        if (targetList.length != 1) {
            return null;
        }
        target = targetList[0];
        return target;
    }

    public static void setDynamicAnalysisOption(IConfiguration config, String option) {
        String c_compiler_id = SBI_C_COMPILER_TOOL_ID;
        String cpp_compiler_id = SBI_CPP_COMPILER_TOOL_ID;
        String c_compiler_dyn_id = SBI_C_COMPILER_DYNAMICANALYSIS_OPTION_ID;
        String cpp_compiler_dyn_id = SBI_CPP_COMPILER_DYNAMICANALYSIS_OPTION_ID;
        ArrayList<String> tmpList = new ArrayList<String>();
        tmpList.add(option);
        ITool c_compilerTool = config.getToolsBySuperClassId(c_compiler_id)[0];
        IOption dynamicAnalysisOption = c_compilerTool.getOptionBySuperClassId(c_compiler_dyn_id);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)c_compilerTool, (IOption)dynamicAnalysisOption, (String[])tmpList.toArray(new String[0]));
        ITool cpp_compilerTool = config.getToolsBySuperClassId(cpp_compiler_id)[0];
        dynamicAnalysisOption = cpp_compilerTool.getOptionBySuperClassId(cpp_compiler_dyn_id);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)cpp_compilerTool, (IOption)dynamicAnalysisOption, (String[])tmpList.toArray(new String[0]));
    }

    public static String getDynamicAnalysisOption(IConfiguration config) {
        String c_compiler_id = SBI_C_COMPILER_TOOL_ID;
        String c_compiler_dyn_id = SBI_C_COMPILER_DYNAMICANALYSIS_OPTION_ID;
        ITool compilerTool = config.getToolsBySuperClassId(c_compiler_id)[0];
        IOption dynamicAnalysisOption = compilerTool.getOptionBySuperClassId(c_compiler_dyn_id);
        String[] dynamicAnalysisFlags = new String[]{""};
        try {
            dynamicAnalysisFlags = dynamicAnalysisOption.getUserObjects();
        }
        catch (BuildException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (dynamicAnalysisFlags.length == 0) {
            return "";
        }
        return dynamicAnalysisFlags[0];
    }

    public static void setDynamicAnalysisLinkerFlags(IConfiguration config, Tool tool, ArrayList<String> optionList) {
        String tool_id = tool.getBaseId();
        String option_id = "";
        if (!tool_id.contains(SBI_CPP_COMPILER_TOOL_ID)) {
            return;
        }
        tool_id = SBI_CPP_LINKER_TOOL_ID;
        option_id = SBI_CPP_LINKER_DYNAMICANALYSIS_FLAGS_ID;
        ITool cpp_linkerTool = config.getToolsBySuperClassId(tool_id)[0];
        IOption dynamicAnalysisOption = cpp_linkerTool.getOptionBySuperClassId(option_id);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)cpp_linkerTool, (IOption)dynamicAnalysisOption, (String[])optionList.toArray(new String[0]));
    }

    public static void setDynamicAnalysisCompilerFlags(IConfiguration config, Tool tool, ArrayList<String> optionList) {
        String tool_id = tool.getBaseId();
        String option_id = "";
        if (tool_id.contains(SBI_C_COMPILER_TOOL_ID)) {
            option_id = SBI_C_COMPILER_DYNAMICANALYSIS_FLAGS_ID;
        } else if (tool_id.contains(SBI_CPP_COMPILER_TOOL_ID)) {
            option_id = SBI_CPP_COMPILER_DYNAMICANALYSIS_FLAGS_ID;
        } else {
            return;
        }
        ITool c_compilerTool = config.getToolsBySuperClassId(tool_id)[0];
        IOption dynamicAnalysisOption = c_compilerTool.getOptionBySuperClassId(option_id);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)c_compilerTool, (IOption)dynamicAnalysisOption, (String[])optionList.toArray(new String[0]));
    }

    public static void setDevPackageList(IConfiguration config, List<String> devPackageList) {
        String c_compiler_id = SBI_C_COMPILER_TOOL_ID;
        String cpp_compiler_id = SBI_CPP_COMPILER_TOOL_ID;
        String c_compiler_dev_id = SBI_C_DEV_PACKAGE_OPTION_ID;
        String cpp_compiler_dev_id = SBI_CPP_DEV_PACKAGE_OPTION_ID;
        ITool c_compilerTool = config.getToolsBySuperClassId(c_compiler_id)[0];
        IOption devPackageOption = c_compilerTool.getOptionBySuperClassId(c_compiler_dev_id);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)c_compilerTool, (IOption)devPackageOption, (String[])devPackageList.toArray(new String[0]));
        ITool cpp_compilerTool = config.getToolsBySuperClassId(cpp_compiler_id)[0];
        devPackageOption = cpp_compilerTool.getOptionBySuperClassId(cpp_compiler_dev_id);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)cpp_compilerTool, (IOption)devPackageOption, (String[])devPackageList.toArray(new String[0]));
    }

    public static void setDevPackageList(IConfiguration config, Tool tool, ArrayList<String> devPackageList) {
        String tool_id = tool.getBaseId();
        String option_id = "";
        if (tool_id.contains(SBI_C_COMPILER_TOOL_ID)) {
            option_id = SBI_C_DEV_PACKAGE_OPTION_ID;
        } else if (tool_id.contains(SBI_CPP_COMPILER_TOOL_ID)) {
            option_id = SBI_CPP_DEV_PACKAGE_OPTION_ID;
        } else {
            return;
        }
        ITool compilerTool = config.getToolsBySuperClassId(tool_id)[0];
        IOption devPackageOption = compilerTool.getOptionBySuperClassId(option_id);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)compilerTool, (IOption)devPackageOption, (String[])devPackageList.toArray(new String[0]));
    }

    public static void setFrameworkIncludePaths(IConfiguration config, Tool tool, ArrayList<String> includePaths) {
        String tool_id = tool.getBaseId();
        String option_id = "";
        if (tool_id.contains(SBI_C_COMPILER_TOOL_ID)) {
            option_id = SBI_C_DEV_PACKAGE_OPTION_INCLUDE_ID;
        } else if (tool_id.contains(SBI_CPP_COMPILER_TOOL_ID)) {
            option_id = SBI_CPP_DEV_PACKAGE_OPTION_INCLUDE_ID;
        } else {
            return;
        }
        ITool t = config.getToolsBySuperClassId(tool_id)[0];
        IOption frameworkPathOptions = t.getOptionBySuperClassId(option_id);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)t, (IOption)frameworkPathOptions, (String[])includePaths.toArray(new String[0]));
    }

    public static void setFrameworkCflags(IConfiguration config, Tool tool, ArrayList<String> optionList) {
        String tool_id = tool.getBaseId();
        String option_id = "";
        if (tool_id.contains(SBI_C_COMPILER_TOOL_ID)) {
            option_id = SBI_C_DEV_PACKAGE_OPTION_CFLAGS_ID;
        } else if (tool_id.contains(SBI_CPP_COMPILER_TOOL_ID)) {
            option_id = SBI_CPP_DEV_PACKAGE_OPTION_CFLAGS_ID;
        } else {
            return;
        }
        ITool t = config.getToolsBySuperClassId(tool_id)[0];
        IOption frameworkPathOptions = t.getOptionBySuperClassId(option_id);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)t, (IOption)frameworkPathOptions, (String[])optionList.toArray(new String[0]));
    }

    public static void setFrameworkCflags(IConfiguration config, List<String> optionList) {
        String c_compiler_id = SBI_C_COMPILER_TOOL_ID;
        String c_compiler_cflag_id = SBI_C_DEV_PACKAGE_OPTION_CFLAGS_ID;
        ITool c_compilerTool = config.getToolsBySuperClassId(c_compiler_id)[0];
        IOption frameworkPathOptions = c_compilerTool.getOptionBySuperClassId(c_compiler_cflag_id);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)c_compilerTool, (IOption)frameworkPathOptions, (String[])optionList.toArray(new String[0]));
    }

    public static void setFrameworkCPPflags(IConfiguration config, List<String> optionList) {
        String cpp_compiler_id = SBI_CPP_COMPILER_TOOL_ID;
        String cpp_compiler_cflag_id = SBI_CPP_DEV_PACKAGE_OPTION_CFLAGS_ID;
        ITool cpp_compilerTool = config.getToolsBySuperClassId(cpp_compiler_id)[0];
        IOption frameworkPathOptions = cpp_compilerTool.getOptionBySuperClassId(cpp_compiler_cflag_id);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)cpp_compilerTool, (IOption)frameworkPathOptions, (String[])optionList.toArray(new String[0]));
    }

    public static void setFrameworkLflags(IConfiguration config, Tool tool, ArrayList<String> optionList) {
        String tool_id = tool.getBaseId();
        String option_id = "";
        if (!tool_id.contains(SBI_CPP_COMPILER_TOOL_ID)) {
            return;
        }
        tool_id = SBI_CPP_LINKER_TOOL_ID;
        option_id = SBI_CPP_DEV_PACKAGE_OPTION_LFALGS_ID;
        ITool cpp_linkerTool = config.getToolsBySuperClassId(tool_id)[0];
        IOption frameworkPathOptions = cpp_linkerTool.getOptionBySuperClassId(option_id);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)cpp_linkerTool, (IOption)frameworkPathOptions, (String[])optionList.toArray(new String[0]));
    }

    public static void setFrameworkLflags(IConfiguration config, List<String> optionList) {
        String tool_id = SBI_CPP_LINKER_TOOL_ID;
        String option_id = SBI_CPP_DEV_PACKAGE_OPTION_LFALGS_ID;
        ITool cpp_linkerTool = config.getToolsBySuperClassId(tool_id)[0];
        IOption frameworkPathOptions = cpp_linkerTool.getOptionBySuperClassId(option_id);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)cpp_linkerTool, (IOption)frameworkPathOptions, (String[])optionList.toArray(new String[0]));
    }

    public static void appendFrameworkLflag(IConfiguration config, String flag) {
        ArrayList<String> lflags = NativeCoreConfigurationManager.getFrameworkLflags(config);
        if (!lflags.contains(flag)) {
            lflags.add(flag);
        }
        NativeCoreConfigurationManager.setFrameworkLflags(config, lflags);
    }

    public static void appendFrameworkCflag(IConfiguration config, String flag) {
        ArrayList<String> cflags = NativeCoreConfigurationManager.getFrameworkCflags(config);
        if (!cflags.contains(flag)) {
            cflags.add(flag);
        }
        NativeCoreConfigurationManager.setFrameworkCflags(config, cflags);
    }

    public static void appendFrameworkCPPflag(IConfiguration config, String flag) {
        ArrayList<String> cppflags = NativeCoreConfigurationManager.getFrameworkCPPflags(config);
        if (!cppflags.contains(flag)) {
            cppflags.add(flag);
        }
        NativeCoreConfigurationManager.setFrameworkCPPflags(config, cppflags);
    }

    public static void removeFrameworkLflag(IConfiguration config, String flag) {
        ArrayList<String> lflags = NativeCoreConfigurationManager.getFrameworkLflags(config);
        lflags.remove(flag);
        NativeCoreConfigurationManager.setFrameworkLflags(config, lflags);
    }

    public static void removeFrameworkCflag(IConfiguration config, String flag) {
        ArrayList<String> cflags = NativeCoreConfigurationManager.getFrameworkCflags(config);
        cflags.remove(flag);
        NativeCoreConfigurationManager.setFrameworkCflags(config, cflags);
    }

    public static void removeFrameworkCPPflag(IConfiguration config, String flag) {
        ArrayList<String> cppflags = NativeCoreConfigurationManager.getFrameworkCPPflags(config);
        cppflags.remove(flag);
        NativeCoreConfigurationManager.setFrameworkCPPflags(config, cppflags);
    }

    public static ArrayList<String> getFrameworkIncludePaths(IConfiguration config) {
        String c_compiler_id = SBI_C_COMPILER_TOOL_ID;
        String c_compiler_include_id = SBI_C_DEV_PACKAGE_OPTION_INCLUDE_ID;
        ArrayList<String> flags = new ArrayList<String>();
        ITool c_compilerTool = config.getToolsBySuperClassId(c_compiler_id)[0];
        IOption frameworkPathOptions = c_compilerTool.getOptionBySuperClassId(c_compiler_include_id);
        try {
            String[] stringArray = frameworkPathOptions.getIncludePaths();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                flags.add(f);
                ++n2;
            }
        }
        catch (BuildException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return flags;
    }

    public static ArrayList<String> getFrameworkCflags(IConfiguration config) {
        String c_compiler_id = SBI_C_COMPILER_TOOL_ID;
        String c_compiler_cflag_id = SBI_C_DEV_PACKAGE_OPTION_CFLAGS_ID;
        ArrayList<String> flags = new ArrayList<String>();
        ITool c_compilerTool = config.getToolsBySuperClassId(c_compiler_id)[0];
        IOption frameworkPathOptions = c_compilerTool.getOptionBySuperClassId(c_compiler_cflag_id);
        try {
            String[] stringArray = frameworkPathOptions.getStringListValue();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                flags.add(f);
                ++n2;
            }
        }
        catch (BuildException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return flags;
    }

    public static ArrayList<String> getFrameworkCPPflags(IConfiguration config) {
        String c_compiler_id = SBI_CPP_COMPILER_TOOL_ID;
        String c_compiler_cflag_id = SBI_CPP_DEV_PACKAGE_OPTION_CFLAGS_ID;
        ArrayList<String> flags = new ArrayList<String>();
        ITool c_compilerTool = config.getToolsBySuperClassId(c_compiler_id)[0];
        IOption frameworkPathOptions = c_compilerTool.getOptionBySuperClassId(c_compiler_cflag_id);
        try {
            String[] stringArray = frameworkPathOptions.getStringListValue();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                flags.add(f);
                ++n2;
            }
        }
        catch (BuildException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return flags;
    }

    public static ArrayList<String> getFrameworkLflags(IConfiguration config) {
        String cpp_linker_id = SBI_CPP_LINKER_TOOL_ID;
        String cpp_linker_lflag_id = SBI_CPP_DEV_PACKAGE_OPTION_LFALGS_ID;
        ArrayList<String> flags = new ArrayList<String>();
        ITool cpp_linkerTool = config.getToolsBySuperClassId(cpp_linker_id)[0];
        IOption frameworkPathOptions = cpp_linkerTool.getOptionBySuperClassId(cpp_linker_lflag_id);
        try {
            String[] stringArray = frameworkPathOptions.getStringListValue();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                flags.add(f);
                ++n2;
            }
        }
        catch (BuildException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return flags;
    }

    public static List<String> getFrameworkLibraries(IConfiguration config) {
        ArrayList<String> frameworkLibraries = new ArrayList<String>();
        ArrayList<String> staticLibs = new ArrayList<String>();
        ArrayList<String> dynamicLibs = new ArrayList<String>();
        for (String devPackage : NativeCoreConfigurationManager.getDevPackageList(config)) {
            String targetID = NativeCoreConfigurationManager.getBuildTargetName((IConfiguration)config);
            List libraries = DevPackageManager.getLibraryList((String)targetID, (String)devPackage);
            for (String library : libraries) {
                String lflag = NativeCoreConfigurationManager.makeLflag(library);
                if (library.endsWith(LIBA_EXT) && !staticLibs.contains(lflag)) {
                    staticLibs.add(lflag);
                    continue;
                }
                if (dynamicLibs.contains(lflag)) continue;
                dynamicLibs.add(lflag);
            }
        }
        frameworkLibraries.addAll(staticLibs);
        frameworkLibraries.addAll(dynamicLibs);
        return frameworkLibraries;
    }

    private static String makeLflag(String library) {
        String lFlag = "";
        if (library.startsWith(LIB_PREFIX)) {
            if (library.endsWith(LIBA_EXT) || library.endsWith(LIBSO_EXT)) {
                int lastIdx = library.lastIndexOf(".");
                String libName = library.substring(3, lastIdx);
                lFlag = String.format("-l%s", libName);
            } else {
                lFlag = String.format("-l:%s", library);
            }
        } else {
            lFlag = String.format("-l:%s", library);
        }
        return lFlag;
    }

    public static void setFpicflags(IConfiguration config, boolean option) {
        String c_compiler_id = SBI_C_COMPILER_TOOL_ID;
        String c_compiler_fpic_id = SBI_C_OTHER_FPIC_ID;
        String cpp_compiler_id = SBI_CPP_COMPILER_TOOL_ID;
        String cpp_compiler_fpic_id = SBI_CPP_OTHER_FPIC_ID;
        ITool c_compilerTool = config.getToolsBySuperClassId(c_compiler_id)[0];
        IOption c_compiler_fPicOptions = c_compilerTool.getOptionBySuperClassId(c_compiler_fpic_id);
        ITool cpp_compilerTool = config.getToolsBySuperClassId(cpp_compiler_id)[0];
        IOption cpp_compiler_fPicOptions = cpp_compilerTool.getOptionBySuperClassId(cpp_compiler_fpic_id);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)c_compilerTool, (IOption)c_compiler_fPicOptions, (boolean)option);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)cpp_compilerTool, (IOption)cpp_compiler_fPicOptions, (boolean)option);
    }

    public static void setSharedflags(IConfiguration config, boolean option) {
        String cpp_linker_id = SBI_CPP_LINKER_TOOL_ID;
        String cpp_linker_shared_id = SBI_CPP_LINKER_OTHER_SHARED_ID;
        ITool c_linkerTool = config.getToolsBySuperClassId(cpp_linker_id)[0];
        IOption sharedOptions = c_linkerTool.getOptionBySuperClassId(cpp_linker_shared_id);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)c_linkerTool, (IOption)sharedOptions, (boolean)option);
    }

    public static boolean getFpicflags(IConfiguration config) {
        String c_compiler_id = SBI_C_COMPILER_TOOL_ID;
        String c_compiler_fpic_id = SBI_C_OTHER_FPIC_ID;
        ITool c_compilerTool = config.getToolsBySuperClassId(c_compiler_id)[0];
        IOption fPicOptions = c_compilerTool.getOptionBySuperClassId(c_compiler_fpic_id);
        boolean result = false;
        try {
            result = fPicOptions.getBooleanValue();
        }
        catch (BuildException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static boolean getSharedflags(IConfiguration config) {
        String cpp_linker_id = SBI_CPP_LINKER_TOOL_ID;
        String cpp_linker_shared_id = SBI_CPP_LINKER_OTHER_SHARED_ID;
        ITool c_linkerTool = config.getToolsBySuperClassId(cpp_linker_id)[0];
        IOption sharedOptions = c_linkerTool.getOptionBySuperClassId(cpp_linker_shared_id);
        boolean result = false;
        try {
            result = sharedOptions.getBooleanValue();
        }
        catch (BuildException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static ArrayList<String> getDevPackageList(IConfiguration config) {
        String c_compiler_id = SBI_C_COMPILER_TOOL_ID;
        String c_compiler_dev_id = SBI_C_DEV_PACKAGE_OPTION_ID;
        ArrayList<String> devPackageList = new ArrayList<String>();
        ITool compilerTool = config.getToolsBySuperClassId(c_compiler_id)[0];
        IOption devPackageOption = compilerTool.getOptionBySuperClassId(c_compiler_dev_id);
        try {
            String[] stringArray = devPackageOption.getUserObjects();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String devPackage = stringArray[n2];
                devPackageList.add(devPackage);
                ++n2;
            }
        }
        catch (BuildException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return devPackageList;
        }
        return devPackageList;
    }

    public static String getAllCFlags(IConfiguration config) {
        String c_compiler_id = SBI_C_COMPILER_TOOL_ID;
        return NativeCoreConfigurationManager.getAllCompilerFlags(config, c_compiler_id);
    }

    public static String getAllCPPFlags(IConfiguration config) {
        String cpp_compiler_id = SBI_CPP_COMPILER_TOOL_ID;
        return NativeCoreConfigurationManager.getAllCompilerFlags(config, cpp_compiler_id);
    }

    protected static String getAllCompilerFlags(IConfiguration config, String compilerId) {
        ITool compilerTool = config.getToolsBySuperClassId(compilerId)[0];
        String compilerFlags = "";
        try {
            compilerFlags = compilerTool.getToolFlags();
            String[] flags = compilerFlags.split(" ");
            compilerFlags = "";
            int i = 0;
            while (i < flags.length) {
                if (flags[i].compareTo("-c") != 0) {
                    flags[i] = flags[i].replace("\"", "\\\"");
                    compilerFlags = String.valueOf(compilerFlags) + " " + flags[i];
                }
                ++i;
            }
        }
        catch (BuildException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        String dynamicAnalysisFlags = NativeCoreConfigurationManager.getDynamicAnalysisOption(config);
        if (!dynamicAnalysisFlags.isEmpty()) {
            compilerFlags = compilerFlags.concat(String.format(" %s", dynamicAnalysisFlags));
        }
        compilerFlags = compilerFlags.trim();
        return compilerFlags;
    }

    public static String getAllLinkerFlags(IConfiguration config) {
        String objOption;
        String linkerOption;
        String linkerId;
        String c_linker_id = "org.tizen.nativeide.tool.sbi.gnu.c.linker.base";
        String cpp_linker_id = SBI_CPP_LINKER_TOOL_ID;
        if (NativeCoreConfigurationManager.isCPPProject(config)) {
            linkerId = cpp_linker_id;
            linkerOption = "gnu.cpp.link.option.libs";
            objOption = "gnu.cpp.link.option.userobjs";
        } else {
            linkerId = c_linker_id;
            linkerOption = "gnu.c.link.option.libs";
            objOption = "gnu.c.link.option.userobjs";
        }
        ITool linkerTool = config.getToolsBySuperClassId(linkerId)[0];
        IOption librariesOption = linkerTool.getOptionBySuperClassId(linkerOption);
        IOption userObjOption = linkerTool.getOptionBySuperClassId(objOption);
        String[] librariesFlags = new String[]{""};
        String linkerFlags = "";
        String[] userObjFlags = new String[]{""};
        try {
            String linkerToolFlags = linkerTool.getToolFlags();
            linkerToolFlags = linkerToolFlags.replace("\"", "\\\"");
            if (!linkerToolFlags.equals("")) {
                linkerFlags = linkerFlags.concat(String.valueOf(linkerToolFlags) + " ");
            }
            userObjFlags = userObjOption.getBasicStringListValue();
            int i = 0;
            while (i < userObjFlags.length) {
                linkerFlags = linkerFlags.concat(String.format("%s ", userObjFlags[i]));
                ++i;
            }
            librariesFlags = librariesOption.getLibraries();
            i = 0;
            while (i < librariesFlags.length) {
                linkerFlags = linkerFlags.concat(String.format("-l%s ", librariesFlags[i]));
                ++i;
            }
        }
        catch (BuildException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        String dynamicAnalysisFlags = NativeCoreConfigurationManager.getDynamicAnalysisOption(config);
        if (!dynamicAnalysisFlags.isEmpty()) {
            linkerFlags = linkerFlags.concat(String.format(" %s", dynamicAnalysisFlags));
        }
        linkerFlags = linkerFlags.trim();
        return linkerFlags;
    }

    protected static boolean isCPPProject(IConfiguration config) {
        try {
            IProject project = (IProject)config.getOwner();
            if (project.hasNature("org.eclipse.cdt.core.ccnature")) {
                return true;
            }
        }
        catch (CoreException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static void appendIncludePathToCCompiler(IConfiguration config, String includePath) {
        NativeCoreConfigurationManager.appendIncludePathToCompiler(config, SBI_C_COMPILER_TOOL_ID, includePath);
    }

    public static void appendIncludePathToCPPCompiler(IConfiguration config, String includePath) {
        NativeCoreConfigurationManager.appendIncludePathToCompiler(config, SBI_CPP_COMPILER_TOOL_ID, includePath);
    }

    public static void appendIncludePathToCompiler(IConfiguration config, String compilerId, String includePath) {
        ITool compilerTool = config.getToolsBySuperClassId(compilerId)[0];
        IOption includePathOption = compilerId.equals(SBI_C_COMPILER_TOOL_ID) ? compilerTool.getOptionBySuperClassId("gnu.c.compiler.option.include.paths") : compilerTool.getOptionBySuperClassId("gnu.cpp.compiler.option.include.paths");
        ArrayList<String> tmpList = new ArrayList<String>();
        try {
            String[] includePaths;
            String[] stringArray = includePaths = includePathOption.getIncludePaths();
            int n = includePaths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                tmpList.add(path);
                ++n2;
            }
        }
        catch (BuildException e) {
            logger.error(NLS.bind((String)Messages.NativeConfigurationManager_GetBuildOptionError, (Object)""), (Throwable)e);
        }
        tmpList.add(includePath);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)compilerTool, (IOption)includePathOption, (String[])tmpList.toArray(new String[0]));
    }

    public static void appendIncludePathToCompiler(IConfiguration config, Tool tool, String includePath) {
        String tool_id = tool.getBaseId();
        String option_id = "";
        if (tool_id.contains(SBI_C_COMPILER_TOOL_ID)) {
            option_id = "gnu.c.compiler.option.include.paths";
        } else if (tool_id.contains(SBI_CPP_COMPILER_TOOL_ID)) {
            option_id = "gnu.cpp.compiler.option.include.paths";
        } else {
            return;
        }
        ITool t = config.getToolsBySuperClassId(tool_id)[0];
        IOption includePathOption = t.getOptionBySuperClassId(option_id);
        ArrayList<String> tmpList = new ArrayList<String>();
        try {
            String[] includePaths;
            String[] stringArray = includePaths = includePathOption.getIncludePaths();
            int n = includePaths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                tmpList.add(path);
                ++n2;
            }
        }
        catch (BuildException e) {
            logger.error(NLS.bind((String)Messages.NativeConfigurationManager_GetBuildOptionError, (Object)""), (Throwable)e);
        }
        tmpList.add(includePath);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)t, (IOption)includePathOption, (String[])tmpList.toArray(new String[0]));
    }

    public static void setIncludePathToCCompiler(IConfiguration config, String[] includePaths) {
        NativeCoreConfigurationManager.setIncludePathToCompiler(config, SBI_C_COMPILER_TOOL_ID, includePaths);
    }

    public static void setIncludePathToCPPCompiler(IConfiguration config, String[] includePaths) {
        NativeCoreConfigurationManager.setIncludePathToCompiler(config, SBI_CPP_COMPILER_TOOL_ID, includePaths);
    }

    public static void setIncludePathToCompiler(IConfiguration config, String compilerId, String[] includePaths) {
        ITool compilerTool = config.getToolsBySuperClassId(compilerId)[0];
        IOption includePathOption = compilerId.equals(SBI_C_COMPILER_TOOL_ID) ? compilerTool.getOptionBySuperClassId("gnu.c.compiler.option.include.paths") : compilerTool.getOptionBySuperClassId("gnu.cpp.compiler.option.include.paths");
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)compilerTool, (IOption)includePathOption, (String[])includePaths);
    }

    private static List<String> arrangeDevList(List<String> allList, List<String> list) {
        ArrayList<String> arrangedList = new ArrayList<String>();
        for (String pkg : allList) {
            if (!list.contains(pkg)) continue;
            arrangedList.add(pkg);
        }
        return arrangedList;
    }

    public static void changePlatform(IProject project, String profile, String version) {
        if (project == null) {
            throw new IllegalArgumentException("Cannot change platform(null)");
        }
        if (profile == null || profile.isEmpty() || version == null || version.isEmpty()) {
            throw new IllegalArgumentException(String.format("Cannot change platform(profile=%s, version=%s)", profile, version));
        }
        NativeCoreConfigurationManager.changeToolchain(project, profile, version);
        NativeCoreConfigurationManager.changeProject((IProject)project, (String)profile, (String)version);
    }

    private static void changeToolchain(final IProject project, String profile, String version) {
        boolean isDefaultTarget = false;
        String newTargetId = NativeCoreConfigurationManager.getNewTargetId(project, profile, version);
        if (newTargetId == null) {
            newTargetId = NativeCoreConfigurationManager.getDefaultTargetId(project, profile, version);
            isDefaultTarget = true;
        }
        if (newTargetId == null) {
            SWTUtil.asyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    StringBuilder error = new StringBuilder();
                    error.append(Messages.FAILED_TO_CHANGE_BUILD_INFORMATION_FOR_THE_PROJECT);
                    error.append(project.getName());
                    logger.error(error.toString());
                    MessageDialog.openError((Shell)shell, (String)Messages.ERROR, (String)String.format(error.toString(), new Object[0]));
                }
            });
            return;
        }
        IConfiguration config = ProjectUtil.getDefaultConfiguration((IProject)project);
        NativeCoreConfigurationManager.changeToolchain(config, newTargetId);
        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
        if (isDefaultTarget) {
            logger.info("Getting default toolchain settings verified by the user");
            NativeCoreConfigurationManager.getToolchainVerifiedByUser(project);
        }
    }

    private static void getToolchainVerifiedByUser(final IProject project) {
        SWTUtil.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                if (MessageDialog.openQuestion((Shell)shell, (String)Messages.VERIFY_TOOLCHAIN_SETTINGS, (String)Messages.TOOLCHAIN_CONFIRMATION_MESSAGE)) {
                    PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)shell, (IAdaptable)project, (String)NativeCoreConfigurationManager.PROPERTY_TIZEN_SETTINGS_PAGE_ID, null, null);
                    dialog.open();
                }
            }
        });
    }

    private static String getDefaultTargetId(IProject project, String profile, String version) {
        PluginManager pm = PluginManager.getInstance();
        String targetId = null;
        for (Rootstrap rs : pm.getRootstrapList()) {
            String[] platformInfos = rs.getId().split("-");
            if (platformInfos.length <= 1) continue;
            String rsProfile = rs.getProfile().trim().toLowerCase();
            String rsVersion = rs.getProfileVersion().trim();
            if (!rsProfile.equals(profile) || !rsVersion.equals(version)) continue;
            try {
                targetId = pm.makeTargetId(rs.getId(), pm.getDefaultToolchain(rs).getId());
            }
            catch (TPKException e) {
                logger.info(e.getMessage());
            }
            break;
        }
        return targetId;
    }

    private static String getNewTargetId(IProject project, String profile, String version) {
        String oldTargetId;
        PluginManager pm = PluginManager.getInstance();
        String oldRootstrapId = pm.getRootstrapIDFromTargetID(oldTargetId = NativeCoreConfigurationManager.getTargetIdFromProject(project));
        String[] oldTargetInfo = oldRootstrapId.split("-");
        if (oldTargetInfo.length < 3) {
            return null;
        }
        String oldTarget = oldTargetInfo[oldTargetInfo.length - 1];
        String newRootstrapId = NativeCoreConfigurationManager.getRootstrapId(profile, version, oldTarget);
        Rootstrap rootstap = pm.getRootstrap(newRootstrapId);
        if (rootstap != null) {
            String toolchainId = pm.getToolchainIDFromTargetID(oldTargetId);
            return pm.makeTargetId(newRootstrapId, toolchainId);
        }
        return null;
    }

    private static String getRootstrapId(String profile, String version, String target) {
        if (profile == null || version == null || target == null) {
            throw new IllegalArgumentException();
        }
        return String.valueOf(profile.toLowerCase()) + "-" + version + "-" + target;
    }

    public static String getTargetIdFromProject(IProject project) {
        CommonProjectDependentBuilder builder = ProjectTypeManager.getProjectBuilderInstance((IProject)project);
        if (builder == null) {
            return "";
        }
        IConfiguration config = ProjectUtil.getDefaultConfiguration((IProject)project);
        return builder.getTargetID(config);
    }

    public static void changeToolchain(IConfiguration config, String targetId) {
        NativeCoreConfigurationManager.setBuildTargetName((IConfiguration)config, (String)targetId);
        NativeCoreConfigurationManager.setToolCommand((IConfiguration)config);
        List allDevList = DevPackageManager.getAllDevPkgName((String)targetId);
        ArrayList<String> devList = NativeCoreConfigurationManager.getDevPackageList(config);
        List<String> arrangedList = NativeCoreConfigurationManager.arrangeDevList(allDevList, devList);
        String CCompilerMiscflags = NativeCoreConfigurationManager.getCComplierOtherOptions((IConfiguration)config);
        String CXXCompilerMiscflags = NativeCoreConfigurationManager.getCXXComplierOtherOptions((IConfiguration)config);
        String CXXLinkerMiscflags = NativeCoreConfigurationManager.getCXXLinkerOptions((IConfiguration)config);
        ArrayList<String> emptyDevList = new ArrayList<String>();
        emptyDevList.add("");
        NativeCoreConfigurationManager.setDevPackageList(config, emptyDevList);
        NativeCoreConfigurationManager.setDevPackageList(config, arrangedList);
        NativeCoreConfigurationManager.setCCompilerOtherOptions((IConfiguration)config, (String)CCompilerMiscflags);
        NativeCoreConfigurationManager.setCXXCompilerOtherOptions((IConfiguration)config, (String)CXXCompilerMiscflags);
        NativeCoreConfigurationManager.setCXXLinkerMiscOptions((IConfiguration)config, (String)CXXLinkerMiscflags);
    }

    public static String getCCompilerTool(IConfiguration config) {
        String path;
        block4: {
            try {
                SmartBuildInterface sbi;
                String targetID = NativeCoreConfigurationManager.getBuildTargetName((IConfiguration)config);
                if (targetID == null) {
                    targetID = NativeCoreConfigurationManager.getDefaultBuildTargetName((IConfiguration)config);
                }
                if ((path = (sbi = SmartBuildInterface.getInstance()).getCCompilerPath(targetID)) != null) break block4;
                return "";
            }
            catch (SBIException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return "";
            }
        }
        return new Path(path).lastSegment();
    }

    public static String getCxxCompilerTool(IConfiguration config) {
        String path;
        block4: {
            try {
                SmartBuildInterface sbi;
                String targetID = NativeCoreConfigurationManager.getBuildTargetName((IConfiguration)config);
                if (targetID == null) {
                    targetID = NativeCoreConfigurationManager.getDefaultBuildTargetName((IConfiguration)config);
                }
                if ((path = (sbi = SmartBuildInterface.getInstance()).getCXXCompilerPath(targetID)) != null) break block4;
                return "";
            }
            catch (SBIException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return "";
            }
        }
        return new Path(path).lastSegment();
    }

    public static String getCompilerToolchainBinPath(IConfiguration config) {
        String path;
        block4: {
            try {
                SmartBuildInterface sbi;
                String targetID = NativeCoreConfigurationManager.getBuildTargetName((IConfiguration)config);
                if (targetID == null) {
                    targetID = NativeCoreConfigurationManager.getDefaultBuildTargetName((IConfiguration)config);
                }
                if ((path = (sbi = SmartBuildInterface.getInstance()).getCCompilerPath(targetID)) != null) break block4;
                return "";
            }
            catch (SBIException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return "/usr/bin";
            }
        }
        return new Path(path).removeLastSegments(1).toPortableString();
    }

    public static String getCxxCompilerToolchainBinPath(IConfiguration config) {
        String path;
        block4: {
            try {
                SmartBuildInterface sbi;
                String targetID = NativeCoreConfigurationManager.getBuildTargetName((IConfiguration)config);
                if (targetID == null) {
                    targetID = NativeCoreConfigurationManager.getDefaultBuildTargetName((IConfiguration)config);
                }
                if ((path = (sbi = SmartBuildInterface.getInstance()).getCXXCompilerPath(targetID)) != null) break block4;
                return "";
            }
            catch (SBIException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return "/usr/bin";
            }
        }
        return new Path(path).removeLastSegments(1).toPortableString();
    }

    public static String getArchiveTool(IConfiguration config) {
        String path;
        block4: {
            try {
                SmartBuildInterface sbi;
                String targetID = NativeCoreConfigurationManager.getBuildTargetName((IConfiguration)config);
                if (targetID == null) {
                    targetID = NativeCoreConfigurationManager.getDefaultBuildTargetName((IConfiguration)config);
                }
                if ((path = (sbi = SmartBuildInterface.getInstance()).getArchiverPath(targetID)) != null) break block4;
                return "";
            }
            catch (SBIException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return "";
            }
        }
        return new Path(path).lastSegment();
    }

    public static void setInitialDebugDefinitionSymbolIfNeeded(IProject project, boolean save) {
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration defaultConfig = info.getDefaultConfiguration();
        IConfiguration[] iConfigurationArray = defaultConfig.getManagedProject().getConfigurations();
        int n = iConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration config = iConfigurationArray[n2];
            IBuildProperty prop = config.getBuildProperties().getProperty("org.eclipse.cdt.build.core.buildType");
            if (prop != null && prop.getValue().toString().equals("org.eclipse.cdt.build.core.buildType.debug")) {
                NativeCoreConfigurationManager.appendPreprocessorSymbolToCompiler((IConfiguration)config, (String)"_DEBUG");
            }
            ++n2;
        }
        if (save) {
            ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
        }
    }

    public static void setInitialDebugDefinitionSymbolIfNeeded(IConfiguration config) {
        IConfiguration[] iConfigurationArray = config.getManagedProject().getConfigurations();
        int n = iConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildProperty prop = config.getBuildProperties().getProperty("org.eclipse.cdt.build.core.buildType");
            if (prop != null && prop.getValue().toString().equals("org.eclipse.cdt.build.core.buildType.debug")) {
                NativeCoreConfigurationManager.appendPreprocessorSymbolToCompiler((IConfiguration)config, (String)"_DEBUG");
            }
            ++n2;
        }
    }

    public static void setInitialDebugDefinitionSymbolIfNeeded(IConfiguration config, Tool tool) {
        IConfiguration[] iConfigurationArray = config.getManagedProject().getConfigurations();
        int n = iConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildProperty prop = config.getBuildProperties().getProperty("org.eclipse.cdt.build.core.buildType");
            if (prop != null && prop.getValue().toString().equals("org.eclipse.cdt.build.core.buildType.debug")) {
                NativeCoreConfigurationManager.appendPreprocessorSymbolToCompiler(config, tool, "_DEBUG");
            }
            ++n2;
        }
    }

    public static void appendPreprocessorSymbolToCompiler(IConfiguration config, Tool tool, String symbol) {
        String tool_id = tool.getBaseId();
        String option_id = "";
        if (tool_id.contains(SBI_C_COMPILER_TOOL_ID)) {
            option_id = "gnu.c.compiler.option.preprocessor.def.symbols";
        } else if (tool_id.contains(SBI_CPP_COMPILER_TOOL_ID)) {
            option_id = "gnu.cpp.compiler.option.preprocessor.def";
        } else {
            return;
        }
        ITool compilerTool = config.getToolsBySuperClassId(tool_id)[0];
        IOption symbolOption = compilerTool.getOptionBySuperClassId(option_id);
        ArrayList<String> symbolList = new ArrayList<String>();
        try {
            String[] flags;
            String[] stringArray = flags = symbolOption.getBasicStringListValue();
            int n = flags.length;
            int n2 = 0;
            while (n2 < n) {
                String obj = stringArray[n2];
                symbolList.add(obj);
                ++n2;
            }
        }
        catch (BuildException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (!symbolList.contains(symbol)) {
            symbolList.add(symbol);
            ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)compilerTool, (IOption)symbolOption, (String[])symbolList.toArray(new String[0]));
        }
    }

    public static Toolchain getLatestX86Toolchain(String namePrefix, String appType) {
        Toolchain latestLLVM = null;
        String latestVersion = "";
        PluginManager pm = PluginManager.getInstance();
        for (Toolchain tc : pm.getToolchainList()) {
            String name = tc.getName().toLowerCase();
            String arch = tc.getArchitecture();
            if (!name.startsWith(namePrefix) || !NativeCoreConfigurationManager.isX86Arch((String)arch)) continue;
            String version = name.substring(namePrefix.length());
            if (latestVersion.isEmpty()) {
                latestVersion = version;
                latestLLVM = tc;
                continue;
            }
            Version ver2 = new Version(version);
            Version ver1 = new Version(latestVersion);
            if (ver2.compareTo(ver1) <= 0) continue;
            latestVersion = version;
            latestLLVM = tc;
        }
        return latestLLVM;
    }

    public static Toolchain getLatestX86_64Toolchain(String namePrefix, String appType) {
        Toolchain latestLLVM = null;
        String latestVersion = "";
        PluginManager pm = PluginManager.getInstance();
        for (Toolchain tc : pm.getToolchainList()) {
            String name = tc.getName().toLowerCase();
            String arch = tc.getArchitecture();
            if (!name.startsWith(namePrefix) || !NativeCoreConfigurationManager.isX86_64Arch((String)arch)) continue;
            String version = name.substring(namePrefix.length());
            if (latestVersion.isEmpty()) {
                latestVersion = version;
                latestLLVM = tc;
                continue;
            }
            Version ver2 = new Version(version);
            Version ver1 = new Version(latestVersion);
            if (ver2.compareTo(ver1) <= 0) continue;
            latestVersion = version;
            latestLLVM = tc;
        }
        return latestLLVM;
    }

    public static Toolchain getLatestArmToolchain(String namePrefix, String appType) {
        Toolchain latestLLVM = null;
        String latestVersion = "";
        PluginManager pm = PluginManager.getInstance();
        for (Toolchain tc : pm.getToolchainList()) {
            String name = tc.getName().toLowerCase();
            String arch = tc.getArchitecture();
            if (!name.startsWith(namePrefix) || !NativeCoreConfigurationManager.isArmArch((String)arch)) continue;
            String version = name.substring(namePrefix.length());
            if (latestVersion.isEmpty()) {
                latestVersion = version;
                latestLLVM = tc;
                continue;
            }
            Version ver2 = new Version(version);
            Version ver1 = new Version(latestVersion);
            if (ver2.compareTo(ver1) <= 0) continue;
            latestVersion = version;
            latestLLVM = tc;
        }
        return latestLLVM;
    }

    public static Toolchain getLatestArm64Toolchain(String namePrefix, String appType) {
        Toolchain latestLLVM = null;
        String latestVersion = "";
        PluginManager pm = PluginManager.getInstance();
        for (Toolchain tc : pm.getToolchainList()) {
            String name = tc.getName().toLowerCase();
            String arch = tc.getArchitecture();
            if (!name.startsWith(namePrefix) || !NativeCoreConfigurationManager.isArm64Arch((String)arch)) continue;
            String version = name.substring(namePrefix.length());
            if (latestVersion.isEmpty()) {
                latestVersion = version;
                latestLLVM = tc;
                continue;
            }
            Version ver2 = new Version(version);
            Version ver1 = new Version(latestVersion);
            if (ver2.compareTo(ver1) <= 0) continue;
            latestVersion = version;
            latestLLVM = tc;
        }
        return latestLLVM;
    }

    public static Toolchain getLatestRiscv64Toolchain(String namePrefix, String appType) {
        Toolchain latestLLVM = null;
        String latestVersion = "";
        PluginManager pm = PluginManager.getInstance();
        for (Toolchain tc : pm.getToolchainList()) {
            String name = tc.getName().toLowerCase();
            String arch = tc.getArchitecture();
            if (!name.startsWith(namePrefix) || !NativeCoreConfigurationManager.isRiscV64Arch((String)arch)) continue;
            String version = name.substring(namePrefix.length());
            if (latestVersion.isEmpty()) {
                latestVersion = version;
                latestLLVM = tc;
                continue;
            }
            Version ver2 = new Version(version);
            Version ver1 = new Version(latestVersion);
            if (ver2.compareTo(ver1) <= 0) continue;
            latestVersion = version;
            latestLLVM = tc;
        }
        return latestLLVM;
    }

    public static Toolchain getLatestX86LLVM() {
        return NativeCoreConfigurationManager.getLatestX86Toolchain(LLVM_NAME_PREFIX, TIZEN_APPLICATION_ARTIFACT_TYPE);
    }

    public static Toolchain getLatestX86GCC() {
        return NativeCoreConfigurationManager.getLatestX86Toolchain(GCC_NAME_PREFIX, TIZEN_APPLICATION_ARTIFACT_TYPE);
    }

    public static Toolchain getLatestX86_64GCC() {
        return NativeCoreConfigurationManager.getLatestX86_64Toolchain(GCC_NAME_PREFIX, TIZEN_APPLICATION_ARTIFACT_TYPE);
    }

    public static Toolchain getLatestArmGCC() {
        return NativeCoreConfigurationManager.getLatestArmToolchain(GCC_NAME_PREFIX, TIZEN_APPLICATION_ARTIFACT_TYPE);
    }

    public static Toolchain getLatestArmLLVM() {
        return NativeCoreConfigurationManager.getLatestArmToolchain(LLVM_NAME_PREFIX, TIZEN_APPLICATION_ARTIFACT_TYPE);
    }

    public static Toolchain getLatestArm64_GCC() {
        return NativeCoreConfigurationManager.getLatestArm64Toolchain(GCC_NAME_PREFIX, TIZEN_APPLICATION_ARTIFACT_TYPE);
    }

    public static Toolchain getLatestRiscv64_GCC() {
        return NativeCoreConfigurationManager.getLatestRiscv64Toolchain(GCC_NAME_PREFIX, TIZEN_APPLICATION_ARTIFACT_TYPE);
    }

    public static boolean isLLVMToolchain(IConfiguration config) {
        String toolchainId = "";
        String targetId = NativeCoreConfigurationManager.getBuildTargetName((IConfiguration)config);
        toolchainId = SmartBuildInterface.getInstance().getToolchainIDFromTargetID(targetId);
        return NativeCoreConfigurationManager.isLLVMToolchain(toolchainId);
    }

    public static boolean isLLVMToolchain(IConfiguration config, ITool tool) {
        String toolchainId = "";
        String targetId = NativeCoreConfigurationManager.getBuildTargetName(config, tool);
        if (targetId == null) {
            return false;
        }
        toolchainId = SmartBuildInterface.getInstance().getToolchainIDFromTargetID(targetId);
        return NativeCoreConfigurationManager.isLLVMToolchain(toolchainId);
    }

    public static boolean isLLVMToolchain(String toolchainId) {
        if (toolchainId == null) {
            return false;
        }
        return toolchainId.contains("llvm");
    }

    public static void restoreDefaults(IConfiguration config, Tool tool) throws SBIException {
        ArrayList<String> frameworkList = new ArrayList<String>();
        frameworkList.add("osp");
        frameworkList.add(NATIVE_API_FRAMEWORK);
        NativeCoreConfigurationManager.setDevPackageList(config, tool, frameworkList);
        NativeCoreConfigurationManager.setInitialDebugDefinitionSymbolIfNeeded(config, tool);
        NativeCoreConfigurationManager.appendIncludePathToCompiler(config, tool, DEFAULT_INCLUDE_PATH);
        NativeCoreConfigurationManager.appendLinkPathsToLinker((IConfiguration)config, (String)DEFAULT_LIBRARY_PATH);
    }

    public static String getProjectLibRpathOption(IProject project) {
        IConfiguration config = NativeCoreConfigurationManager.getDefaultConfiguration((IProject)project);
        return NativeCoreConfigurationManager.getProjectLibRpathOption(project, config);
    }

    public static String getToolLibRpathOption(IProject project) {
        IConfiguration config = NativeCoreConfigurationManager.getDefaultConfiguration((IProject)project);
        return NativeCoreConfigurationManager.getToolLibRpathOption(project, config);
    }

    public static String getAppInstPath(IConfiguration config, String appId) {
        return String.format(String.valueOf(TizenPlatformConstants.APP_INSTALL_PATH) + "/%s", appId);
    }

    public static String getToolPath(IConfiguration config) {
        return TizenPlatformConstants.TOOLS_TARGET_PATH;
    }

    public static String getRpathOption(IConfiguration config, String libPath) {
        String targetID = NativeCoreConfigurationManager.getBuildTargetName((IConfiguration)config);
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        String rpathOption = "";
        try {
            String makePath = sbi.getToolPath(targetID, "make");
            rpathOption = OSChecker.isWindows() && makePath.endsWith("/msys2/usr/bin/make.exe") ? (libPath.startsWith("/") ? String.format("-Xlinker -rpath=\"/%s/lib\"", libPath) : String.format("-Xlinker -rpath=\"%s/lib\"", libPath)) : String.format("-Xlinker -rpath=\"%s/lib\"", libPath);
        }
        catch (SBIException e) {
            logger.error("Failed to get rpath options", (Throwable)e);
        }
        return rpathOption;
    }

    public static String getProjectLibRpathOption(IProject project, IConfiguration config) {
        IXMLStore xmlStore = ProjectUtil.getXmlStore((IProject)project);
        if (xmlStore == null) {
            return "";
        }
        String pkgId = xmlStore.getPkgId();
        String appInstPath = NativeCoreConfigurationManager.getAppInstPath(config, pkgId);
        String rpathOption = NativeCoreConfigurationManager.getRpathOption(config, appInstPath);
        return rpathOption;
    }

    public static String getToolLibRpathOption(IProject project, IConfiguration config) {
        String toolPath = NativeCoreConfigurationManager.getToolPath(config);
        String rpathOption = NativeCoreConfigurationManager.getRpathOption(config, toolPath);
        return rpathOption;
    }

    public static void setExportMapFileName(String fileName) {
        exportMapFileName = fileName;
    }

    public static String getExportMapFileName() {
        return exportMapFileName;
    }

    public static List<String> getMergeToolLibraries(IConfiguration config) {
        ITool mergeTool = NativeCoreConfigurationManager.getToolFromToolId((IConfiguration)config, (String)SBI_STATIC_LIB_MERGE_TOOL_ID);
        IOption options = mergeTool.getOptionBySuperClassId(SBI_STATIC_LIB_MERGE_TOOL_LIBS);
        ArrayList<String> valueList = new ArrayList<String>();
        String[] stringArray = NativeCoreConfigurationManager.resolveToStringList((ITool)mergeTool, (IOption)options);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            valueList.add(value.trim());
            ++n2;
        }
        return valueList;
    }

    private static Map<String, String> getDefaultPackagingFileMap(IProject project) {
        if (project == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> fileMap = new HashMap<String, String>();
        fileMap.putAll(NativeCoreConfigurationManagerConstants.PACKAGING_DEFAULT_FILE_LIST);
        if (!NativeCoreConfigurationManager.isMultiProject(project)) {
            fileMap.put("tizen-manifest.xml", "tizen-manifest.xml");
        }
        return fileMap;
    }

    private static Map<String, String> getDefaultPackagingBuildFileMap(IProject project) {
        File artifactFile;
        if (project == null) {
            return Collections.emptyMap();
        }
        IConfiguration config = ProjectUtil.getDefaultConfiguration((IProject)project);
        if (config == null) {
            return Collections.emptyMap();
        }
        String buildDir = config.getName();
        HashMap<String, String> buildFileMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : NativeCoreConfigurationManagerConstants.PACKAGING_DEFAULT_BUILD_FILE_LIST.entrySet()) {
            buildFileMap.put(PathUtil.addPath((String[])new String[]{buildDir, entry.getKey()}), entry.getValue());
        }
        if (NativeCoreConfigurationManager.isMultiProject(project)) {
            for (Map.Entry<String, String> entry : NativeCoreConfigurationManagerConstants.MULTI_PACKAING_DEFAULT_FILE_LIST.entrySet()) {
                String targetPath = PathUtil.addPath((String[])new String[]{project.getLocation().toOSString(), buildDir, entry.getKey()});
                if (!PathUtil.existsFile((String)targetPath)) continue;
                buildFileMap.put(PathUtil.addPath((String[])new String[]{buildDir, entry.getKey()}), entry.getValue());
            }
        }
        if (!ProjectUtil.isApplicationProject((IProject)project)) {
            return buildFileMap;
        }
        String artifactName = ProjectUtil.getBinaryName((IProject)project);
        if (artifactName != null && (artifactFile = new File(project.getLocation().append(buildDir).append(artifactName).toOSString())).exists()) {
            if (ProjectUtil.getTizenProjectType((IProject)project).equals((Object)TizenProjectType.TIZEN_C_IME_APPLICATION)) {
                buildFileMap.put(String.valueOf(PathUtil.addPath((String[])new String[]{buildDir, artifactName})), "lib/" + artifactName);
            } else {
                buildFileMap.put(String.valueOf(PathUtil.addPath((String[])new String[]{buildDir, artifactName})), "bin/" + artifactName);
            }
        }
        return buildFileMap;
    }

    public static Map<String, String> getPackagingFileMap(IProject project) throws CoreException {
        IFolder cFile;
        HashMap<String, String> fileMapToPackaging = new HashMap<String, String>();
        Map<String, String> includeMembers = NativeCoreConfigurationManager.getDefaultPackagingFileMap(project);
        for (String member : includeMembers.keySet()) {
            cFile = project.getFolder(member);
            fileMapToPackaging.putAll(NativeCoreConfigurationManager.getIncludeFileMap((IResource)cFile, (IPath)new Path(includeMembers.get(member))));
        }
        includeMembers = NativeCoreConfigurationManager.getDefaultPackagingBuildFileMap(project);
        for (String member : includeMembers.keySet()) {
            cFile = project.getFolder(member);
            fileMapToPackaging.putAll(NativeCoreConfigurationManager.getIncludeFileMap((IResource)cFile, (IPath)new Path(includeMembers.get(member))));
        }
        NativeCoreConfigurationManager.removeExcludeList(project, fileMapToPackaging);
        return fileMapToPackaging;
    }

    private static Map<String, String> getIncludeFileMap(IResource res, IPath targetDir) throws CoreException {
        HashMap<String, String> includeMap = new HashMap<String, String>();
        IPath resourcePath = res.getLocation();
        if (resourcePath.toFile().isDirectory()) {
            IResource[] members = null;
            if (res instanceof IFolder) {
                members = ((IFolder)res).members();
            } else if (res instanceof IContainer) {
                members = ((IContainer)res).members();
            } else {
                return includeMap;
            }
            if (members == null) {
                return includeMap;
            }
            IResource[] iResourceArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource m = iResourceArray[n2];
                includeMap.putAll(NativeCoreConfigurationManager.getIncludeFileMap(m, targetDir.append(m.getName())));
                ++n2;
            }
        }
        includeMap.put(resourcePath.toOSString(), targetDir.toOSString());
        return includeMap;
    }

    public static boolean isMultiProject(IProject project) {
        return org.tizen.common.util.ProjectUtil.getReferencedProjects((IProject)project).size() > 0;
    }

    public static List<String> getExcludeListFromPathList(IProject project, List<String> pathList) {
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList<String> excludeList = new ArrayList<String>();
        String projectLoc = project.getLocation().toOSString();
        for (String excludeFile : pathList) {
            String excludePath = PathUtil.addPath((String[])new String[]{projectLoc, excludeFile});
            if (!FileUtil.existsPath((String)excludePath)) continue;
            try {
                excludeList.addAll(FileSearch.getFileList((String)excludePath));
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return excludeList;
            }
        }
        return excludeList;
    }

    public static List<String> getEDCFileList(IProject project) {
        ArrayList<String> edcFileList = new ArrayList<String>();
        edcFileList.addAll(NativeCoreConfigurationManager.getEDCFileListFromResource(project));
        edcFileList.addAll(NativeCoreConfigurationManager.getEDCFileListFromShared(project));
        return edcFileList;
    }

    private static List<String> getEDCFileListFromResource(IProject project) {
        ArrayList<String> edcFileList = new ArrayList<String>();
        IPath projectPath = project.getLocation();
        String baseDir = projectPath.append("res").append("edje*").append("*.edc").toOSString();
        try {
            edcFileList.addAll(FileSearch.getFileList((String)baseDir));
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
        if (NativeCoreConfigurationManager.isMultiProject(project)) {
            IConfiguration config = ProjectUtil.getDefaultConfiguration((IProject)project);
            String multiBaseDir = projectPath.append(config.getName()).append(".packaging").append("tempres").append("edje*").append("*.edc").toOSString();
            try {
                edcFileList.addAll(FileSearch.getFileList((String)multiBaseDir));
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return Collections.emptyList();
            }
        }
        return edcFileList;
    }

    private static List<String> getEDCFileListFromShared(IProject project) {
        ArrayList<String> edcFileList = new ArrayList<String>();
        IPath projectPath = project.getLocation();
        String baseDir = projectPath.append("shared").append("res").append("edje*").append("*.edc").toOSString();
        try {
            edcFileList.addAll(FileSearch.getFileList((String)baseDir));
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
        if (NativeCoreConfigurationManager.isMultiProject(project)) {
            IConfiguration config = ProjectUtil.getDefaultConfiguration((IProject)project);
            String multiBaseDir = projectPath.append(config.getName()).append(".packaging").append("tempshared").append("res").append("edje*").append("*.edc").toOSString();
            try {
                edcFileList.addAll(FileSearch.getFileList((String)multiBaseDir));
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return Collections.emptyList();
            }
        }
        return edcFileList;
    }

    public static List<String> getMakeFileList(IProject project) {
        IConfiguration config = ProjectUtil.getDefaultConfiguration((IProject)project);
        String baseDir = project.getLocation().append(config.getName()).toOSString();
        ArrayList<String> mkFileList = new ArrayList<String>();
        for (String mkFileExtension : NativeCoreConfigurationManagerConstants.PACKAGING_DEFAULT_EXCLUDE_MAKE_FILE_LIST) {
            try {
                mkFileList.addAll(FileSearch.getFileListFromExtension((String)baseDir, (String)mkFileExtension));
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return Collections.emptyList();
            }
        }
        return mkFileList;
    }

    public static List<String> getPOFileList(IProject project) {
        IPath projectPath = project.getLocation();
        String baseDir = projectPath.append("res").append("po").append("*.po").toOSString();
        ArrayList<String> poFileList = new ArrayList<String>();
        poFileList.addAll(NativeCoreConfigurationManager.getPOFileListFromResource(project));
        poFileList.addAll(NativeCoreConfigurationManager.getPOFileListFromShared(project));
        try {
            poFileList.addAll(FileSearch.getFileList((String)baseDir));
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
        if (NativeCoreConfigurationManager.isMultiProject(project)) {
            IConfiguration config = ProjectUtil.getDefaultConfiguration((IProject)project);
            String multiBaseDir = projectPath.append(config.getName()).append(".packaging").append("tempres").append("po").append("*.po").toOSString();
            try {
                poFileList.addAll(FileSearch.getFileList((String)multiBaseDir));
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return Collections.emptyList();
            }
        }
        return poFileList;
    }

    public static List<String> getTEPFileList(IProject project) {
        IPath projectPath = project.getLocation();
        String baseDir = projectPath.append("res").append(TizenNativeConstants.TEP_DIR_NAME).toOSString();
        ArrayList<String> tepFileList = new ArrayList<String>();
        try {
            tepFileList.addAll(FileSearch.getFileList((String)baseDir));
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
        tepFileList.add(baseDir);
        return tepFileList;
    }

    private static List<String> getPOFileListFromResource(IProject project) {
        ArrayList<String> poFileList = new ArrayList<String>();
        IPath projectPath = project.getLocation();
        String baseDir = projectPath.append("res").append("po").append("*.po").toOSString();
        try {
            poFileList.addAll(FileSearch.getFileList((String)baseDir));
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
        if (NativeCoreConfigurationManager.isMultiProject(project)) {
            IConfiguration config = ProjectUtil.getDefaultConfiguration((IProject)project);
            String multiBaseDir = projectPath.append(config.getName()).append(".packaging").append("tempres").append("po").append("*.po").toOSString();
            try {
                poFileList.addAll(FileSearch.getFileList((String)multiBaseDir));
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return Collections.emptyList();
            }
        }
        return poFileList;
    }

    private static List<String> getPOFileListFromShared(IProject project) {
        ArrayList<String> poFileList = new ArrayList<String>();
        IPath projectPath = project.getLocation();
        String baseDir = projectPath.append("shared").append("res").append("po").append("*.po").toOSString();
        try {
            poFileList.addAll(FileSearch.getFileList((String)baseDir));
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
        if (NativeCoreConfigurationManager.isMultiProject(project)) {
            IConfiguration config = ProjectUtil.getDefaultConfiguration((IProject)project);
            String multiBaseDir = projectPath.append(config.getName()).append(".packaging").append("tempshared").append("res").append("po").append("*.po").toOSString();
            try {
                poFileList.addAll(FileSearch.getFileList((String)multiBaseDir));
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return Collections.emptyList();
            }
        }
        return poFileList;
    }

    private static void removeExcludeList(IProject project, Map<String, String> includeMap) {
        if (project == null || includeMap == null) {
            return;
        }
        NativeCoreConfigurationManager.removeExcludeDefaultFileList(project, includeMap);
        NativeCoreConfigurationManager.removeExcludeMakeFileList(project, includeMap);
        NativeCoreConfigurationManager.removeExcludeEDCFileList(project, includeMap);
        NativeCoreConfigurationManager.removeExcludePOFileList(project, includeMap);
        NativeCoreConfigurationManager.removeTEPFileList(project, includeMap);
    }

    private static void removeExcludeList(Map<String, String> includeMap, List<String> removeList) {
        for (String rmFilePath : removeList) {
            includeMap.remove(rmFilePath);
        }
    }

    private static void removeExcludeEDCFileList(IProject project, Map<String, String> includeMap) {
        for (String excludeFile : NativeCoreConfigurationManager.getEDCFileList(project)) {
            includeMap.remove(excludeFile);
        }
        try {
            for (String edjeDir : NativeCoreConfigurationManager.getEdjeDirList(project)) {
                NativeCoreConfigurationManager.removeEmptyDir(includeMap, edjeDir);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return;
        }
    }

    private static void removeEmptyDir(Map<String, String> includeMap, String dirPath) {
        ArrayList<String> remainingPath = new ArrayList<String>();
        for (String key : includeMap.keySet()) {
            if (!key.startsWith(dirPath)) continue;
            remainingPath.add(key);
        }
        if (remainingPath.size() == 1 && ((String)remainingPath.get(0)).equals(dirPath)) {
            includeMap.remove(dirPath);
        }
    }

    private static List<String> getEdjeDirList(IProject project) throws IOException {
        File buildSharedResDirFile;
        int n;
        IConfiguration config;
        File sharedResDirFile;
        int n2;
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList<String> retDirList = new ArrayList<String>();
        File resDirFile = project.getLocation().append("res").toFile();
        File[] cFiles = resDirFile.listFiles();
        if (cFiles != null) {
            File[] fileArray = cFiles;
            n2 = cFiles.length;
            int n3 = 0;
            while (n3 < n2) {
                File cFile = fileArray[n3];
                if (cFile.exists() && cFile.isDirectory() && cFile.getName().startsWith("edje")) {
                    retDirList.add(cFile.getCanonicalPath());
                }
                ++n3;
            }
        }
        if ((cFiles = (sharedResDirFile = project.getLocation().append("shared").append("res").toFile()).listFiles()) != null) {
            File[] fileArray = cFiles;
            int n4 = cFiles.length;
            n2 = 0;
            while (n2 < n4) {
                File cFile = fileArray[n2];
                if (cFile.exists() && cFile.isDirectory() && cFile.getName().startsWith("edje")) {
                    retDirList.add(cFile.getCanonicalPath());
                }
                ++n2;
            }
        }
        if ((config = ProjectUtil.getDefaultConfiguration((IProject)project)) == null) {
            return retDirList;
        }
        File buildResDirFile = project.getLocation().append(config.getName()).append("res").toFile();
        cFiles = buildResDirFile.listFiles();
        if (cFiles != null) {
            File[] fileArray = cFiles;
            n = cFiles.length;
            int n5 = 0;
            while (n5 < n) {
                File cFile = fileArray[n5];
                if (cFile.exists() && cFile.isDirectory() && cFile.getName().startsWith("edje")) {
                    retDirList.add(cFile.getCanonicalPath());
                }
                ++n5;
            }
        }
        if ((cFiles = (buildSharedResDirFile = project.getLocation().append(config.getName()).append("shared").append("res").toFile()).listFiles()) != null) {
            File[] fileArray = cFiles;
            int n6 = cFiles.length;
            n = 0;
            while (n < n6) {
                File cFile = fileArray[n];
                if (cFile.exists() && cFile.isDirectory() && cFile.getName().startsWith("edje")) {
                    retDirList.add(cFile.getCanonicalPath());
                }
                ++n;
            }
        }
        return retDirList;
    }

    private static List<String> getPODirList(IProject project) throws IOException {
        File buildSharedResDirFile;
        int n;
        IConfiguration config;
        File sharedResDirFile;
        int n2;
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList<String> retDirList = new ArrayList<String>();
        File resDirFile = project.getLocation().append("res").toFile();
        File[] cFiles = resDirFile.listFiles();
        if (cFiles != null) {
            File[] fileArray = cFiles;
            n2 = cFiles.length;
            int n3 = 0;
            while (n3 < n2) {
                File cFile = fileArray[n3];
                if (cFile.exists() && cFile.isDirectory() && cFile.getName().startsWith("po")) {
                    retDirList.add(cFile.getCanonicalPath());
                }
                ++n3;
            }
        }
        if ((cFiles = (sharedResDirFile = project.getLocation().append("shared").append("res").toFile()).listFiles()) != null) {
            File[] fileArray = cFiles;
            int n4 = cFiles.length;
            n2 = 0;
            while (n2 < n4) {
                File cFile = fileArray[n2];
                if (cFile.exists() && cFile.isDirectory() && cFile.getName().startsWith("po")) {
                    retDirList.add(cFile.getCanonicalPath());
                }
                ++n2;
            }
        }
        if ((config = ProjectUtil.getDefaultConfiguration((IProject)project)) == null) {
            return retDirList;
        }
        File buildResDirFile = project.getLocation().append(config.getName()).append("res").toFile();
        cFiles = buildResDirFile.listFiles();
        if (cFiles != null) {
            File[] fileArray = cFiles;
            n = cFiles.length;
            int n5 = 0;
            while (n5 < n) {
                File cFile = fileArray[n5];
                if (cFile.exists() && cFile.isDirectory() && cFile.getName().startsWith("po")) {
                    retDirList.add(cFile.getCanonicalPath());
                }
                ++n5;
            }
        }
        if ((cFiles = (buildSharedResDirFile = project.getLocation().append(config.getName()).append("shared").append("res").toFile()).listFiles()) != null) {
            File[] fileArray = cFiles;
            int n6 = cFiles.length;
            n = 0;
            while (n < n6) {
                File cFile = fileArray[n];
                if (cFile.exists() && cFile.isDirectory() && cFile.getName().startsWith("po")) {
                    retDirList.add(cFile.getCanonicalPath());
                }
                ++n;
            }
        }
        return retDirList;
    }

    private static void removeTEPFileList(IProject project, Map<String, String> includeMap) {
        for (String tepFileList : NativeCoreConfigurationManager.getTEPFileList(project)) {
            includeMap.remove(tepFileList);
        }
    }

    private static void removeExcludePOFileList(IProject project, Map<String, String> includeMap) {
        for (String excludeFile : NativeCoreConfigurationManager.getPOFileList(project)) {
            includeMap.remove(excludeFile);
        }
        try {
            for (String poDir : NativeCoreConfigurationManager.getPODirList(project)) {
                NativeCoreConfigurationManager.removeEmptyDir(includeMap, poDir);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return;
        }
    }

    private static void removeExcludeMakeFileList(IProject project, Map<String, String> includeMap) {
        NativeCoreConfigurationManager.removeExcludeList(includeMap, NativeCoreConfigurationManager.getMakeFileList(project));
    }

    private static void removeExcludeDefaultFileList(IProject project, Map<String, String> includeMap) {
        NativeCoreConfigurationManager.removeExcludeList(includeMap, NativeCoreConfigurationManager.getExcludeListFromPathList(project, NativeCoreConfigurationManagerConstants.PACKAGING_DEFAULT_EXCLUDE_LIST));
    }

    public static boolean checkBuildInfo(IProject project) throws CoreException {
        String toolchainId;
        String targetId = NativeCoreConfigurationManager.getTargetIdFromProject(project);
        if (targetId == null || targetId.isEmpty()) {
            String errMsg = String.format("Cannot find build information", new Object[0]);
            Status status = new Status(4, "org.tizen.common", errMsg);
            throw new CoreException((IStatus)status);
        }
        PluginManager pm = PluginManager.getInstance();
        if (!pm.isAvailableToolchainId(toolchainId = pm.getToolchainIDFromTargetID(targetId))) {
            String errMsg = String.format("Cannot find toolchain(%s)", toolchainId);
            Status status = new Status(4, "org.tizen.common", errMsg);
            throw new CoreException((IStatus)status);
        }
        String rootstrapId = pm.getRootstrapIDFromTargetID(targetId);
        if (!pm.isAvailableRootstrapId(rootstrapId)) {
            IConfiguration config = ProjectUtil.getDefaultConfiguration((IProject)project);
            String errMsg = String.format("Cannot find platform(%s)", NativeCoreConfigurationManager.getPlatformName((IConfiguration)config));
            Status status = new Status(4, "org.tizen.common", errMsg);
            throw new CoreException((IStatus)status);
        }
        return true;
    }
}

