/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.wizards;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cdt.managedbuilder.ui.wizards.ManagedBuildWizard;
import org.eclipse.cdt.ui.wizards.CNewWizard;
import org.eclipse.cdt.ui.wizards.EntryDescriptor;
import org.eclipse.cdt.ui.wizards.IWizardItemsListListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ui.wizards.TizenCommonNewWizardPage;
import org.tizen.common.ui.wizards.TizenWizardProjectCheckViewer;
import org.tizen.common.util.StringUtil;
import org.tizen.common.util.WorkspaceUtil;
import org.tizen.nativeappcommon.wizards.TizenMainWizardPage;
import org.tizen.nativeappcommon.wizards.WizardConstants;
import org.tizen.nativeappcommon.wizards.model.TizenNativeTemplateModel;
import org.tizen.nativecore.util.PackageUtil;
import org.tizen.nativecore.wizards.Messages;
import org.tizen.nativecore.wizards.TemplateTizenCoreNewWizard;
import org.tizen.nativecore.wizards.TizenCoreConfigPage;

public class TizenCoreMainWizardPage
extends TizenMainWizardPage {
    private final Logger logger = LoggerFactory.getLogger(TizenCoreMainWizardPage.class);
    private TizenCoreConfigPage configPage;
    private static final HashSet<String> NONE_PCH_SAMPLE = new HashSet();
    private static final String NAME_PATTERN = "^[a-zA-Z][a-zA-Z0-9-\\._]{2,49}(?<![\\._\\-])$";

    static {
        NONE_PCH_SAMPLE.add("NPPlugin Shared Library");
        NONE_PCH_SAMPLE.add("Static Library");
    }

    public TizenCoreMainWizardPage() {
        this("");
    }

    public TizenCoreMainWizardPage(String pageName) {
        super(pageName);
        this.setNewProjectChecker(new TizenWizardProjectCheckViewer((TizenCommonNewWizardPage)this, this.getErrorReporter()));
    }

    public TizenCoreMainWizardPage(String pageName, String appType) {
        super(pageName, appType);
        this.setNewProjectChecker(new TizenWizardProjectCheckViewer((TizenCommonNewWizardPage)this, this.getErrorReporter()));
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.createWorkingSetGroup(this.fComposite, null, WorkspaceUtil.getIdsOfWorkingSetDescriptors());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.tizen.ide.native.project_wizard_context");
    }

    protected List<EntryDescriptor> updateData(Composite right, IWizardItemsListListener ls, IWizard wizard) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.ui.CDTWizard");
        if (extensionPoint == null) {
            return null;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions == null) {
            return null;
        }
        List<Object> items = new ArrayList<EntryDescriptor>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = extensions[i].getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getName().equals("wizard")) {
                    int n3;
                    CNewWizard w = null;
                    try {
                        w = (CNewWizard)element.createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        this.logger.error(org.tizen.nativeappcommon.wizards.Messages.EXCEPTION_WHILE_PROJECT_CREATION_2, (Throwable)e);
                    }
                    if (w == null) {
                        return null;
                    }
                    if (w instanceof ManagedBuildWizard) {
                        w.setDependentControl(right, ls);
                        EntryDescriptor[] entryDescriptorArray = w.createItems(true, wizard);
                        n3 = entryDescriptorArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            EntryDescriptor ed = entryDescriptorArray[n4];
                            items.add(ed);
                            ++n4;
                        }
                    } else if (w instanceof TemplateTizenCoreNewWizard) {
                        EntryDescriptor[] eds;
                        w.setDependentControl(right, ls);
                        EntryDescriptor[] entryDescriptorArray = eds = ((TemplateTizenCoreNewWizard)w).createItems(true, wizard);
                        int n5 = eds.length;
                        n3 = 0;
                        while (n3 < n5) {
                            EntryDescriptor ed = entryDescriptorArray[n3];
                            items.add(ed);
                            ++n3;
                        }
                    }
                }
                ++n2;
            }
            ++i;
        }
        i = 0;
        while (i < items.size()) {
            EntryDescriptor ed = (EntryDescriptor)items.get(i);
            if (ed.isDefaultForCategory()) {
                items.remove(i);
                --i;
            }
            ++i;
        }
        if (ls != null) {
            items = ls.filterItems(items);
        }
        return items;
    }

    protected IPath getTemplatePath() {
        return TemplateTizenCoreNewWizard.templatePath;
    }

    protected String getPathOfTemplate() {
        return "core";
    }

    public TizenWizardProjectCheckViewer.IErrorMessageReporter getErrorReporter() {
        return new TizenWizardProjectCheckViewer.IErrorMessageReporter(){

            public void reportError(String errorMessage, boolean infoOnly) {
                boolean valid;
                if (infoOnly) {
                    TizenCoreMainWizardPage.this.setMessage(errorMessage, 1);
                    TizenCoreMainWizardPage.this.setErrorMessage(null);
                } else {
                    TizenCoreMainWizardPage.this.setErrorMessage(errorMessage);
                }
                boolean bl = valid = errorMessage == null;
                if (valid) {
                    valid = TizenCoreMainWizardPage.this.validatePage();
                }
                TizenCoreMainWizardPage.this.setPageComplete(valid);
            }
        };
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public boolean hasPrecompiledHedaer() {
        if (this.configPage == null || this.configPage.preCompileButton == null) {
            return false;
        }
        return this.configPage.preCompileButton.getSelection();
    }

    public String getProjectName() {
        return this.projectCheckViewer.getProjectName();
    }

    public boolean validatePage() {
        if (!this.projectCheckViewer.validatePage()) {
            return false;
        }
        String msg = this.validatePackageName();
        if (!"".equals(msg)) {
            this.setErrorMessage(msg);
            return false;
        }
        String projectName = this.getProjectName();
        String errMsg = this.validateProjectName(projectName);
        if (!StringUtil.isEmpty((CharSequence)errMsg)) {
            this.setErrorMessage(errMsg);
            return false;
        }
        if (super.validatePage()) {
            TizenNativeTemplateModel selectedTemplate = this.getSelectedTemplate();
            String sampleName = selectedTemplate.getName();
            String category = selectedTemplate.getParentCategory().getName();
            if (PackageUtil.validateProjectName(category, projectName)) {
                return true;
            }
            this.setErrorMessage(NLS.bind((String)Messages.TizenCppMainWizardPage_KEYWORD_BLOCK_ERROR, (Object)projectName, (Object)sampleName));
        }
        return false;
    }

    protected String validateProjectName(String projName) {
        return TizenCoreMainWizardPage.validateProjectName(projName, ResourcesPlugin.getWorkspace());
    }

    public static String validateProjectName(String projName, IWorkspace workspace) {
        if (WizardConstants.CPP_KEYWORDS.contains(projName)) {
            return NLS.bind((String)org.tizen.nativeappcommon.wizards.Messages.TizenMainWizardPage_isCppKeyword, (Object)projName);
        }
        if (projName.length() > 50) {
            return NLS.bind((String)org.tizen.nativeappcommon.wizards.Messages.WizardConstants_6, (Object)51);
        }
        if (projName.length() < 3) {
            return NLS.bind((String)org.tizen.nativeappcommon.wizards.Messages.WizardConstants_5, (Object)2);
        }
        if (!projName.matches(NAME_PATTERN)) {
            return org.tizen.nativeappcommon.wizards.Messages.WizardConstants_2;
        }
        if (projName.indexOf(35) >= 0) {
            return org.tizen.nativeappcommon.wizards.Messages.TizenMainWizardPage_3;
        }
        return "";
    }

    private String validatePackageName() {
        String pkgName = this.getPkgName();
        if (pkgName.length() > 50) {
            return NLS.bind((String)Messages.WIZARD_PACKAGE_SHORTER_ERROR, (Object)51);
        }
        if (pkgName.length() < 3) {
            return NLS.bind((String)Messages.WIZARD_PACKAGE_LONGER_ERROR, (Object)2);
        }
        if (!pkgName.matches(NAME_PATTERN)) {
            return Messages.WIZARD_PACKAGE_INVALID_ERROR;
        }
        if (pkgName.indexOf(35) >= 0) {
            return Messages.WIZARD_PACKAGE_INVALID_CHAR_ERROR;
        }
        return "";
    }

    public String getPkgName() {
        return this.getNewProjectChecker().getPkgName();
    }
}

