/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.wizards.project;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.templateengine.TemplateDescriptor;
import org.eclipse.cdt.ui.wizards.CWizardHandler;
import org.eclipse.cdt.ui.wizards.EntryDescriptor;
import org.eclipse.cdt.ui.wizards.IWizardItemsListListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ui.wizards.TizenWizardThread;
import org.tizen.common.ui.wizards.project.template.pages.ProjectPropertyPage;
import org.tizen.nativeappcommon.templateengine.TizenTemplateProcessParser;
import org.tizen.nativeappcommon.wizards.Messages;
import org.tizen.nativeappcommon.wizards.TemplateTizenNewWizard;
import org.tizen.nativeappcommon.wizards.TizenManagedBuildWizard;
import org.tizen.nativeappcommon.wizards.model.TizenNativeTemplateModel;

public class TizenNativeCDTCreateItems
implements IWizardItemsListListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Composite toolchainComposite;
    private List<EntryDescriptor> managedBuildWizardItems = new ArrayList<EntryDescriptor>();
    private ProjectPropertyPage wizardPage;

    public TizenNativeCDTCreateItems(ProjectPropertyPage wizardPage) {
        this.wizardPage = wizardPage;
    }

    public void initManagedBuildWizardItems(IWizard wizard) {
        this.toolchainComposite = new Composite(this.wizardPage.getfComposite(), 0);
        if (this.managedBuildWizardItems == null || this.managedBuildWizardItems.size() < 1) {
            this.managedBuildWizardItems = this.createManagedBuildWizardItems(this.toolchainComposite, this, wizard);
            if (this.managedBuildWizardItems == null) {
                new TizenWizardThread().wizardErrorDialog(Messages.TizenMainWizardPage_7);
                return;
            }
        }
    }

    private List<EntryDescriptor> createManagedBuildWizardItems(Composite right, IWizardItemsListListener ls, IWizard wizard) {
        ArrayList<EntryDescriptor> items = new ArrayList<EntryDescriptor>();
        TizenManagedBuildWizard tizenManagedBuildWizard = new TizenManagedBuildWizard();
        tizenManagedBuildWizard.setDependentControl(right, ls);
        EntryDescriptor[] entryDescriptorArray = tizenManagedBuildWizard.createItems(true, wizard);
        int n = entryDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntryDescriptor ed = entryDescriptorArray[n2];
            items.add(ed);
            ++n2;
        }
        int i = 0;
        while (i < items.size()) {
            EntryDescriptor ed = (EntryDescriptor)items.get(i);
            if (ed.isDefaultForCategory()) {
                items.remove(i);
                --i;
            }
            ++i;
        }
        if (ls != null) {
            items = ls.filterItems(items);
        }
        if (items == null || items.size() < 1) {
            return null;
        }
        return items;
    }

    public void createEntryDescriptor(TizenNativeTemplateModel template) {
        EntryDescriptor entryDes = null;
        TemplateTizenNewWizard templateTienCoreNewWizard = new TemplateTizenNewWizard();
        if (template.getProjectType() == null) {
            TemplateDescriptor templateDesc = TizenTemplateProcessParser.createTemplateDesc((File)new File(template.getSamplePath()));
            if (templateDesc == null) {
                this.logger.error(Messages.EXCEPTION_WHILE_PROJECT_CREATION_1);
                return;
            }
            entryDes = templateTienCoreNewWizard.getEntryDesc(templateDesc, template.getName());
        } else {
            entryDes = templateTienCoreNewWizard.getEntryDesc(template.getProjectType(), template.getName());
        }
        if (entryDes == null) {
            this.logger.error(Messages.EXCEPTION_WHILE_PROJECT_CREATION_2);
            return;
        }
        boolean found2 = false;
        if (entryDes.getParentId() != null) {
            boolean found1 = false;
            for (EntryDescriptor ed2 : this.managedBuildWizardItems) {
                if (!ed2.getId().equals(entryDes.getParentId())) continue;
                found2 = true;
                found1 = true;
                entryDes.setParentId(null);
                entryDes.setPath(String.valueOf(ed2.getId()) + "/" + entryDes.getId());
                entryDes.setParent(ed2);
                if (ed2.getHandler() == null || !ed2.getHandler().isApplicable(entryDes)) break;
                entryDes.setHandler(ed2.getHandler());
                break;
            }
            if (!found1) {
                this.logger.error(Messages.EXCEPTION_WHILE_PROJECT_CREATION_2);
                return;
            }
            template.setEntryDescriptor(entryDes);
            template.setSpecXmlPath((IPath)new Path(template.getTemplateDescMetaInfo().getDefUrl()));
        }
        if (!found2) {
            this.logger.error(Messages.EXCEPTION_WHILE_PROJECT_CREATION_1);
            return;
        }
    }

    public CWizardHandler createCWizardHandler(CWizardHandler h, EntryDescriptor ed) {
        CWizardHandler h_selected = null;
        if (h == null) {
            h = ed.getHandler();
        }
        if (ed.isCategory()) {
            h = null;
        }
        try {
            if (h != null) {
                h.initialize(ed);
            }
        }
        catch (CoreException coreException) {
            h = null;
        }
        h_selected = h;
        if (h == null) {
            return h_selected;
        }
        h_selected.handleSelection();
        h_selected.saveState();
        h_selected.setSupportedOnly(true);
        h_selected.saveState();
        return h_selected;
    }

    public List filterItems(List items) {
        return items;
    }

    public boolean isCurrent() {
        return this.wizardPage.isCurrent();
    }

    public void toolChainListChanged(int arg0) {
        this.wizardPage.getWizard().getContainer().updateButtons();
    }
}

