/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.build.makefile;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecore.build.NativeCoreConfigurationManager;
import org.tizen.sbilib.ide.PluginManager;
import org.tizen.sbilib.ide.Rootstrap;
import org.tizen.sbilib.ide.Toolchain;

public class NativeMakeFileManipulator {
    public static String replaceToolEnvs(ITool tool, String buildCmd) {
        if (tool == null) {
            return buildCmd;
        }
        String command = tool.getToolCommand();
        String toolName = tool.getName();
        String result = "";
        if (toolName.equals("Archiver")) {
            result = buildCmd.replace(command, "$(AR)");
        } else if (toolName.contains("C Compiler")) {
            result = buildCmd.replace(command, "$(CC)");
        } else if (toolName.contains("C++ Compiler")) {
            result = buildCmd.replace(command, "$(CXX)");
        } else if (toolName.contains("Linker")) {
            result = buildCmd.replace(command, "$(CXX)");
        } else {
            return buildCmd;
        }
        return result;
    }

    public static String replaceBuildEnvs(IProject project, IConfiguration config, String source, String targetId, boolean expand) {
        String projectPath = NativeMakeFileManipulator.getPathForResource((IResource)project).toOSString();
        String sdkPath = InstallPathConfig.getSDKPath();
        String appId = ProjectUtil.getAppId((IProject)project);
        PluginManager pm = PluginManager.getInstance();
        Rootstrap rs = pm.getRootstrapByTargetId(targetId);
        String rs_compiler_misc = null;
        String rs_linker_misc = null;
        if (rs != null) {
            rs_compiler_misc = rs.getCompilerMiscellaneousOption();
            rs_linker_misc = rs.getLinkerMiscellaneousOption();
        }
        Toolchain tc = pm.getToolchainByTargetId(targetId);
        String tc_compiler_misc = null;
        String tc_linker_misc = null;
        if (tc != null) {
            tc_compiler_misc = tc.getCompilerMiscellaneousOption();
            tc_linker_misc = tc.getLinkerMiscellaneousOption();
        }
        source = source.replaceAll("\\{", "\\(").replaceAll("\\}", "\\)");
        if (rs != null) {
            String rsPath = rs.getPath();
            if (System.getProperty("os.name").startsWith("Windows")) {
                rsPath = rsPath.replace("\\", "/");
            }
            File rsFile = new File(rsPath);
            String rsCanonicalPath = null;
            try {
                rsCanonicalPath = rsFile.getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (rsPath != null && !rsPath.isEmpty()) {
                source = expand ? source.replace("$(SBI_SYSROOT)", rsPath) : source.replace(rsPath, "$(SBI_SYSROOT)");
            }
            if (rsCanonicalPath != null && !rsCanonicalPath.isEmpty()) {
                source = expand ? source.replace("$(SBI_SYSROOT)", rsCanonicalPath) : source.replace(rsCanonicalPath, "$(SBI_SYSROOT)");
            }
        }
        if (tc_compiler_misc != null && !tc_compiler_misc.isEmpty()) {
            source = expand ? source.replace("$(TC_COMPILER_MISC)", tc_compiler_misc) : source.replace(tc_compiler_misc, "$(TC_COMPILER_MISC)");
        }
        if (tc_linker_misc != null && !tc_linker_misc.isEmpty()) {
            source = expand ? source.replace("$(TC_LINKER_MISC)", tc_linker_misc) : source.replace(tc_linker_misc, "$(TC_LINKER_MISC)");
        }
        if (rs_compiler_misc != null && !rs_compiler_misc.isEmpty()) {
            source = expand ? source.replace("$(RS_COMPILER_MISC)", rs_compiler_misc) : source.replace(rs_compiler_misc, "$(RS_COMPILER_MISC)");
        }
        if (rs_linker_misc != null && !rs_linker_misc.isEmpty()) {
            source = expand ? source.replace("$(RS_LINKER_MISC)", rs_linker_misc) : source.replace(rs_linker_misc, "$(RS_LINKER_MISC)");
        }
        if (expand) {
            source = source.replace("$(PROJ_PATH)", projectPath);
            source = source.replace("$(SDK_PATH)", sdkPath);
            if (appId != null && !appId.isEmpty()) {
                source = source.replace("$(APPID)", appId);
            }
        } else {
            source = source.replace(projectPath, "$(PROJ_PATH)");
            source = source.replace(sdkPath, "$(SDK_PATH)");
            if (appId != null && !appId.isEmpty()) {
                source = source.replace(appId, "$(APPID)");
            }
        }
        return source;
    }

    public static void replaceBuildEnvExpressionToMakeFile(IConfiguration config) {
        ArrayList<String> cflags = NativeCoreConfigurationManager.getFrameworkCflags(config);
        ArrayList<String> newCflags = new ArrayList<String>();
        for (String flag : cflags) {
            String f = flag.replace('{', '(');
            f = f.replace('}', ')');
            newCflags.add(f);
        }
        NativeCoreConfigurationManager.setFrameworkCflags(config, newCflags);
        ArrayList<String> lflags = NativeCoreConfigurationManager.getFrameworkLflags(config);
        ArrayList<String> newLflags = new ArrayList<String>();
        for (String flag : lflags) {
            String f = flag.replace('{', '(');
            f = f.replace('}', ')');
            newLflags.add(f);
        }
        NativeCoreConfigurationManager.setFrameworkLflags(config, newLflags);
    }

    public static void replaceBuildEnvExpressionToBuild(IConfiguration config) {
        ArrayList<String> cflags = NativeCoreConfigurationManager.getFrameworkCflags(config);
        ArrayList<String> newCflags = new ArrayList<String>();
        for (String flag : cflags) {
            String f = flag.replace('(', '{');
            f = f.replace(')', '}');
            newCflags.add(f);
        }
        NativeCoreConfigurationManager.setFrameworkCflags(config, newCflags);
        ArrayList<String> lflags = NativeCoreConfigurationManager.getFrameworkLflags(config);
        ArrayList<String> newLflags = new ArrayList<String>();
        for (String flag : lflags) {
            String f = flag.replace('(', '{');
            f = f.replace(')', '}');
            newLflags.add(f);
        }
        NativeCoreConfigurationManager.setFrameworkLflags(config, newLflags);
    }

    public static String replaceBuildEnvs(IProject project, IConfiguration config, String source) {
        String targetId = NativeCoreConfigurationManager.getBuildTargetName((IConfiguration)config);
        return NativeMakeFileManipulator.replaceBuildEnvs(project, config, source, targetId, false);
    }

    public static String expandBuildEnvs(IProject project, IConfiguration config, String source) {
        String targetId = NativeCoreConfigurationManager.getBuildTargetName((IConfiguration)config);
        return NativeMakeFileManipulator.replaceBuildEnvs(project, config, source, targetId, true);
    }

    private static IPath getPathForResource(IResource resource) {
        return new Path(resource.getLocationURI().getPath());
    }
}

