/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor.dlg;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.tizen.nativecore.ext.manifest.Metadata;

public class UiNewMetaDataDialog
extends SelectionStatusDialog {
    Metadata fMetaData;
    List<Metadata> fExistingMeta;
    private Label fLabelKey;
    private Label fLabelValue;
    private Text fKeyText;
    private Text fValueText;

    public UiNewMetaDataDialog(Shell parentShell, List<Metadata> metas, Metadata editTarget) {
        super(parentShell);
        this.setStatusLineAboveButtons(true);
        this.setHelpAvailable(false);
        if (editTarget == null) {
            this.setTitle("Add Meta Data");
            this.fExistingMeta = metas;
        } else {
            this.setTitle("Edit Meta Data");
            this.fExistingMeta = new ArrayList<Metadata>(metas.size());
            for (Metadata m : metas) {
                if (editTarget.equals(m)) continue;
                this.fExistingMeta.add(m);
            }
            this.fMetaData = editTarget;
        }
    }

    public Metadata getMetaData() {
        return this.fMetaData;
    }

    protected Control createDialogArea(Composite parent) {
        Composite grid = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginTop = 20;
        layout.marginBottom = 9;
        layout.marginLeft = 20;
        layout.marginRight = 20;
        layout.verticalSpacing = 10;
        grid.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.widthHint = 510;
        grid.setLayoutData((Object)gd);
        UiNewMetaDataDialog.applyDialogFont((Control)grid);
        this.fLabelKey = new Label(grid, 1024);
        this.fLabelKey.setText("Key");
        GridData lgd = new GridData(16384, 0x1000000, false, false, 1, 1);
        lgd.widthHint = 115;
        this.fLabelKey.setLayoutData((Object)lgd);
        this.fKeyText = new Text(grid, 2048);
        this.fKeyText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.fLabelValue = new Label(grid, 0);
        this.fLabelValue.setLayoutData((Object)lgd);
        this.fLabelValue.setText("Value");
        this.fValueText = new Text(grid, 2048);
        this.fValueText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.fMetaData != null) {
            this.fKeyText.setText(this.fMetaData.getKey());
            this.fValueText.setText(this.fMetaData.getValue());
        }
        this.fKeyText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UiNewMetaDataDialog.this.validate();
            }
        });
        this.fValueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UiNewMetaDataDialog.this.validate();
            }
        });
        this.validate();
        return grid;
    }

    private void validate() {
        this.computeResult();
        Status status = null;
        if (this.fMetaData.getKey().length() <= 0) {
            status = new Status(4, "org.tizen.nativecore.misc", "Enter a Key");
            this.updateStatus((IStatus)status);
            return;
        }
        for (Metadata m : this.fExistingMeta) {
            if (!m.getKey().equals(this.fMetaData.getKey())) continue;
            status = new Status(4, "org.tizen.nativecore.misc", "Already existing key");
            this.updateStatus((IStatus)status);
            return;
        }
        status = new Status(0, "org.tizen.nativecore.misc", null);
        this.updateStatus((IStatus)status);
    }

    protected void computeResult() {
        if (this.fMetaData == null) {
            this.fMetaData = new Metadata();
        }
        this.fMetaData.setKey(this.fKeyText.getText().trim());
        this.fMetaData.setValue(this.fValueText.getText().trim());
    }
}

