/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor.dlg;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.tizen.nativecore.ext.manifest.AppControl;

public class UiNewAppControlItemDlg
extends SelectionStatusDialog {
    private static final String[] PRESET_OPERATIONS = new String[]{"http://tizen.org/appcontrol/operation/main", "http://tizen.org/appcontrol/operation/default", "http://tizen.org/appcontrol/operation/edit", "http://tizen.org/appcontrol/operation/view", "http://tizen.org/appcontrol/operation/pick", "http://tizen.org/appcontrol/operation/create_content", "http://tizen.org/appcontrol/operation/call", "http://tizen.org/appcontrol/operation/send", "http://tizen.org/appcontrol/operation/send_text", "http://tizen.org/appcontrol/operation/share", "http://tizen.org/appcontrol/operation/multi_share", "http://tizen.org/appcontrol/operation/share_text", "http://tizen.org/appcontrol/operation/dial", "http://tizen.org/appcontrol/operation/search", "http://tizen.org/appcontrol/operation/download", "http://tizen.org/appcontrol/operation/print", "http://tizen.org/appcontrol/operation/compose"};
    private static final String[] PRESET_MIMETYPES = new String[]{"application/xhtml+xml", "application/smil", "application/msword (application/vnd.ms-word)", "application/pdf", "application/sdp", "application/ram", "application/rss+xml", "application/rdf+xml", "application/atom+xml", "application/vnd.rn-realmedia", "application/vnd.ms-excel (application/x-msexcel)", "application/vnd.ms-powerpoint (application/x-mspowerpoint)", "application/x-smaf (application/vnd.smaf)", "application/x-shockwave-flash", "application/x-java-archive", "application/x-pkcs12", "application/x-x509-ca-cert", "application/xml (text/xml)", "audio/basic", "audio/mpeg (audio/mp3, audio/x-mpeg, audio/x-mp3)", "audio/AMR (audio/amr)", "audio/AMR-WB (audio/amr-wb)", "audio/midi(audio/x-midi)", "audio/3gpp", "audio/mp4", "audio/vnd.rn-realaudio (audio/x-pn-realaudio)", "audio/x-wav (audio/wav)", "audio/x-ms-wma (audio/wma)", "audio/x-xmf (audio/xmf, audio/mobile-xmf)", "image/gif", "image/jpeg (image/pjpeg)", "image/tiff", "image/png", "image/bmp (image/x-bmp)", "image/svg+xml", "image/vnd.wap.wbmp", "message/rfc822", "text/html", "text/plain", "text/vnd.wap.wml", "text/vnd.sun.j2me.app-descriptor", "text/calendar (text/x-vcalendar)", "text/vcard (text/x-vcard)", "text/x-iMelody (audio/iMelody, audio/x-iMelody)", "text/x-vnote", "video/mp4", "video/3gpp", "video/x-msvideo (video/avi)", "video/mp4 (video/mp4v-es)", "video/mpeg", "video/vnd.rn-realvideo", "video/x-ms-wmv", "video/x-ms-asf"};
    Combo fOperationCombo;
    Combo fMimeCombo;
    Text fUriText;
    private AppControl.AppControlItem fItem = new AppControl().new AppControl.AppControlItem();
    private AppControl fRefAppControl;

    public UiNewAppControlItemDlg(Shell parentShell, AppControl appControl) {
        super(parentShell);
        this.setTitle("Add Application Service");
        this.fRefAppControl = appControl;
        this.setStatusLineAboveButtons(true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData());
        UiNewAppControlItemDlg.applyDialogFont((Control)composite);
        Button radio = new Button(composite, 16);
        radio.setText(AppControl.CATEGORIES.operation.toString());
        radio.setSelection(true);
        radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UiNewAppControlItemDlg.this.fOperationCombo.setEnabled(true);
                UiNewAppControlItemDlg.this.fOperationCombo.setFocus();
                UiNewAppControlItemDlg.this.fMimeCombo.setEnabled(false);
                UiNewAppControlItemDlg.this.fUriText.setEnabled(false);
                UiNewAppControlItemDlg.this.validate();
            }
        });
        this.fOperationCombo = new Combo(composite, 2048);
        this.fOperationCombo.setItems(PRESET_OPERATIONS);
        GridData gd = new GridData(768);
        gd.widthHint = 250;
        this.fOperationCombo.setLayoutData((Object)gd);
        this.fOperationCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UiNewAppControlItemDlg.this.validate();
            }
        });
        Button radio2 = new Button(composite, 16);
        radio2.setText(AppControl.CATEGORIES.mime.toString());
        radio2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UiNewAppControlItemDlg.this.fOperationCombo.setEnabled(false);
                UiNewAppControlItemDlg.this.fUriText.setEnabled(false);
                UiNewAppControlItemDlg.this.fMimeCombo.setEnabled(true);
                UiNewAppControlItemDlg.this.fMimeCombo.setFocus();
                UiNewAppControlItemDlg.this.validate();
            }
        });
        this.fMimeCombo = new Combo(composite, 2048);
        this.fMimeCombo.setItems(PRESET_MIMETYPES);
        this.fMimeCombo.setLayoutData((Object)new GridData(768));
        this.fMimeCombo.setEnabled(false);
        this.fMimeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UiNewAppControlItemDlg.this.validate();
            }
        });
        Button radio3 = new Button(composite, 16);
        radio3.setText(AppControl.CATEGORIES.uri.toString());
        radio3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UiNewAppControlItemDlg.this.fOperationCombo.setEnabled(false);
                UiNewAppControlItemDlg.this.fMimeCombo.setEnabled(false);
                UiNewAppControlItemDlg.this.fUriText.setEnabled(true);
                UiNewAppControlItemDlg.this.fUriText.setFocus();
                UiNewAppControlItemDlg.this.validate();
            }
        });
        this.fUriText = new Text(composite, 2048);
        this.fUriText.setLayoutData((Object)new GridData(768));
        this.fUriText.setEnabled(false);
        this.fUriText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UiNewAppControlItemDlg.this.validate();
            }
        });
        this.fOperationCombo.setFocus();
        this.validate();
        return composite;
    }

    private void validate() {
        this.computeResult();
        Status s = null;
        if (this.fItem.getValue().length() < 1) {
            s = new Status(4, "org.tizen.nativecore.misc", "empty value");
        }
        for (AppControl.AppControlItem item : this.fRefAppControl.getAppServiceItems()) {
            if (!item.equals(this.fItem)) continue;
            s = new Status(4, "org.tizen.nativecore.misc", "duplicate value");
            break;
        }
        if (s == null) {
            s = new Status(0, "org.tizen.nativecore.misc", null);
        }
        this.updateStatus((IStatus)s);
    }

    public AppControl.AppControlItem getAppControlItem() {
        return this.fItem;
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected void computeResult() {
        String input = null;
        if (this.fOperationCombo.isEnabled()) {
            this.fItem.setCategory(AppControl.CATEGORIES.operation);
            input = this.fOperationCombo.getText().trim();
        }
        if (this.fMimeCombo.isEnabled()) {
            this.fItem.setCategory(AppControl.CATEGORIES.mime);
            input = this.fMimeCombo.getText();
            int ch = input.indexOf("(");
            if (ch > -1) {
                input = input.substring(0, ch).trim();
            }
        }
        if (this.fUriText.isEnabled()) {
            this.fItem.setCategory(AppControl.CATEGORIES.uri);
            input = this.fUriText.getText().trim();
        }
        this.fItem.setValue(input);
    }
}

