/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.apichecker;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class APICheckerNature
implements IProjectNature {
    private IProject project;
    private static final String API_NATURE = "org.tizen.nativecore.apichecker.apicheckernature";
    private static final String API_BUILDER = "org.tizen.nativecore.apichecker.apicheckerbuilder";
    private static final String PROJECT = ".project";

    public APICheckerNature() {
    }

    public APICheckerNature(IProject project) {
        this.setProject(project);
    }

    public void configure() throws CoreException {
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public static void addNature(IProject project, IProgressMonitor monitor) throws CoreException {
        APICheckerNature.addNature(project, API_NATURE, monitor);
    }

    public static void removeNature(IProject project, IProgressMonitor monitor) throws CoreException {
        APICheckerNature.removeNature(project, API_NATURE, monitor);
    }

    public static void addNature(IProject project, String natureId, IProgressMonitor monitor) throws CoreException {
        String BuilderID = API_BUILDER;
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        int i = 0;
        while (i < prevNatures.length) {
            if (natureId.equals(prevNatures[i])) {
                return;
            }
            ++i;
        }
        IResource projectFile = project.findMember(PROJECT);
        if (projectFile instanceof IFile) {
            ResourceAttributes attributes = projectFile.getResourceAttributes();
            attributes.setReadOnly(false);
            projectFile.setResourceAttributes(attributes);
        }
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        project.setDescription(description, monitor);
        if (natureId.equals(API_NATURE)) {
            ICommand[] commands = description.getBuildSpec();
            int i2 = 0;
            while (i2 < commands.length) {
                if (commands[i2].getBuilderName().equals(BuilderID)) {
                    return;
                }
                ++i2;
            }
            ICommand[] newCommands = new ICommand[commands.length + 1];
            ICommand command = description.newCommand();
            command.setBuilderName(BuilderID);
            newCommands[0] = command;
            System.arraycopy(commands, 0, newCommands, 1, commands.length);
            description.setBuildSpec(newCommands);
            project.setDescription(description, null);
        }
    }

    public static void removeNature(IProject project, String natureId, IProgressMonitor monitor) throws CoreException {
        IResource projectFile = project.findMember(PROJECT);
        if (projectFile instanceof IFile) {
            ResourceAttributes attributes = projectFile.getResourceAttributes();
            attributes.setReadOnly(false);
            projectFile.setResourceAttributes(attributes);
        }
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        ArrayList<String> newNatures = new ArrayList<String>(Arrays.asList(prevNatures));
        newNatures.remove(natureId);
        description.setNatureIds(newNatures.toArray(new String[newNatures.size()]));
        project.setDescription(description, monitor);
        if (natureId.equals(API_NATURE)) {
            ICommand[] commands = description.getBuildSpec();
            int i = 0;
            while (i < commands.length) {
                if (commands[i].getBuilderName().equals(API_BUILDER)) {
                    ICommand[] newCommands = new ICommand[commands.length - 1];
                    System.arraycopy(commands, 0, newCommands, 0, i);
                    System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                    description.setBuildSpec(newCommands);
                    project.setDescription(description, null);
                    return;
                }
                ++i;
            }
        }
    }
}

