/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.tizen.nativecore.ext.manifest.Manifest;
import org.tizen.nativecore.misc.IdePlugin;
import org.tizen.nativecore.misc.core.LocaledValue;
import org.tizen.nativecore.misc.editor.Messages;
import org.tizen.nativecore.misc.editor.SectionHelper;
import org.tizen.nativecore.misc.editor.TizenFormPage;
import org.tizen.nativecore.misc.editor.UiAttrLocaledName;

public class CoreLocalizationPage
extends TizenFormPage {
    String imagePath;
    public UiAttrLocaledName fUiName;
    public UiAttrLocaledName fUiDescriptions;
    public UiAttrLocaledName fUiIcon;

    public CoreLocalizationPage(FormEditor editor) {
        super(editor, Messages.CoreLocalizationPage_localization, Messages.CoreLocalizationPage_localization);
    }

    private String updatedVersion(String version, String sep, int width) {
        String[] split = Pattern.compile(sep, 16).split(version);
        StringBuilder sb = new StringBuilder();
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append(String.format("%" + width + 's', s));
            ++n2;
        }
        return sb.toString();
    }

    private int compareVersion(String ver1, String ver2) {
        int result = -1;
        String s1 = this.updatedVersion(ver1, ".", 2);
        String s2 = this.updatedVersion(ver2, ".", 2);
        result = s1.compareTo(s2);
        return result;
    }

    boolean isIconSupported(String apiversion, String profile) {
        if (profile.equals("mobile") && this.compareVersion(apiversion, "3.0") >= 0) {
            return true;
        }
        return profile.equals("wearable") && this.compareVersion(apiversion, "2.3.2") >= 0;
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm scrolledForm = managedForm.getForm();
        FormToolkit tk = managedForm.getToolkit();
        Composite body = scrolledForm.getBody();
        body.setLayout((Layout)new GridLayout());
        this.imagePath = IdePlugin.getDefault().getResourceLocationURL("icons/editor/title_localization.png").getFile();
        Composite client = SectionHelper.createHeaderSection(tk, body, Messages.CoreLocalizationPage_localization, this.imagePath, Messages.CoreLocalizationPage_title, Messages.CoreLocalizationPage_subtitle);
        Composite tableBody = tk.createComposite(client);
        tableBody.setLayout((Layout)new GridLayout());
        tableBody.setLayoutData((Object)new GridData(768));
        this.fUiName = new UiAttrLocaledName(this, false);
        this.fUiName.setDefaultLocaleRequired(false);
        this.fUiName.createUi(tableBody, tk, Messages.CoreLocalizationPage_label, true);
        this.fUiDescriptions = new UiAttrLocaledName(this, false);
        this.fUiDescriptions.setDefaultLocaleRequired(false);
        this.fUiDescriptions.createUi(tableBody, tk, Messages.CoreLocalizationPage_description, true);
        String apiversion = this.getEditor().getCoreManifest().getApiVersion();
        String profile = this.getEditor().getCoreManifest().getProfile().getName();
        if (this.isIconSupported(apiversion, profile)) {
            this.fUiIcon = new UiAttrLocaledName(this, false);
            this.fUiIcon.setDefaultLocaleRequired(false);
            this.fUiIcon.createUi(tableBody, tk, Messages.CoreLocalizationPage_icon, true);
        }
        this.update(this.getEditor().getCoreManifest());
        this.setDirty(false);
    }

    public void update(Manifest coreManifest) {
        if (this.fUiName != null) {
            this.fUiName.setInput(coreManifest.getDefaultApp().getLabels());
        }
        if (this.fUiDescriptions != null) {
            this.fUiDescriptions.setInput(coreManifest.getDescriptions());
        }
        if (this.fUiIcon != null) {
            String profile;
            String apiversion = this.getEditor().getCoreManifest().getApiVersion();
            if (this.isIconSupported(apiversion, profile = this.getEditor().getCoreManifest().getProfile().getName())) {
                List<LocaledValue> icons = coreManifest.getDefaultApp().getIcons();
                if (icons != null) {
                    this.fUiIcon.setInput(icons);
                }
                this.fUiIcon.setVisible(true);
            } else {
                this.fUiIcon.setVisible(false);
            }
        }
    }
}

