/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor.dlg;

import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.tizen.nativecore.ext.manifest.Category;

public class UiNewCategoryDialog
extends SelectionStatusDialog {
    String fCategory;
    Set<String> fExistingCategories;
    private Label fLabel;
    private Combo fCombo;

    public UiNewCategoryDialog(Shell parentShell, Set<String> categories) {
        super(parentShell);
        this.setTitle("Add Category");
        this.fExistingCategories = categories;
        this.setStatusLineAboveButtons(true);
    }

    public String getCategory() {
        return this.fCategory;
    }

    protected Control createDialogArea(Composite parent) {
        Composite grid = new Composite(parent, 0);
        grid.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(1808);
        grid.setLayoutData((Object)gd);
        UiNewCategoryDialog.applyDialogFont((Control)grid);
        this.fLabel = new Label(grid, 0);
        this.fLabel.setText("Category");
        this.fLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.fCombo = new Combo(grid, 0);
        this.fCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.fCombo.setItems(Category.CATEGORY_PRESETS);
        this.fCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UiNewCategoryDialog.this.validate();
            }
        });
        if (this.fCategory != null) {
            this.fCombo.setText(this.fCategory);
        }
        this.setHelpAvailable(false);
        this.validate();
        return grid;
    }

    private void validate() {
        this.computeResult();
        Status status = null;
        status = this.fCategory.length() <= 0 ? new Status(4, "org.tizen.nativecore.misc", "Enter a Category") : (this.fExistingCategories.contains(this.fCategory) ? new Status(4, "org.tizen.nativecore.misc", "Already existing category") : new Status(0, "org.tizen.nativecore.misc", null));
        this.updateStatus((IStatus)status);
    }

    protected void computeResult() {
        this.fCategory = this.fCombo.getText().trim();
    }

    public void setCategory(String category) {
        this.fCategory = category;
        this.setTitle("Edit Category");
    }
}

