/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.apichecker.inplacechecker;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.tizen.nativecore.apichecker.inplacechecker.DocumentChangeListener;

public class Startup
implements IStartup {
    public void earlyStartup() {
        this.registerListeners();
    }

    private void registerListeners() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        workbench.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow active = workbench.getActiveWorkbenchWindow();
                if (active == null) {
                    return;
                }
                IWorkbenchPage page = active.getActivePage();
                if (page == null) {
                    return;
                }
                IPartListener2 partListener = new IPartListener2(){
                    DocumentChangeListener listner = new DocumentChangeListener();

                    public void partActivated(IWorkbenchPartReference partRef) {
                    }

                    public void partDeactivated(IWorkbenchPartReference partRef) {
                    }

                    public void partOpened(IWorkbenchPartReference partRef) {
                        IWorkbenchPart editor = partRef.getPart(false);
                        if (editor instanceof ITextEditor) {
                            ITextEditor textEditor = (ITextEditor)editor;
                            IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                            document.addDocumentListener((IDocumentListener)this.listner);
                        }
                    }

                    public void partHidden(IWorkbenchPartReference partRef) {
                    }

                    public void partVisible(IWorkbenchPartReference partRef) {
                    }

                    public void partClosed(IWorkbenchPartReference partRef) {
                        IWorkbenchPart part = partRef.getPart(false);
                        if (part instanceof ITextEditor) {
                            ITextEditor textEditor = (ITextEditor)part;
                            IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                            document.removeDocumentListener((IDocumentListener)this.listner);
                        }
                    }

                    public void partBroughtToTop(IWorkbenchPartReference partRef) {
                    }

                    public void partInputChanged(IWorkbenchPartReference partRef) {
                    }
                };
                page.addPartListener(partListener);
                IEditorReference[] editorReferences = page.getEditorReferences();
                int i = 0;
                while (i < editorReferences.length) {
                    IEditorReference ref = editorReferences[i];
                    partListener.partOpened((IWorkbenchPartReference)ref);
                    ++i;
                }
            }
        });
    }
}

