/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.project.wizard.git;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.tizen.nativeplatform.project.wizard.git.model.GitDescription;

public class GitDescManager {
    private static Map<String, Map<String, GitDescription>> siteGitDesc = new Hashtable<String, Map<String, GitDescription>>();

    public static void setDescs(String siteConfigName, List<GitDescription> descs) {
        HashMap<String, GitDescription> gitDesc = new HashMap<String, GitDescription>();
        for (GitDescription desc : descs) {
            gitDesc.put(desc.getProject(), desc);
        }
        siteGitDesc.put(siteConfigName, gitDesc);
    }

    public static List<GitDescription> getDescs(String siteConfigName) {
        ArrayList<GitDescription> result = new ArrayList<GitDescription>();
        Map<String, GitDescription> gitDesc = siteGitDesc.get(siteConfigName);
        if (gitDesc == null) {
            return result;
        }
        Iterator<GitDescription> it = gitDesc.values().iterator();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public static GitDescription getDesc(String siteConfigName, String gitPath) {
        Map<String, GitDescription> gitDesc = siteGitDesc.get(siteConfigName);
        if (gitDesc == null) {
            return null;
        }
        return gitDesc.get(gitPath);
    }

    public static void removeDesc(String siteConfigName) {
        if (siteGitDesc.containsKey(siteConfigName)) {
            siteGitDesc.remove(siteConfigName);
        }
    }
}

