/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.project.wizard.git.parser;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.core.resources.ResourcesPlugin;
import org.tizen.common.util.IOUtil;
import org.tizen.nativeplatform.preferences.PreferencesManager;
import org.tizen.nativeplatform.project.wizard.git.model.GitDescription;
import org.tizen.nativeplatform.project.wizard.git.parser.IGitIndexParser;

public class WebGitIndexParser
implements IGitIndexParser {
    private static final String GIT_LIST_CACHE_FILE_FORMAT = ".%s.index.html";

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean prework(PreferencesManager.SiteConfiguration config) throws InterruptedException {
        BufferedReader in;
        BufferedWriter out;
        block10: {
            String name = config.getName();
            String path = config.getListLocation();
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            try {
                SSLContext sc = SSLContext.getInstance("TLS");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            out = null;
            in = null;
            String cacheFilePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(String.format(GIT_LIST_CACHE_FILE_FORMAT, name)).toString();
            File cacheFile = new File(cacheFilePath);
            try {
                if (cacheFile.exists()) {
                    cacheFile.delete();
                }
                URL u = new URL(path);
                Proxy proxy = PreferencesManager.getProxy();
                URLConnection yc = null;
                yc = proxy != null ? u.openConnection(proxy) : u.openConnection();
                in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
                out = new BufferedWriter(new FileWriter(cacheFilePath));
                String line = null;
                while (true) {
                    if ((line = in.readLine()) == null) {
                        if (!cacheFile.exists()) break block10;
                        break;
                    }
                    out.write(String.valueOf(line) + "\n");
                }
            }
            catch (MalformedURLException e) {
                try {
                    e.printStackTrace();
                    throw new InterruptedException(e.toString());
                    catch (IOException e2) {
                        e2.printStackTrace();
                        throw new InterruptedException(e2.toString());
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{in});
                    IOUtil.tryClose((Object[])new Object[]{out});
                    throw throwable;
                }
            }
            IOUtil.tryClose((Object[])new Object[]{in});
            IOUtil.tryClose((Object[])new Object[]{out});
            return true;
        }
        IOUtil.tryClose((Object[])new Object[]{in});
        IOUtil.tryClose((Object[])new Object[]{out});
        return false;
    }

    @Override
    public List<GitDescription> parse(PreferencesManager.SiteConfiguration config) throws InterruptedException {
        boolean startTable = false;
        boolean startTr = false;
        boolean getProjectName = false;
        boolean getDescription = false;
        boolean getOwner = false;
        String cacheFile = config.getListCacheFile();
        ArrayList<GitDescription> GitDescs = new ArrayList<GitDescription>();
        if (!new File(cacheFile).exists()) {
            return GitDescs;
        }
        BufferedReader in = null;
        try {
            try {
                String str;
                in = new BufferedReader(new FileReader(cacheFile));
                GitDescription gitDesc = null;
                while ((str = in.readLine()) != null) {
                    str = str.trim();
                    if (startTable) {
                        if (str.startsWith("<tr")) {
                            startTr = true;
                            gitDesc = new GitDescription();
                            continue;
                        }
                        if (str.startsWith("</tr")) {
                            startTr = false;
                            if (getProjectName) {
                                GitDescs.add(gitDesc);
                            }
                            getProjectName = false;
                            getDescription = false;
                            getOwner = false;
                            continue;
                        }
                        if (gitDesc != null && startTr) {
                            if (!getProjectName) {
                                if (str.startsWith("<td")) {
                                    String project = str.replaceAll("<(/)?([a-zA-Z]*)(\\s[a-zA-Z]*=[^>]*)?(\\s)*(/)?>", "");
                                    getProjectName = true;
                                    gitDesc.setProject(project);
                                }
                            } else if (!getDescription) {
                                if (str.startsWith("<td")) {
                                    String desc = str.replaceAll("<(/)?([a-zA-Z]*)(\\s[a-zA-Z]*=[^>]*)?(\\s)*(/)?>", "");
                                    getDescription = true;
                                    gitDesc.setDesc(desc);
                                }
                            } else if (!getOwner && str.startsWith("<td")) {
                                String owner = str.replaceAll("<(/)?([a-zA-Z]*)(\\s[a-zA-Z]*=[^>]*)?(\\s)*(/)?>", "");
                                getOwner = true;
                                gitDesc.setOwner(owner);
                            }
                        }
                    }
                    if (!startTable && str.equals("<table class=\"project_list\">")) {
                        startTable = true;
                        continue;
                    }
                    if (!startTable || !str.equals("</table>")) continue;
                    startTable = false;
                    break;
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                throw new InterruptedException(e.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new InterruptedException(e.toString());
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{in});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{in});
        return GitDescs;
    }
}

