/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.changelog.core.actions;

import java.io.ByteArrayInputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.changelog.core.ChangeLogExtensionManager;
import org.eclipse.linuxtools.changelog.core.ChangelogPlugin;
import org.eclipse.linuxtools.changelog.core.Messages;
import org.eclipse.linuxtools.changelog.core.actions.ChangeLogContainerSelectionDialog;
import org.eclipse.team.ui.synchronize.SyncInfoCompareInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChangeLogAction
extends Action {
    protected ChangeLogExtensionManager extensionManager = ChangeLogExtensionManager.getExtensionManager();
    protected String pref_AuthorName;
    protected String pref_AuthorEmail;
    protected String pref_ChangeLogName = "ChangeLog";
    protected String pref_Formatter;

    public ChangeLogAction() {
    }

    public ChangeLogAction(String name) {
        super(name);
    }

    protected void reportErr(String msg, Exception e) {
        ChangelogPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.linuxtools.changelog.core", 4, msg, (Throwable)e));
    }

    protected IWorkbench getWorkbench() {
        return ChangelogPlugin.getDefault().getWorkbench();
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected IEditorPart openEditor(IFile diskresource) {
        IWorkbench ws = this.getWorkbench();
        try {
            return IDE.openEditor((IWorkbenchPage)ws.getActiveWorkbenchWindow().getActivePage(), (IFile)diskresource, (boolean)true);
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String returnQualifedEditor(Class<?> ClassName) {
        return ClassName.toString().substring(ClassName.getPackage().toString().length() - 1, ClassName.toString().length());
    }

    protected IFile createChangeLog(IPath changelog) {
        IWorkspaceRoot myWorkspaceRoot = this.getWorkspaceRoot();
        IWorkbench ws = this.getWorkbench();
        final IFile changelog_File = myWorkspaceRoot.getFile(changelog);
        final ByteArrayInputStream initialContents = new ByteArrayInputStream(new byte[0]);
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    monitor.beginTask(Messages.getString("ChangeLog.AddingChangeLog"), 2000);
                    changelog_File.create(initialContents, false, monitor);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(ws.getActiveWorkbenchWindow().getShell()).run(true, true, (IRunnableWithProgress)operation);
        }
        catch (InterruptedException e) {
            this.reportErr(Messages.getString("ChangeLog.ErrInterrupted"), e);
            return null;
        }
        catch (InvocationTargetException e) {
            this.reportErr(Messages.getString("ChangeLog.ErrInvocation"), e);
            return null;
        }
        try {
            IContainer changelogContainer = myWorkspaceRoot.getContainerForLocation(changelog);
            if (changelogContainer != null) {
                changelogContainer.refreshLocal(2, null);
            }
        }
        catch (CoreException e) {
            this.reportErr(Messages.getString("ChangeLog.ErrRefresh"), (Exception)((Object)e));
            return null;
        }
        return changelog_File;
    }

    protected IEditorPart askChangeLogLocation(String editorLoc) {
        IWorkbench ws = this.getWorkbench();
        IWorkspaceRoot myWorkspaceRoot = this.getWorkspaceRoot();
        IResource given_resource = myWorkspaceRoot.findMember(editorLoc);
        if (given_resource == null) {
            return null;
        }
        ChangeLogContainerSelectionDialog dialog = new ChangeLogContainerSelectionDialog(ws.getActiveWorkbenchWindow().getShell(), given_resource.getParent(), false, Messages.getString("AddAction.str_ChangeLog_Location"));
        dialog.showClosedProjects(false);
        dialog.open();
        Object[] result = dialog.getResult();
        if (result == null) {
            return null;
        }
        Path result_path = new Path(result[0] + System.getProperty("file.separator") + this.pref_ChangeLogName);
        IFile newChangeLog = this.createChangeLog((IPath)result_path);
        return this.openEditor(newChangeLog);
    }

    protected IEditorPart getChangelog(String currentEditorloc) {
        IWorkspaceRoot myWorkspaceRoot = this.getWorkspaceRoot();
        IResource given_resource = myWorkspaceRoot.findMember(currentEditorloc);
        if (given_resource != null) {
            IResource parent_dec = given_resource;
            while (parent_dec != null) {
                String parent_node = parent_dec.getFullPath().removeLastSegments(1).toOSString();
                IResource change_log_res = myWorkspaceRoot.findMember(parent_node = String.valueOf(parent_node) + System.getProperty("file.separator") + this.pref_ChangeLogName);
                if (change_log_res != null) {
                    IProject proj_loc = given_resource.getProject();
                    IPath modified_changelog_path = change_log_res.getFullPath().removeFirstSegments(1);
                    IFile change_log_file = proj_loc.getFile(modified_changelog_path);
                    return this.openEditor(change_log_file);
                }
                if ((parent_dec = parent_dec.getParent()) == null) break;
            }
        }
        return null;
    }

    protected IEditorPart getChangelogForRemovePath(IPath path) {
        IResource parent_resource = null;
        IPath loc_path = path;
        IWorkspaceRoot myWorkspaceRoot = this.getWorkspaceRoot();
        while (loc_path.segmentCount() > 0) {
            parent_resource = myWorkspaceRoot.findMember(loc_path);
            if (parent_resource != null) break;
            loc_path = loc_path.removeLastSegments(1);
        }
        if (parent_resource != null) {
            IResource parent_dec = parent_resource;
            while (parent_dec != null) {
                String parent_node = parent_dec.getFullPath().toOSString();
                IResource change_log_res = myWorkspaceRoot.findMember(parent_node = String.valueOf(parent_node) + System.getProperty("file.separator") + this.pref_ChangeLogName);
                if (change_log_res != null) {
                    IProject proj_loc = parent_resource.getProject();
                    IPath modified_changelog_path = change_log_res.getFullPath().removeFirstSegments(1);
                    IFile change_log_file = proj_loc.getFile(modified_changelog_path);
                    return this.openEditor(change_log_file);
                }
                if ((parent_dec = parent_dec.getParent()) == null) break;
            }
        }
        return null;
    }

    protected IFile getDocumentIFile(IEditorPart currentEditor) {
        IEditorInput cc = currentEditor.getEditorInput();
        if (cc instanceof IFileEditorInput) {
            return ((IFileEditorInput)cc).getFile();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getDocumentLocation(IEditorPart currentEditor, boolean appendRoot) {
        String WorkspaceRoot;
        IFile loc = this.getDocumentIFile(currentEditor);
        IEditorInput cc = null;
        try {
            IWorkspaceRoot myWorkspaceRoot = this.getWorkspaceRoot();
            WorkspaceRoot = myWorkspaceRoot.getLocation().toOSString();
            if (currentEditor instanceof MultiPageEditorPart) {
                Object ed = ((MultiPageEditorPart)currentEditor).getSelectedPage();
                if (ed instanceof IEditorPart) {
                    cc = ((IEditorPart)ed).getEditorInput();
                }
                if (cc instanceof FileEditorInput) {
                    String string;
                    if (appendRoot) {
                        string = String.valueOf(WorkspaceRoot) + ((FileEditorInput)cc).getFile().getFullPath().toOSString();
                        return string;
                    }
                    string = ((FileEditorInput)cc).getFile().getFullPath().toOSString();
                    return string;
                }
            }
            cc = currentEditor.getEditorInput();
        }
        catch (Exception exception) {
            return "";
        }
        if (cc == null) {
            return "";
        }
        if (cc instanceof SyncInfoCompareInput || cc instanceof CompareEditorInput) {
            CompareEditorInput test = (CompareEditorInput)cc;
            if (test.getCompareResult() == null) {
                return "";
            }
            if (!(test.getCompareResult() instanceof ICompareInput)) {
                if (!appendRoot) return test.getCompareResult().toString();
                return String.valueOf(WorkspaceRoot) + test.getCompareResult().toString();
            }
            ITypedElement leftCompare = ((ICompareInput)test.getCompareResult()).getLeft();
            if (leftCompare instanceof IResourceProvider) {
                String localPath = ((IResourceProvider)leftCompare).getResource().getFullPath().toString();
                if (!appendRoot) return localPath;
                return String.valueOf(WorkspaceRoot) + localPath;
            }
        } else if (cc instanceof FileStoreEditorInput) {
            return ((FileStoreEditorInput)cc).getName();
        }
        if (appendRoot) {
            return String.valueOf(WorkspaceRoot) + loc.getFullPath().toOSString();
        }
        if (loc == null) return "";
        return loc.getFullPath().toOSString();
    }

    protected void loadPreferences() {
        IPreferenceStore store = ChangelogPlugin.getDefault().getPreferenceStore();
        this.pref_AuthorName = store.getString("IChangeLogConstants.AUTHOR_NAME");
        this.pref_AuthorEmail = store.getString("IChangeLogConstants.AUTHOR_EMAIL");
        this.pref_Formatter = store.getString("IChangeLogConstants.DEFAULT_FORMATTER");
    }
}

