/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.linux.launch;

import java.io.File;
import java.io.IOException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.LocalPortChecker;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativecommon.build.exception.SBIException;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.nativecommon.launch.TizenLaunchMessages;
import org.tizen.nativeplatform.PlatformConfigurationManager;
import org.tizen.nativeplatform.launcher.command.provider.IDebugCommandProvider;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.password.SudoPasswdManager;
import org.tizen.nativeplatform.util.PlatformLaunchUtil;
import org.tizen.sbilib.SBI;
import org.tizen.sbilib.ide.DebugOption;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;

public class DebugCommandProvider
implements IDebugCommandProvider {
    protected final Logger logger = LoggerFactory.getLogger(DebugCommandProvider.class);

    public Process debug(IConfiguration config, String[] arrOption) throws IOException {
        String targetID = this.getTargetID(config);
        String workingDir = this.getWorkingDir(config);
        DebugOption dOptions = this.getDebugOptions(targetID, arrOption);
        SBI sbi = SBI.getInstance();
        return sbi.debug(targetID, null, dOptions, workingDir);
    }

    protected String getTargetID(IConfiguration config) {
        return PlatformConfigurationManager.getBuildTargetName((IConfiguration)config);
    }

    protected String getWorkingDir(IConfiguration config) {
        IProject project = (IProject)config.getOwner();
        String workingDir = String.valueOf(project.getLocation().toOSString()) + File.separatorChar + config.getName();
        return workingDir;
    }

    protected DebugOption getDebugOptions(String targetID, String[] arrOption) {
        DebugOption dOption = new DebugOption();
        if (targetID.contains(".platform")) {
            String passwd = SudoPasswdManager.getSudoPassword();
            SmartBuildInterface sbi = SmartBuildInterface.getInstance();
            dOption.setPassword(passwd);
            String path = "";
            try {
                path = new Path(sbi.getRootstrapPath(targetID)).makeAbsolute().toOSString();
            }
            catch (SBIException e) {
                e.printStackTrace();
            }
            String rootstrapPath = sbi.getPlatformRootstrapPath(path);
            String gdbOptions = "";
            int i = 0;
            while (i < arrOption.length) {
                if (arrOption[i] == null) break;
                if (!arrOption[i].startsWith("--cd")) {
                    if (arrOption[i].contains(rootstrapPath)) {
                        String op = arrOption[i].replaceAll(rootstrapPath, "");
                        gdbOptions = gdbOptions.concat(String.valueOf(op) + " ");
                    } else {
                        gdbOptions = gdbOptions.concat(String.valueOf(arrOption[i]) + " ");
                    }
                }
                ++i;
            }
            dOption.setGdbOptions(gdbOptions);
            dOption.setRootPath(rootstrapPath);
        }
        return dOption;
    }

    public String getRootstrapDebugSrcPath(PlatformRootstrap rootstrap) {
        String basePath = rootstrap.getPath().toString();
        String rootstrapPath = SmartBuildInterface.getInstance().getPlatformRootstrapPath(basePath);
        String srcPath = new Path(rootstrapPath).append("usr").toString();
        return srcPath;
    }

    public ILaunchConfiguration createForward(ILaunchConfiguration config, IDevice device) throws CoreException, NumberFormatException, TimeoutException, SdbCommandRejectedException, IOException {
        int gdbserverPort = 0;
        ILaunchConfiguration newConfiguration = config;
        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
        gdbserverPort = Integer.parseInt(config.getAttribute("org.eclipse.cdt.dsf.gdb.PORT", "26102"));
        String host = PlatformLaunchUtil.getHostIp();
        String targetPort = "";
        int forwardingLocalPort = 46100;
        if (!LocalPortChecker.isPortAvailable((int)forwardingLocalPort) && (forwardingLocalPort = PlatformLaunchUtil.getDefaultDebugPort((IDevice)device)) < 0) {
            LaunchUtils.newCoreException((String)TizenLaunchMessages.CANNOT_SET_DEBUG_LOCAL_PORT_TO_NEGATIVE, null);
        }
        targetPort = Integer.valueOf(forwardingLocalPort).toString();
        device.createForward(forwardingLocalPort, gdbserverPort);
        wc.setAttribute("org.tizen.platform.launch.DEBUG_REALPORT", gdbserverPort);
        this.logger.info(String.format("port forward %d %d [sdb]", forwardingLocalPort, gdbserverPort));
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.HOST", host);
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.PORT", targetPort);
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.PORT", targetPort);
        newConfiguration = wc.doSave();
        return newConfiguration;
    }

    public void winCheckDebugsourceSync(Shell shell, PlatformRootstrap rootstrap) {
    }
}

