/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.linux.rootstrap.action;

import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.DialogUtil;
import org.tizen.nativeplatform.linux.rootstrap.core.RootstrapExporter;
import org.tizen.nativeplatform.model.PlatformRootstrap;

public class RootstrapExportAction
extends Action {
    protected final String BUNDLE_NAME = String.valueOf(RootstrapExportAction.class.getPackage().getName()) + ".RootstrapUIMessages";
    protected ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);
    protected final Logger logger = LoggerFactory.getLogger(RootstrapExportAction.class);
    protected IProject project;
    protected TableViewer viewer;
    protected Shell shell;

    public RootstrapExportAction(Shell shell, IProject project, TableViewer viewer) {
        this.project = project;
        this.viewer = viewer;
        this.shell = shell;
    }

    public void run() {
        this.action();
    }

    private void action() {
        this.doActionForEntry(new IActionForEntry(){

            @Override
            public void doAction() {
                Table table = RootstrapExportAction.this.viewer.getTable();
                TableItem[] item = table.getSelection();
                final PlatformRootstrap selectedRootstrap = (PlatformRootstrap)item[0].getData();
                if (!selectedRootstrap.isInitialized()) {
                    DialogUtil.openErrorDialog((String)RootstrapExportAction.this.resources.getString("Action.Msg.Error.ExportUninitialzed"));
                    return;
                }
                FileDialog fd = new FileDialog(RootstrapExportAction.this.shell, 8192);
                fd.setText(RootstrapExportAction.this.resources.getString("FileDlg.Title.Export"));
                String[] extensions = new String[]{"*.tar"};
                fd.setFilterExtensions(extensions);
                String resultFilePath = fd.open();
                if (resultFilePath == null || resultFilePath.isEmpty()) {
                    return;
                }
                if (!resultFilePath.endsWith(".tar")) {
                    resultFilePath = String.valueOf(resultFilePath) + ".tar";
                }
                final String selectedFilePath = resultFilePath;
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(RootstrapExportAction.this.shell);
                try {
                    dialog.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask((this).RootstrapExportAction.this.resources.getString("Action.Msg.Progress.Exporting"), -1);
                            boolean result = RootstrapExporter.exportRootstrap(selectedRootstrap, selectedFilePath, monitor);
                            if (result) {
                                DialogUtil.openMessageDialog((Shell)(this).RootstrapExportAction.this.shell, (String)(this).RootstrapExportAction.this.resources.getString("Action.Msg.Info.ExportOK"));
                            } else {
                                DialogUtil.openMessageDialog((Shell)(this).RootstrapExportAction.this.shell, (String)(this).RootstrapExportAction.this.resources.getString("Action.Msg.Error.ExportFailed"));
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    RootstrapExportAction.this.logger.error(RootstrapExportAction.this.resources.getString("Action.Msg.Error.ExportFailed"), (Throwable)e);
                    DialogUtil.openErrorDialog((String)String.format("%s\n * %s", RootstrapExportAction.this.resources.getString("Action.Msg.Error.ExportFailed"), e.getMessage()));
                    return;
                }
                catch (InterruptedException e) {
                    RootstrapExportAction.this.logger.error(RootstrapExportAction.this.resources.getString("Action.Msg.Error.ExportFailed"), (Throwable)e);
                    DialogUtil.openErrorDialog((String)String.format("%s\n * %s", RootstrapExportAction.this.resources.getString("Action.Msg.Error.ExportFailed"), e.getMessage()));
                    return;
                }
            }

            @Override
            public boolean doCheckEnable() {
                return true;
            }
        });
    }

    private void doActionForEntry(IActionForEntry action) {
        if (action.doCheckEnable()) {
            action.doAction();
        }
    }

    private static interface IActionForEntry {
        public boolean doCheckEnable();

        public void doAction();
    }
}

