/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.MultiConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativecommon.build.exception.SBIException;
import org.tizen.nativeplatform.PlatformInstances;
import org.tizen.nativeplatform.util.IBuildCommandUtil;

public class PlatformConfigurationManager
extends CommonConfigurationManager {
    private static Logger logger = LoggerFactory.getLogger(PlatformConfigurationManager.class);
    public static final String CURRENT_SLP_PROJECT_VERSION = "1.0.0";
    public static final String[] SUPPORTED_PROFILE = new String[]{"tv"};
    public static final String TIZEN_PLATFORM_ARTIFACT_TYPE = "org.tizen.nativeide.buildArtefactType.platform";
    public static final String OLD_SLP_CUSTOM_DEBIAN_ARTIFACT_TYPE = "com.samsung.slp.project.custom.debian";
    public static final String SBI_PROJECT_TYPE_ID = "org.tizen.nativebuild.target.sbi.gcc45.platform";
    public static final String SBI_DEFAULT_I386_CONFIGRATION_ID = "org.tizen.nativeide.config.sbi.gcc45.platform.emulator";
    public static final String SBI_DEFAULT_ARM_CONFIGRATION_ID = "org.tizen.nativeide.config.sbi.gcc45.platform.device";
    public static final String SBI_DEFAULT_DEBUG_CONFIGRATION_ID = "org.tizen.nativeide.config.sbi.gcc45.platform.debug";
    public static final String SBI_DEFAULT_RELEASE_CONFIGRATION_ID = "org.tizen.nativeide.config.sbi.gcc45.platform.release";
    static final String GBS_TOOL_ID = "org.tizen.nativeide.tool.gbs";
    static final String GBS_TOOL_OPTIONS_ID = "org.tizen.gbs.options";

    public static String getAllCFlags(IConfiguration config) {
        String c_compiler_id = "org.tizen.nativeide.tool.sbi.gnu.c.compiler.base";
        return PlatformConfigurationManager.getAllCompilerFlags(config, c_compiler_id);
    }

    public static String getAllCPPFlags(IConfiguration config) {
        String cpp_compiler_id = "org.tizen.nativeide.tool.sbi.gnu.cpp.compiler.base";
        return PlatformConfigurationManager.getAllCompilerFlags(config, cpp_compiler_id);
    }

    protected static String getAllCompilerFlags(IConfiguration config, String compilerId) {
        ITool compilerTool = config.getToolsBySuperClassId(compilerId)[0];
        String compilerFlags = "";
        StringBuffer sbFlags = new StringBuffer();
        try {
            compilerFlags = compilerTool.getToolFlags();
            String[] flags = compilerFlags.split(" ");
            int i = 0;
            while (i < flags.length) {
                if (flags[i].compareTo("-c") != 0) {
                    flags[i] = flags[i].replace("\"", "\\\"");
                    sbFlags.append(" " + flags[i]);
                }
                ++i;
            }
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return sbFlags.toString().trim();
    }

    public static void setGBSOptions(IConfiguration config, List<String> optionList) {
        if (config instanceof MultiConfiguration) {
            Object[] o = ((MultiConfiguration)config).getItems();
            IConfiguration[] iConfigurationArray = (IConfiguration[])o;
            int n = iConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration c = iConfigurationArray[n2];
                PlatformConfigurationManager.internalSetGBSOptions(c, optionList);
                ++n2;
            }
        } else {
            PlatformConfigurationManager.internalSetGBSOptions(config, optionList);
        }
    }

    private static void internalSetGBSOptions(IConfiguration config, List<String> optionList) {
        String gbs_tool_id = GBS_TOOL_ID;
        String option_id = GBS_TOOL_OPTIONS_ID;
        ITool tool = config.getToolsBySuperClassId(gbs_tool_id)[0];
        IOption gbsOption = tool.getOptionBySuperClassId(option_id);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)tool, (IOption)gbsOption, (String[])optionList.toArray(new String[0]));
    }

    public static void addGBSOptions(IConfiguration config, String newOption) {
        if (config instanceof MultiConfiguration) {
            Object[] o = ((MultiConfiguration)config).getItems();
            IConfiguration[] iConfigurationArray = (IConfiguration[])o;
            int n = iConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration c = iConfigurationArray[n2];
                PlatformConfigurationManager.internalAddGBSOption(c, newOption);
                ++n2;
            }
        } else {
            PlatformConfigurationManager.internalAddGBSOption(config, newOption);
        }
    }

    private static void internalAddGBSOption(IConfiguration config, String newOption) {
        String gbs_tool_id = GBS_TOOL_ID;
        String option_id = GBS_TOOL_OPTIONS_ID;
        ITool tool = config.getToolsBySuperClassId(gbs_tool_id)[0];
        IOption gbsOption = tool.getOptionBySuperClassId(option_id);
        ArrayList<String> oldOptions = PlatformConfigurationManager.getGBSOptions(config);
        for (String op : oldOptions) {
            if (!newOption.equals(op)) continue;
            return;
        }
        oldOptions.add(newOption);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)tool, (IOption)gbsOption, (String[])oldOptions.toArray(new String[0]));
    }

    public static void removeGBSOptions(IConfiguration config, String option) {
        if (config instanceof MultiConfiguration) {
            Object[] o = ((MultiConfiguration)config).getItems();
            IConfiguration[] iConfigurationArray = (IConfiguration[])o;
            int n = iConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration c = iConfigurationArray[n2];
                PlatformConfigurationManager.internalRemoveGBSOption(c, option);
                ++n2;
            }
        } else {
            PlatformConfigurationManager.internalRemoveGBSOption(config, option);
        }
    }

    private static void internalRemoveGBSOption(IConfiguration config, String option) {
        String gbs_tool_id = GBS_TOOL_ID;
        String option_id = GBS_TOOL_OPTIONS_ID;
        ITool tool = config.getToolsBySuperClassId(gbs_tool_id)[0];
        IOption gbsOption = tool.getOptionBySuperClassId(option_id);
        ArrayList<String> oldOptions = PlatformConfigurationManager.getGBSOptions(config);
        ArrayList<String> newOptions = new ArrayList<String>();
        String removeKey = option.split("=")[0];
        for (String op : oldOptions) {
            String key = op.split("=")[0];
            if (removeKey.equals(key)) continue;
            newOptions.add(op);
        }
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)tool, (IOption)gbsOption, (String[])newOptions.toArray(new String[0]));
    }

    public static void replaceGBSOptions(IConfiguration config, String option) {
        PlatformConfigurationManager.removeGBSOptions(config, option);
        PlatformConfigurationManager.addGBSOptions(config, option);
    }

    public static ArrayList<String> getGBSOptions(IConfiguration config) {
        String gbs_tool_id = GBS_TOOL_ID;
        String option_id = GBS_TOOL_OPTIONS_ID;
        ArrayList<String> flags = new ArrayList<String>();
        ITool tool = config.getToolsBySuperClassId(gbs_tool_id)[0];
        IOption gbsOption = tool.getOptionBySuperClassId(option_id);
        try {
            String[] stringArray = gbsOption.getStringListValue();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                flags.add(f);
                ++n2;
            }
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return flags;
    }

    protected static boolean isCPPProject(IConfiguration config) {
        try {
            IProject project = (IProject)config.getOwner();
            if (project.hasNature("org.eclipse.cdt.core.ccnature")) {
                return true;
            }
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        return false;
    }

    public static void changeToolchain(IConfiguration config, String targetId) {
        PlatformConfigurationManager.setBuildTargetName((IConfiguration)config, (String)targetId);
        PlatformConfigurationManager.setToolCommand((IConfiguration)config);
    }

    public static String getRootstrapPath(IConfiguration config) {
        IBuildCommandUtil commandUtil = PlatformInstances.getBuildCommandUtil(config);
        return commandUtil.getRootstrapPath();
    }

    public static String getToolChainId(String rootstrapId) {
        try {
            List availableToolchain = PlatformConfigurationManager.getToolchainList((String)rootstrapId);
            if (availableToolchain != null && availableToolchain.size() > 0) {
                return (String)availableToolchain.get(0);
            }
        }
        catch (SBIException e) {
            logger.error("Failed to get available Toolchain List", (Throwable)e);
        }
        return null;
    }
}

