/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.command.launcher;

import java.io.IOException;
import java.util.ArrayList;
import org.tizen.nativeplatform.pkg.commander.CommandStatus;
import org.tizen.nativeplatform.pkg.commander.ICommandStatus;
import org.tizen.nativeplatform.pkg.commander.executor.DeviceExecutor;
import org.tizen.nativeplatform.pkg.commander.executor.Executor;
import org.tizen.nativeplatform.pkgmgr.PackageManagerOutputReceiver;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.ShellCommandUnresponsiveException;
import org.tizen.sdblib.exception.TimeoutException;

public class DeviceCommandLauncher {
    public static ICommandStatus execute(IDevice device, String command, PackageManagerOutputReceiver rec) {
        DeviceExecutor executor = new DeviceExecutor(command);
        return DeviceCommandLauncher.execute(device, executor, rec);
    }

    public static ICommandStatus execute(IDevice device, Executor executor, PackageManagerOutputReceiver rec) {
        String[] prevLog = new String[]{};
        String command = executor.getCommand();
        if (rec.getLog() != null) {
            prevLog = rec.getLog();
        }
        try {
            device.executeShellCommand(command, (IShellOutputReceiver)rec, executor.getTimeout());
        }
        catch (TimeoutException e) {
            return new CommandStatus(4, command, e.getMessage(), e);
        }
        catch (SdbCommandRejectedException e) {
            return new CommandStatus(4, command, e.getMessage(), e);
        }
        catch (ShellCommandUnresponsiveException e) {
            return new CommandStatus(4, command, e.getMessage(), e);
        }
        catch (IOException e) {
            return new CommandStatus(4, command, e.getMessage(), e);
        }
        CommandStatus status = new CommandStatus(0, command, "", null);
        if (rec.getLog() != null) {
            String[] nextLog = rec.getLog();
            ArrayList<String> value = new ArrayList<String>();
            int i = prevLog.length;
            while (i < nextLog.length) {
                String log = nextLog[i];
                value.add(log);
                ++i;
            }
            status.setValue(value);
        }
        return status;
    }
}

