/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.command.launcher;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tizen.common.ui.view.console.ConsoleManager;
import org.tizen.common.util.IOUtil;
import org.tizen.nativeplatform.PlatformInstances;

public class HostCommandLauncher {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static List<ConsoleManager> consoleListeners = new ArrayList<ConsoleManager>();

    public static void addConsoleListener(ConsoleManager console) {
        consoleListeners.add(console);
    }

    public static void removeConsoleListener(ConsoleManager console) {
        consoleListeners.remove(console);
    }

    public static boolean executeSudo(String command) throws InterruptedException {
        return HostCommandLauncher.executeSudo(command, null, null, null);
    }

    public static boolean executeSudo(String command, String workingDir) throws InterruptedException {
        return HostCommandLauncher.executeSudo(command, workingDir, null, null);
    }

    public static boolean executeSudo(String command, String workingDir, String consoleViewName, IProgressMonitor monitor) throws InterruptedException {
        return HostCommandLauncher.executeSudo(command, workingDir, null, consoleViewName, monitor);
    }

    public static boolean executeSudoWithExpect(String command) throws InterruptedException {
        return HostCommandLauncher.executeSudoWithExpect(command, null, null, null, null);
    }

    public static boolean executeSudoWithExpect(String command, String workingDir, Map<String, String> newEnv, String consoleViewName, IProgressMonitor monitor) throws InterruptedException {
        String scriptCmd = PlatformInstances.getScriptProvider().genSudoExecuteExpectScript(command);
        if (scriptCmd == null) {
            throw new InterruptedException("Generating execution script failed!");
        }
        boolean result = false;
        try {
            result = HostCommandLauncher.execute(scriptCmd, workingDir, newEnv, consoleViewName, monitor);
        }
        finally {
            PlatformInstances.getScriptProvider().cleanUpScript(scriptCmd, true);
        }
        return result;
    }

    public static boolean executeSudo(String command, String workingDir, Map<String, String> newEnv, String consoleViewName, IProgressMonitor monitor) throws InterruptedException {
        String scriptCmd = PlatformInstances.getScriptProvider().genSudoExecuteScript(command);
        if (scriptCmd == null) {
            throw new InterruptedException("Generating execution script failed!");
        }
        boolean result = false;
        try {
            result = HostCommandLauncher.execute(scriptCmd, workingDir, newEnv, consoleViewName, monitor);
        }
        finally {
            PlatformInstances.getScriptProvider().cleanUpScript(scriptCmd);
        }
        return result;
    }

    public static boolean execute(String command) throws InterruptedException {
        return HostCommandLauncher.execute(command, null, null, null);
    }

    public static boolean asyncExecute(Process proc) throws InterruptedException {
        proc.waitFor();
        return proc.exitValue() == 0;
    }

    public static boolean execute(String command, String workingDir, String consoleViewName, IProgressMonitor monitor) throws InterruptedException {
        return HostCommandLauncher.execute(command, workingDir, null, consoleViewName, monitor);
    }

    public static boolean execute(Process proc, String command, String consoleViewName, IProgressMonitor monitor) throws InterruptedException {
        block11: {
            if (consoleViewName != null) {
                ConsoleManager cm = new ConsoleManager(consoleViewName, true);
                cm.clear();
                cm.println("[command] " + command);
                BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                String line = null;
                try {
                    try {
                        while ((line = input.readLine()) != null) {
                            cm.println(line);
                            if (monitor == null || !monitor.isCanceled()) continue;
                            cm.println("Canceled command");
                            throw new InterruptedException("Command execution is canceled!");
                        }
                    }
                    catch (IOException e) {
                        cm.println(e.getMessage());
                        e.printStackTrace();
                        if (input != null) {
                            IOUtil.tryClose((Object[])new Object[]{input});
                        }
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    if (input != null) {
                        IOUtil.tryClose((Object[])new Object[]{input});
                    }
                    throw throwable;
                }
                if (input != null) {
                    IOUtil.tryClose((Object[])new Object[]{input});
                }
            }
        }
        proc.waitFor();
        if (monitor != null && monitor.isCanceled()) {
            throw new InterruptedException("Command execution is canceled!");
        }
        return proc.exitValue() == 0;
    }

    public static Process execute(String command, String workingDir, Map<String, String> newEnv) throws InterruptedException {
        Process proc = PlatformInstances.getBuildCommandUtil().createProcess(command, workingDir, newEnv, false);
        return proc;
    }

    public static boolean execute(String command, String workingDir, Map<String, String> newEnv, String consoleViewName, IProgressMonitor monitor) throws InterruptedException {
        Process proc;
        block12: {
            proc = PlatformInstances.getBuildCommandUtil().createProcess(command, workingDir, newEnv, false);
            if (consoleViewName != null && !consoleViewName.isEmpty()) {
                ConsoleManager cm = new ConsoleManager(consoleViewName, true);
                cm.clear();
                BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                String line = null;
                try {
                    try {
                        while ((line = input.readLine()) != null) {
                            cm.println(line);
                            for (ConsoleManager c : consoleListeners) {
                                c.println(line);
                            }
                            if (monitor == null || !monitor.isCanceled()) continue;
                            cm.println(String.format("Canceled command: %s", command));
                            throw new InterruptedException("Command execution is canceled!");
                        }
                    }
                    catch (IOException e) {
                        cm.println(e.getMessage());
                        e.printStackTrace();
                        if (input != null) {
                            IOUtil.tryClose((Object[])new Object[]{input});
                        }
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    if (input != null) {
                        IOUtil.tryClose((Object[])new Object[]{input});
                    }
                    throw throwable;
                }
                if (input != null) {
                    IOUtil.tryClose((Object[])new Object[]{input});
                }
            }
        }
        proc.waitFor();
        if (monitor != null && monitor.isCanceled()) {
            throw new InterruptedException("Command execution is canceled!");
        }
        return proc.exitValue() == 0;
    }

    public static String executeSudoOutput(String command) throws InterruptedException {
        return HostCommandLauncher.executeSudoOutput(command, null, false, null);
    }

    public static String executeSudoOutput(String command, String workingDir, boolean includeStdErr) throws InterruptedException {
        return HostCommandLauncher.executeSudoOutput(command, workingDir, includeStdErr, null);
    }

    public static String executeSudoOutput(String command, String workingDir, boolean includeStdErr, IProgressMonitor monitor) throws InterruptedException {
        String scriptCmd = PlatformInstances.getScriptProvider().genSudoExecuteScript(command);
        if (scriptCmd == null) {
            throw new InterruptedException("Generating execution script failed!");
        }
        String result = "";
        try {
            result = HostCommandLauncher.executeOutput(scriptCmd, workingDir, includeStdErr, monitor);
        }
        finally {
            PlatformInstances.getScriptProvider().cleanUpScript(scriptCmd);
        }
        return result;
    }

    public static String executeOutput(String command) throws InterruptedException {
        return HostCommandLauncher.executeOutput(command, null, false, null);
    }

    public static String executeOutput(String command, String workingDir, boolean includeStdErr, IProgressMonitor monitor) throws InterruptedException {
        Process proc = null;
        BufferedReader input = null;
        BufferedReader err = null;
        StringBuilder contents = null;
        try {
            try {
                proc = PlatformInstances.getBuildCommandUtil().createProcess(command, workingDir, null, includeStdErr);
                contents = new StringBuilder();
                input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                err = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                String line = null;
                while ((line = input.readLine()) != null) {
                    contents.append(line);
                    contents.append(LINE_SEPARATOR);
                    if (monitor == null || !monitor.isCanceled()) continue;
                    contents.append(String.format("Canceled command: %s", command));
                    throw new InterruptedException("Command execution is canceled!");
                }
                if (includeStdErr) {
                    while ((line = err.readLine()) != null) {
                        contents.append(line);
                        contents.append(LINE_SEPARATOR);
                        if (monitor == null || !monitor.isCanceled()) continue;
                        contents.append(String.format("Canceled command: %s", command));
                        throw new InterruptedException("Command execution is canceled!");
                    }
                }
                proc.waitFor();
                if (monitor != null && monitor.isCanceled()) {
                    throw new InterruptedException("Command execution is canceled!");
                }
            }
            catch (IOException iOException) {
                throw new InterruptedException("Reading process standard output failed!");
            }
        }
        catch (Throwable throwable) {
            if (input != null) {
                IOUtil.tryClose((Object[])new Object[]{input});
            }
            throw throwable;
        }
        if (input != null) {
            IOUtil.tryClose((Object[])new Object[]{input});
        }
        return contents.toString().trim();
    }

    public static List<String> executeOutput(String command, String workingDir, IProgressMonitor monitor, boolean includeStdErr) throws InterruptedException {
        Process proc = null;
        BufferedReader input = null;
        ArrayList<String> contents = new ArrayList<String>();
        try {
            try {
                proc = PlatformInstances.getBuildCommandUtil().createProcess(command, workingDir, null, includeStdErr);
                input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                String line = null;
                while ((line = input.readLine()) != null) {
                    contents.add(line.trim());
                    if (monitor == null || !monitor.isCanceled()) continue;
                    contents.add(String.format("Canceled command: %s", command));
                    throw new InterruptedException("Command execution is canceled!");
                }
                proc.waitFor();
                if (monitor != null && monitor.isCanceled()) {
                    throw new InterruptedException("Command execution is canceled!");
                }
            }
            catch (IOException iOException) {
                throw new InterruptedException("Reading process standard output failed!");
            }
        }
        catch (Throwable throwable) {
            if (input != null) {
                IOUtil.tryClose((Object[])new Object[]{input});
            }
            throw throwable;
        }
        if (input != null) {
            IOUtil.tryClose((Object[])new Object[]{input});
        }
        return contents;
    }
}

