/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.pkg.commander.rpm;

import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.tizen.nativeplatform.command.launcher.HostCommandLauncher;
import org.tizen.nativeplatform.pkg.commander.ICommandStatus;
import org.tizen.nativeplatform.pkg.commander.rpm.RpmCommanderCommon;
import org.tizen.nativeplatform.pkg.model.PkgStatus;
import org.tizen.nativeplatform.pkg.tools.RpmTool;
import org.tizen.nativeplatform.pkgmgr.PackageManagerOutputReceiver;
import org.tizen.nativeplatform.types.CmdTargetTypes;

public class RpmCommanderHost
extends RpmCommanderCommon {
    private final CmdTargetTypes CMD_TYPE = CmdTargetTypes.HOST;

    public RpmCommanderHost() {
    }

    public RpmCommanderHost(boolean useConsoleLog) {
        super(useConsoleLog, null);
    }

    @Override
    protected PackageManagerOutputReceiver getNewOuputReceiver() {
        return null;
    }

    @Override
    public Map<String, PkgStatus> getLocalPkgList() {
        return null;
    }

    @Override
    public ICommandStatus copyFilesToTmpDir(String[] fileList) {
        return null;
    }

    @Override
    public String getArchFromFile(String filePath) {
        String result = "";
        if (!new File(filePath).exists()) {
            return result;
        }
        String command = RpmTool.fileArchCommand(filePath);
        try {
            result = HostCommandLauncher.executeOutput(command);
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        String[] name = result.split(",");
        if (name.length > 0) {
            return name[0];
        }
        return "";
    }

    @Override
    public String getNameFromFile(String filePath) {
        String result = "";
        if (!new File(filePath).exists()) {
            return result;
        }
        String command = RpmTool.fileNameCommand(filePath);
        try {
            result = HostCommandLauncher.executeOutput(command);
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        String[] name = result.split(",");
        if (name.length > 0) {
            return name[0];
        }
        return "";
    }

    @Override
    public String getVerFromFile(String filePath) {
        String result = "";
        if (!new File(filePath).exists()) {
            return result;
        }
        String command = RpmTool.fileFullVerCommand(filePath);
        try {
            result = HostCommandLauncher.executeOutput(command);
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        String[] name = result.split(",");
        if (name.length > 0) {
            return name[0];
        }
        return "";
    }

    @Override
    public String[] getInfoFromFile(String filePath) {
        String[] splited;
        String[] result;
        block7: {
            String output;
            block6: {
                block5: {
                    result = new String[3];
                    try {
                        if (new File(filePath).exists()) break block5;
                        return null;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
                String tag = "\"INFO:%{NAME}::%{ARCH}::%{VERSION}-%{RELEASE}\"";
                IPath dir = new Path(filePath).removeLastSegments(1);
                String file = new Path(filePath).lastSegment();
                String command = String.format("cd %s;%s", dir, RpmTool.fileInfoByTagCommand(tag, file));
                output = HostCommandLauncher.executeOutput(command);
                if (output.startsWith("INFO:")) break block6;
                return null;
            }
            String content = output.substring(5);
            splited = content.split("::");
            if (splited.length == 3) break block7;
            return null;
        }
        String name = splited[0];
        String arch = splited[1];
        String version = splited[2];
        result[0] = name;
        result[1] = arch;
        result[2] = version;
        return result;
    }

    @Override
    public boolean is80386File(String filePath) {
        String result = "";
        if (!new File(filePath).exists()) {
            return false;
        }
        String command = String.format("file %s", filePath);
        try {
            result = HostCommandLauncher.executeOutput(command);
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return result.contains("80386");
    }

    @Override
    public boolean isArmFile(String filePath) {
        String result = "";
        if (!new File(filePath).exists()) {
            return false;
        }
        String command = String.format("file %s", filePath);
        try {
            result = HostCommandLauncher.executeOutput(command);
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return result.contains("ARM");
    }

    @Override
    public ICommandStatus makeDir(String path) {
        return null;
    }

    @Override
    public ICommandStatus removeFile(String path) {
        return null;
    }

    @Override
    protected ICommandStatus execute(String command, IProgressMonitor monitor) {
        return null;
    }

    @Override
    protected ICommandStatus execute(String command, int timeout, IProgressMonitor monitor) {
        return null;
    }

    @Override
    protected ICommandStatus execute(String command, IProgressMonitor monitor, boolean printlog) {
        return null;
    }

    @Override
    protected ICommandStatus execute(String command, PackageManagerOutputReceiver rec, IProgressMonitor monitor) {
        return null;
    }

    @Override
    protected ICommandStatus execute(String command, PackageManagerOutputReceiver rec, int timeout, IProgressMonitor monitor) {
        return null;
    }

    @Override
    protected ICommandStatus execute(String command, PackageManagerOutputReceiver rec, IProgressMonitor monitor, boolean printLog) {
        return null;
    }

    @Override
    protected void changeUpdateMode() {
    }

    @Override
    public ICommandStatus copyFile(String srcPath, String dstPath) {
        return null;
    }

    @Override
    public ICommandStatus getMd5Checksum(String path) {
        return null;
    }

    @Override
    public ICommandStatus changeSmack(String path, String a_label, String e_label) {
        return null;
    }

    @Override
    public ICommandStatus getSmack(String paths) {
        return null;
    }

    @Override
    public CmdTargetTypes getCommandType() {
        return this.CMD_TYPE;
    }

    @Override
    public boolean isRunningApp(String appId) {
        return false;
    }

    @Override
    public ICommandStatus killApp(String appId) {
        return null;
    }

    @Override
    public ICommandStatus launchApp(String appId) {
        return null;
    }

    @Override
    public ICommandStatus executeBinary(String binary) {
        return null;
    }

    @Override
    public ICommandStatus setSmackExecute(String path, String e_label) {
        return null;
    }

    @Override
    public ICommandStatus installLocalPkg(String[] files, boolean isEfl, IProgressMonitor monitor) {
        return null;
    }

    @Override
    public ICommandStatus installLocalPkg(String[] files, IProgressMonitor monitor) {
        return null;
    }

    @Override
    public ICommandStatus installLocalPkg(String file, boolean isEfl, IProgressMonitor monitor) {
        return null;
    }

    @Override
    public ICommandStatus installLocalPkg(String file, IProgressMonitor monitor) {
        return null;
    }

    @Override
    public ICommandStatus installRemotePkg(String[] pkgs, IProgressMonitor monitor) {
        return null;
    }

    @Override
    public ICommandStatus executeBinaryBySudo(String command) {
        return null;
    }

    @Override
    public ICommandStatus installLocalPkg(String[] files, String tool, IProgressMonitor monitor) {
        return null;
    }
}

