/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.pkg.commander.rpm;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.log.UserLogger;
import org.tizen.nativeplatform.command.launcher.RootstrapCommandLauncher;
import org.tizen.nativeplatform.password.SudoPasswdManager;
import org.tizen.nativeplatform.pkg.commander.CommandStatus;
import org.tizen.nativeplatform.pkg.commander.ICommandStatus;
import org.tizen.nativeplatform.pkg.commander.IPkgCommander;
import org.tizen.nativeplatform.pkg.commander.rpm.RpmCommanderCommon;
import org.tizen.nativeplatform.pkg.model.PkgStatus;
import org.tizen.nativeplatform.pkg.tools.RpmTool;
import org.tizen.nativeplatform.pkg.tools.ZypperTool;
import org.tizen.nativeplatform.pkgmgr.PackageManagerOutputReceiver;
import org.tizen.nativeplatform.types.CmdTargetTypes;
import org.tizen.nativeplatform.util.PlatformLaunchUtil;

public class RpmCommanderRootstrap
extends RpmCommanderCommon {
    protected static final String CONSOLE_NAME = "Rootstrap Internal";
    protected static final String REMOVE_PKGS = "rpm-x86-arm";
    protected final CmdTargetTypes CMD_TYPE = CmdTargetTypes.ROOTSTRAP;
    protected IPath rootPath;

    public RpmCommanderRootstrap(IPath rootPath) {
        super(CONSOLE_NAME);
        this.rootPath = rootPath;
        this.actionBeforeUsingZypper();
    }

    public RpmCommanderRootstrap(IPath rootPath, boolean useConsoleLog) {
        super(useConsoleLog, CONSOLE_NAME);
        this.rootPath = rootPath;
        this.actionBeforeUsingZypper();
    }

    @Override
    public void actionBeforeUsingZypper() {
        if (this.checkPkgInstalled(REMOVE_PKGS)) {
            this.uninstallPkg(REMOVE_PKGS, null);
        }
    }

    @Override
    public ICommandStatus copyFilesToTmpDir(String[] fileList) {
        ArrayList<String> value = new ArrayList<String>();
        String[] stringArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            String filePath = stringArray[n2];
            String filename = new File(filePath).getName();
            IPath pathOnRootstrap = new Path("/tmp").append(filename);
            IPath toFilePath = this.rootPath.append(pathOnRootstrap);
            try {
                FileUtil.copyTo((String)filePath, (String)toFilePath.toString());
            }
            catch (IOException e) {
                return new CommandStatus(4, "", e.getMessage(), e);
            }
            value.add(pathOnRootstrap.toString());
            ++n2;
        }
        return new CommandStatus(0, value, null);
    }

    @Override
    public ICommandStatus installRemotePkg(String[] pkgs, IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        ICommandStatus status = null;
        IPkgCommander.TOOL type = PlatformLaunchUtil.getRootstrapRemotePkgTool();
        String option = PlatformLaunchUtil.getRootstrapRemotePkgInstallOp();
        if (type == IPkgCommander.TOOL.ZYPPER) {
            String command = this.makeCommand(this.getProxyCommand(), this.getResetRpmDb(), ZypperTool.installRemoteCommand(option, pkgs));
            status = this.execute(command, monitor);
        }
        if (monitor != null) {
            monitor.worked(1);
            monitor.done();
        }
        return status;
    }

    @Override
    public ICommandStatus installLocalPkg(String[] files, String tool, IProgressMonitor monitor) {
        List<String> value;
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        UserLogger.start((String)"copy.pkg");
        ICommandStatus status = this.copyFilesToTmpDir(files);
        if (status == null) {
            return null;
        }
        if (!status.isOk()) {
            this.logger.error(status.getMessage(), status.getException());
            return status;
        }
        UserLogger.end((String)"copy.pkg");
        if (tool == null || tool.isEmpty()) {
            tool = "rpm";
        }
        if ((value = status.getValues()) != null && value.size() > 0) {
            UserLogger.start((String)"install.pkg");
            String command = "";
            String option = "";
            if (tool.equals("rpm")) {
                command = this.makeCommand(this.getResetRpmDb(), RpmTool.installCommand(option, value.toArray(new String[0])));
                status = this.execute(command, 50000, monitor);
            } else if (tool.equals("zypper")) {
                command = this.makeCommand(this.getProxyCommand(), this.getResetRpmDb(), ZypperTool.installLocalCommand(option, value.toArray(new String[0])));
                status = this.execute(command, 50000, monitor);
            }
            UserLogger.end((String)"install.pkg");
        }
        if (monitor != null) {
            monitor.worked(1);
            monitor.done();
        }
        return status;
    }

    @Override
    public ICommandStatus installLocalPkg(String[] files, boolean isEfl, IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        UserLogger.start((String)"copy.pkg");
        ICommandStatus status = this.copyFilesToTmpDir(files);
        if (status == null) {
            return null;
        }
        if (!status.isOk()) {
            this.logger.error(status.getMessage(), status.getException());
            return status;
        }
        UserLogger.end((String)"copy.pkg");
        IPkgCommander.TOOL type = PlatformLaunchUtil.getRootstrapLocalPkgTool();
        String option = PlatformLaunchUtil.getRootstrapLocalPkgInstallOp();
        List<String> value = status.getValues();
        if (value != null && value.size() > 0) {
            UserLogger.start((String)"install.pkg");
            if (type == IPkgCommander.TOOL.RPM) {
                String command = this.makeCommand(this.getResetRpmDb(), RpmTool.installCommand(option, value.toArray(new String[0])));
                status = this.execute(command, 50000, monitor);
            } else if (type == IPkgCommander.TOOL.ZYPPER) {
                String command = this.makeCommand(this.getProxyCommand(), this.getResetRpmDb(), ZypperTool.installLocalCommand(option, value.toArray(new String[0])));
                status = this.execute(command, 50000, monitor);
            }
            UserLogger.end((String)"install.pkg");
        }
        if (monitor != null) {
            monitor.worked(1);
            monitor.done();
        }
        return status;
    }

    @Override
    public Map<String, PkgStatus> getLocalPkgList() {
        String tag = "\\\\<pkg\\\\>%{NAME},%{VERSION}-%{RELEASE},%{ARCH}\\\\<\\\\/pkg\\\\>";
        return this.getLocalPkgList(tag);
    }

    @Override
    protected ICommandStatus execute(String command, IProgressMonitor monitor) {
        return this.execute(command, monitor, true);
    }

    @Override
    protected ICommandStatus execute(String command, int timeout, IProgressMonitor monitor) {
        return this.execute(command, monitor, true);
    }

    @Override
    protected ICommandStatus execute(String command, IProgressMonitor monitor, boolean printCommand) {
        ICommandStatus status;
        String chrootedCommand = this.getChrootedCommand(command);
        if (printCommand) {
            this.printCommandLog(chrootedCommand);
        }
        if (!(status = RootstrapCommandLauncher.executeSudo(chrootedCommand, null, this.rec, monitor)).isOk()) {
            this.logger.error(status.getMessage(), status.getException());
        }
        return status;
    }

    @Override
    protected ICommandStatus execute(String command, PackageManagerOutputReceiver rec, IProgressMonitor monitor) {
        return this.execute(command, rec, monitor, true);
    }

    @Override
    protected ICommandStatus execute(String command, PackageManagerOutputReceiver rec, int timeout, IProgressMonitor monitor) {
        return this.execute(command, rec, monitor, true);
    }

    @Override
    protected ICommandStatus execute(String command, PackageManagerOutputReceiver rec, IProgressMonitor monitor, boolean printlog) {
        ICommandStatus status;
        String chrootedCommand = this.getChrootedCommand(command);
        if (printlog) {
            this.printCommandLog(chrootedCommand);
        }
        if (!(status = RootstrapCommandLauncher.executeSudo(chrootedCommand, null, rec, monitor)).isOk()) {
            this.logger.error(status.getMessage(), status.getException());
        }
        return status;
    }

    private String getChrootedCommand(String cmd) {
        return String.format("chroot %s sh -c \"%s\"", this.rootPath.toString(), cmd);
    }

    @Override
    protected PackageManagerOutputReceiver getNewOuputReceiver() {
        return null;
    }

    @Override
    protected void changeUpdateMode() {
    }

    @Override
    public ICommandStatus copyFile(String srcPath, String dstPath) {
        ArrayList<String> value = new ArrayList<String>();
        Path pathOnRootstrap = new Path(dstPath);
        IPath toFilePath = this.rootPath.append((IPath)pathOnRootstrap);
        String passwd = SudoPasswdManager.getSudoPassword();
        String command = String.format("echo %s | sudo -S cp \"%s\" \"%s\"", passwd, srcPath, toFilePath.toString());
        ICommandStatus status = RootstrapCommandLauncher.execute(command, null, this.rec, null);
        if (!status.isOk()) {
            this.logger.error(status.getMessage(), status.getException());
            return status;
        }
        this.printResultLog(String.format("Copied file: %s \n -> %s", srcPath, toFilePath.toString()));
        value.add(pathOnRootstrap.toString());
        return new CommandStatus(0, value, null);
    }

    @Override
    public ICommandStatus removeFile(String path) {
        ArrayList<String> value = new ArrayList<String>();
        Path pathOnRootstrap = new Path(path);
        IPath toFilePath = this.rootPath.append((IPath)pathOnRootstrap);
        String passwd = SudoPasswdManager.getSudoPassword();
        String command = String.format("echo %s | sudo -S rm -f %s", passwd, toFilePath.toString());
        ICommandStatus status = RootstrapCommandLauncher.execute(command, null, this.rec, null);
        if (!status.isOk()) {
            this.logger.error(status.getMessage(), status.getException());
            return status;
        }
        this.printResultLog(String.format("Removed file: %s", toFilePath.toString()));
        value.add(pathOnRootstrap.toString());
        return new CommandStatus(0, value, null);
    }

    @Override
    public ICommandStatus makeDir(String path) {
        ArrayList<String> value = new ArrayList<String>();
        Path pathOnRootstrap = new Path(path);
        IPath toFilePath = this.rootPath.append((IPath)pathOnRootstrap);
        String passwd = SudoPasswdManager.getSudoPassword();
        String command = String.format("echo %s | sudo -S mkdir -p %s", passwd, toFilePath.toString());
        ICommandStatus status = RootstrapCommandLauncher.execute(command, null, this.rec, null);
        if (!status.isOk()) {
            this.logger.error(status.getMessage(), status.getException());
            return status;
        }
        this.printResultLog(String.format("Make dir: %s", toFilePath.toString()));
        value.add(pathOnRootstrap.toString());
        return new CommandStatus(0, value, null);
    }

    @Override
    public ICommandStatus getMd5Checksum(String path) {
        String command = String.format("md5sum %s", path);
        ICommandStatus status = this.execute(command, null, null, false);
        if (status.isOk()) {
            this.printResultLog(String.format("[RDS] Checked checksum: %s", path));
        }
        return status;
    }

    @Override
    public ICommandStatus changeSmack(String pathm, String a_label, String e_label) {
        return null;
    }

    @Override
    public ICommandStatus getSmack(String paths) {
        return null;
    }

    @Override
    public CmdTargetTypes getCommandType() {
        return this.CMD_TYPE;
    }

    @Override
    public boolean isRunningApp(String appId) {
        return false;
    }

    @Override
    public ICommandStatus killApp(String appId) {
        return null;
    }

    @Override
    public ICommandStatus launchApp(String appId) {
        return null;
    }

    @Override
    public ICommandStatus executeBinary(String binary) {
        return null;
    }

    @Override
    public ICommandStatus setSmackExecute(String path, String e_label) {
        return null;
    }

    @Override
    public ICommandStatus executeBinaryBySudo(String command) {
        return null;
    }
}

