/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.pkg.commander.rpm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativeplatform.pkg.commander.IPkgModelMaker;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.pkg.model.IPackage;
import org.tizen.nativeplatform.pkg.model.RpmPackage;
import org.tizen.nativeplatform.types.CmdTargetTypes;
import org.tizen.nativeplatform.types.PkgTypes;

public class RpmModelMaker
implements IPkgModelMaker {
    protected final Logger logger = LoggerFactory.getLogger(RpmModelMaker.class);
    private PkgCommandTarget target = new PkgCommandTarget(PkgTypes.RPM);

    private IPackage _makeModel(String filePath) {
        RpmPackage pkg = new RpmPackage();
        String[] info = this.target.getCommander(CmdTargetTypes.HOST, false).getInfoFromFile(filePath);
        if (info == null) {
            this.logger.error(String.format("Failed to get rpm information: %s", filePath));
            return null;
        }
        pkg.setPath(filePath);
        pkg.setName(info[0]);
        pkg.setArch(info[1]);
        pkg.setVer(info[2]);
        return pkg;
    }

    @Override
    public IPackage makeModel(String filePath) {
        IPackage pkg = this._makeModel(filePath);
        if (pkg == null) {
            return null;
        }
        return pkg;
    }

    @Override
    public IPackage makeModel(String filePath, boolean needsFilter) {
        IPackage pkg = this._makeModel(filePath);
        if (pkg == null) {
            return null;
        }
        pkg.setNeedsFilter(needsFilter);
        return pkg;
    }

    @Override
    public List<IPackage> makeModels(Collection<String> filePaths) {
        ArrayList<IPackage> pkgs = new ArrayList<IPackage>();
        for (String path : filePaths) {
            IPackage pkg = this.makeModel(path);
            if (pkg == null) continue;
            pkgs.add(pkg);
        }
        return pkgs;
    }

    @Override
    public List<IPackage> makeModels(Collection<String> filePaths, boolean needsFilter) {
        ArrayList<IPackage> pkgs = new ArrayList<IPackage>();
        for (String path : filePaths) {
            IPackage pkg = this.makeModel(path, needsFilter);
            if (pkg == null) continue;
            pkgs.add(pkg);
        }
        return pkgs;
    }
}

