/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.pkg.tools;

public class ZypperTool {
    public static final String NAME = "zypper";
    public static final String PATH = "/usr/bin/zypper";
    private static final String TOOL = "zypper";
    private static final String WS = " ";
    private static final String NON_INTERACITVE_OP = "--non-interactive";
    private static final String XMLOUT_OP = "--xmlout";
    private static final String NOGPGCHECK_OP = "--no-gpg-checks";
    private static final String INSTALL_OP = "install";
    private static final String INSTALL_FORCE_OP = "--force";
    private static final String UNINSTALL_OP = "remove";
    private static final String REPO_ADD_OP = "addrepo";
    private static final String REPO_ADD_TYPE_OP = "--type";
    private static final String REPO_REMOVE_OP = "removerepo";
    private static final String REPO_REFRESH_OP = "refresh";
    private static final String REPO_LIST_OP = "repos";
    private static final String REPO_LIST_URI_OP = "-u";
    private static final String QUERY_PKGLIST_OP = "packages";
    private static final String QUERY_INFO_OP = "info";
    private static final String QUERY_WHATPROVIDE_OP = "what-provides";
    private static final String INFO_REQUIRES_OP = "--requires";
    private static final String QUERY_SEARCH_OP = "search";
    private static final String DIST_UPGRADE_OP = "dist-upgrade";
    public static final String TITLE_NAME = "Name";
    public static final String TITLE_VERSION = "Version";
    public static final String TITLE_ARCH = "Arch";
    public static final String TITLE_REPO = "Repository";
    public static final String TITLE_VENDOR = "Vendor";
    public static final String TITLE_SIZE = "Installed Size";
    public static final String TITLE_SUMMARY = "Summary";
    public static final String TITLE_DESC = "Description";
    public static final String TITLE_REQUIRES = "Requires";
    public static final String TITLE_INSTALLED = "Installed";

    public static String versionCommand(String pkg) {
        return ZypperTool.makeCommand(NON_INTERACITVE_OP, QUERY_INFO_OP, pkg, "|", "grep", TITLE_VERSION);
    }

    public static String getLocalInstallCommandFormat() {
        StringBuffer command = new StringBuffer();
        command.append(NON_INTERACITVE_OP).append(WS);
        command.append(INSTALL_OP).append(WS);
        command.append(INSTALL_FORCE_OP).append(WS);
        command.append("%s");
        return command.toString();
    }

    public static String getRemoteInstallCommandFormat() {
        StringBuffer command = new StringBuffer();
        command.append(NON_INTERACITVE_OP).append(WS);
        command.append(INSTALL_OP).append(WS);
        command.append("%s");
        return command.toString();
    }

    public static String installLocalCommand(String commandFormat, String[] list) {
        StringBuffer sbPkgs = new StringBuffer();
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sbPkgs.append(String.valueOf(s) + WS);
            ++n2;
        }
        String pkgs = sbPkgs.toString().trim();
        String options = String.format(commandFormat, pkgs);
        return "/usr/bin/zypper " + options;
    }

    public static String installLocalCommand(String[] list) {
        StringBuffer sbPkgs = new StringBuffer();
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sbPkgs.append(String.valueOf(s) + WS);
            ++n2;
        }
        String pkgs = sbPkgs.toString().trim();
        return ZypperTool.makeCommand(NON_INTERACITVE_OP, INSTALL_OP, INSTALL_FORCE_OP, pkgs);
    }

    public static String installRemoteCommand(String commandFormat, String[] list) {
        StringBuffer sbPkgs = new StringBuffer();
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sbPkgs.append(String.valueOf(s) + WS);
            ++n2;
        }
        String pkgs = sbPkgs.toString().trim();
        String options = String.format(commandFormat, pkgs);
        return "/usr/bin/zypper " + options;
    }

    public static String installRemoteCommand(String[] list) {
        StringBuffer sbPkgs = new StringBuffer();
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sbPkgs.append(String.valueOf(s) + WS);
            ++n2;
        }
        String pkgs = sbPkgs.toString().trim();
        return ZypperTool.makeCommand(NON_INTERACITVE_OP, INSTALL_OP, pkgs);
    }

    public static String installLocalCommandXmlOut(String[] list) {
        StringBuffer sbPkgs = new StringBuffer();
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sbPkgs.append(String.valueOf(s) + WS);
            ++n2;
        }
        String pkgs = sbPkgs.toString().trim();
        return ZypperTool.makeCommand(XMLOUT_OP, NON_INTERACITVE_OP, INSTALL_OP, INSTALL_FORCE_OP, pkgs);
    }

    public static String installRemoteCommandXmlOut(String[] list) {
        StringBuffer sbPkgs = new StringBuffer();
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sbPkgs.append(String.valueOf(s) + WS);
            ++n2;
        }
        String pkgs = sbPkgs.toString().trim();
        return ZypperTool.makeCommand(XMLOUT_OP, NON_INTERACITVE_OP, INSTALL_OP, pkgs);
    }

    public static String uninstallCommand(String[] list) {
        StringBuffer sbPkgs = new StringBuffer();
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sbPkgs.append(String.valueOf(s) + WS);
            ++n2;
        }
        String pkgs = sbPkgs.toString().trim();
        return ZypperTool.makeCommand(NON_INTERACITVE_OP, UNINSTALL_OP, pkgs);
    }

    public static String uninstallCommandXmlOut(String[] list) {
        StringBuffer sbPkgs = new StringBuffer();
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sbPkgs.append(String.valueOf(s) + WS);
            ++n2;
        }
        String pkgs = sbPkgs.toString().trim();
        return ZypperTool.makeCommand(XMLOUT_OP, NON_INTERACITVE_OP, UNINSTALL_OP, pkgs);
    }

    public static String remotePkgListCommand() {
        return ZypperTool.makeCommand(NON_INTERACITVE_OP, NOGPGCHECK_OP, QUERY_PKGLIST_OP);
    }

    public static String remotePkgListCommandWithXmlOut() {
        return ZypperTool.makeCommand(XMLOUT_OP, NON_INTERACITVE_OP, NOGPGCHECK_OP, QUERY_PKGLIST_OP);
    }

    public static String addLocalRepoCommand(String name, String url) {
        return ZypperTool.makeCommand(NON_INTERACITVE_OP, REPO_ADD_OP, REPO_ADD_TYPE_OP, "plaindir", url, name);
    }

    public static String addLocalRepoCommandXmlOut(String name, String url) {
        return ZypperTool.makeCommand(XMLOUT_OP, NON_INTERACITVE_OP, REPO_ADD_OP, REPO_ADD_TYPE_OP, "plaindir", url, name);
    }

    public static String addRemoteRepoCommand(String name, String url) {
        return ZypperTool.makeCommand(NON_INTERACITVE_OP, REPO_ADD_OP, url, name);
    }

    public static String addRemoteRepoCommandXmlOut(String name, String url) {
        return ZypperTool.makeCommand(XMLOUT_OP, NON_INTERACITVE_OP, REPO_ADD_OP, url, name);
    }

    public static String removeRepoCommand(String name) {
        return ZypperTool.makeCommand(NON_INTERACITVE_OP, REPO_REMOVE_OP, name);
    }

    public static String removeRepoCommandXmlOut(String name) {
        return ZypperTool.makeCommand(XMLOUT_OP, NON_INTERACITVE_OP, REPO_REMOVE_OP, name);
    }

    public static String refreshRepoCommand() {
        return ZypperTool.makeCommand(NON_INTERACITVE_OP, NOGPGCHECK_OP, REPO_REFRESH_OP);
    }

    public static String refreshRepoCommandXmlOut() {
        return ZypperTool.makeCommand(XMLOUT_OP, NON_INTERACITVE_OP, NOGPGCHECK_OP, REPO_REFRESH_OP);
    }

    public static String distUpgradeCommand() {
        return ZypperTool.makeCommand(NON_INTERACITVE_OP, DIST_UPGRADE_OP);
    }

    public static String distUpgradeCommandXmlOut() {
        return ZypperTool.makeCommand(XMLOUT_OP, NON_INTERACITVE_OP, DIST_UPGRADE_OP);
    }

    public static String repoListCommand() {
        return ZypperTool.makeCommand(REPO_LIST_OP, REPO_LIST_URI_OP);
    }

    public static String repoListCommandXmlOut() {
        return ZypperTool.makeCommand(XMLOUT_OP, REPO_LIST_OP, REPO_LIST_URI_OP);
    }

    public static String pkgInfoCommand(String name) {
        return ZypperTool.makeCommand(NON_INTERACITVE_OP, QUERY_INFO_OP, INFO_REQUIRES_OP, name);
    }

    public static String whatProvideCommandXmlOut(String name) {
        return ZypperTool.makeCommand(XMLOUT_OP, NON_INTERACITVE_OP, QUERY_WHATPROVIDE_OP, name);
    }

    public static String searchPkgCommandWithXmlOut(String pkg) {
        return ZypperTool.makeCommand(XMLOUT_OP, NON_INTERACITVE_OP, QUERY_SEARCH_OP, pkg);
    }

    private static String makeCommand(String ... options) {
        StringBuffer sbCommand = new StringBuffer("zypper ");
        String[] stringArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            String op = stringArray[n2];
            if (!(op = op.trim()).isEmpty()) {
                sbCommand.append(String.valueOf(op) + WS);
            }
            ++n2;
        }
        return sbCommand.toString().trim();
    }
}

