/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.preferences.ui;

import java.util.ResourceBundle;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.tizen.nativeplatform.password.PasswordInputWizard;
import org.tizen.nativeplatform.password.PasswordInputWizardDialog;
import org.tizen.nativeplatform.preferences.PreferencesManager;

public class PlatformPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final String BUNDLE_NAME = String.valueOf(PlatformPreferencePage.class.getPackage().getName()) + ".PlatformUIMessages";
    private ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);
    private String password = "";
    Text passwdText;

    public PlatformPreferencePage() {
        String description = "General settings for developing platform project";
        this.setDescription(description);
    }

    public void init(IWorkbench workbench) {
        this.updateData();
    }

    private void updateData() {
        this.password = PreferencesManager.getPassword();
        if (this.passwdText != null) {
            this.passwdText.setText(this.password);
        }
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(2));
        this.createSudoPasswordComposite(parent);
        return parent;
    }

    private void createSudoPasswordComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(3, false));
        Label proxyLabel = new Label(composite, 0);
        proxyLabel.setText(this.resources.getString("ConfPref.Text.Password"));
        this.passwdText = new Text(composite, 4196364);
        GridData gridData = new GridData(768);
        this.passwdText.setLayoutData((Object)gridData);
        this.passwdText.setText(this.password);
        Button modifyBt = new Button(composite, 8);
        modifyBt.setText(this.resources.getString("ConfPref.Button.Change"));
        modifyBt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                PasswordInputWizard wizard = new PasswordInputWizard();
                PasswordInputWizardDialog dlg = new PasswordInputWizardDialog(PlatformPreferencePage.this.getShell(), wizard);
                dlg.create();
                if (dlg.open() == 0) {
                    PreferencesManager.setPassword(dlg.getPassword());
                    PlatformPreferencePage.this.updateData();
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }
}

