/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.repo.commander;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativeplatform.command.launcher.HostCommandLauncher;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.repo.commander.RepoManager;
import org.tizen.nativeplatform.repo.model.Repository;

public class LocalRepoMounter {
    private static final String TARGET_BASE_REPO_DIR = "/var/tmp/localrepos";
    private static final Logger logger = LoggerFactory.getLogger(LocalRepoMounter.class);
    private static Map<String, String> mountMap = new HashMap<String, String>();
    private static int mountCount = 0;

    public static int getMountCount() {
        return mountCount;
    }

    public static IPath getTargetRepoPath() {
        Path repoBasePath = new Path(TARGET_BASE_REPO_DIR);
        String repoName = String.format("url%d", mountCount);
        IPath repoPath = repoBasePath.append(repoName);
        return repoPath;
    }

    public static IPath getTargetRepoPath(IPath rootstrapPath) {
        if (rootstrapPath == null) {
            return null;
        }
        return LocalRepoMounter.getTargetRepoPath(rootstrapPath.toOSString());
    }

    public static IPath getTargetRepoPath(String rootstrapPath) {
        Path rootPath = new Path(rootstrapPath);
        Path repoBasePath = new Path(TARGET_BASE_REPO_DIR);
        String repoName = String.format("url%d", mountCount);
        IPath repoPath = repoBasePath.append(repoName);
        return rootPath.append(repoPath);
    }

    public static IPath getMountedRepoPath(String repoLocalPath) {
        if (LocalRepoMounter.containRepo(repoLocalPath)) {
            String repoTargetPath = mountMap.get(repoLocalPath);
            return new Path(repoTargetPath);
        }
        return null;
    }

    public static boolean containRepo(String path) {
        return mountMap.containsKey(path);
    }

    public static List<IPath> mountLocalRepository(PlatformRootstrap rootstrap, IProgressMonitor monitor) {
        ArrayList<IPath> reposPath = new ArrayList<IPath>();
        String rootstrapPath = SmartBuildInterface.getInstance().getPlatformRootstrapPath(rootstrap.getPath());
        List<Repository> repos = rootstrap.getRepoList();
        for (Repository repo : repos) {
            IPath result;
            String url = repo.getUri();
            String type = repo.getType();
            if (!RepoManager.isLocalType(type) || !RepoManager.isLocalUrl(url) || (result = LocalRepoMounter.mountLocalRepository(rootstrapPath, url, monitor)) == null) continue;
            reposPath.add(result);
        }
        return reposPath;
    }

    public static List<IPath> mountLocalRepository(PlatformRootstrap rootstrap) {
        return LocalRepoMounter.mountLocalRepository(rootstrap, null);
    }

    public static List<IPath> umountLocalRepository(PlatformRootstrap rootstrap) {
        return LocalRepoMounter.umountLocalRepository(rootstrap, null);
    }

    public static boolean umountLocalRepository(IPath localPath, IProgressMonitor monitor) {
        if (localPath == null) {
            return false;
        }
        String path = localPath.toOSString();
        return LocalRepoMounter.umountLocalRepository(path, monitor);
    }

    private static void increaseMountCount() {
        ++mountCount;
    }

    private static void decreaseMountCount() {
        --mountCount;
    }

    public static IPath mountLocalRepository(String rootstrapPath, String repoLocalPath, IProgressMonitor monitor) {
        IPath result = null;
        File dir = new File(repoLocalPath);
        if (!dir.exists()) {
            return null;
        }
        if (mountMap.containsKey(repoLocalPath)) {
            return LocalRepoMounter.getMountedRepoPath(repoLocalPath);
        }
        IPath repoPath = LocalRepoMounter.getTargetRepoPath();
        Path rootPath = new Path(rootstrapPath);
        IPath targetRepofullPath = rootPath.append(repoPath);
        try {
            String mountCommand;
            String mkdirCommand = String.format("sudo -S mkdir -p %s", targetRepofullPath.toOSString());
            if (HostCommandLauncher.executeSudo(mkdirCommand, null, null, "Platform Internal", monitor) && HostCommandLauncher.executeSudo(mountCommand = String.format("sudo -S mount --bind %s %s", repoLocalPath, targetRepofullPath.toOSString()), null, null, "Platform Internal", monitor)) {
                mountMap.put(repoLocalPath, targetRepofullPath.toOSString());
                LocalRepoMounter.increaseMountCount();
                result = repoPath;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (result == null) {
            logger.info(String.format("Package Manager - Failed to mount repository\n-%s", repoLocalPath));
        } else {
            logger.info(String.format("Package Manager - %s is mounted", repoLocalPath));
        }
        return result;
    }

    public static IPath mountLocalRepository(IPath rootstrapPath, IPath repoLocalPath, IProgressMonitor monitor) {
        if (rootstrapPath == null || repoLocalPath == null) {
            return null;
        }
        return LocalRepoMounter.mountLocalRepository(rootstrapPath.toOSString(), repoLocalPath.toOSString(), monitor);
    }

    public static boolean umountLocalRepository(String repoLocalPath, IProgressMonitor monitor) {
        boolean result;
        block6: {
            result = false;
            try {
                IPath repoPath = LocalRepoMounter.getMountedRepoPath(repoLocalPath);
                if (repoPath != null) {
                    String umountCommand = String.format("sudo -S umount %s", repoPath.toOSString());
                    if (HostCommandLauncher.executeSudo(umountCommand, null, null, "Platform Internal", monitor)) {
                        mountMap.remove(repoLocalPath);
                        LocalRepoMounter.decreaseMountCount();
                        result = true;
                    }
                    break block6;
                }
                logger.info(String.format("Package Manager - %s is not mounted", repoLocalPath));
                return true;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (result) {
            logger.info(String.format("Package Manager - %s is unmounted", repoLocalPath));
        } else {
            logger.info(String.format("Package Manager - Failed to unmount repository\n-%s", repoLocalPath));
        }
        return result;
    }

    public static List<IPath> umountLocalRepository(PlatformRootstrap rootstrap, IProgressMonitor monitor) {
        ArrayList<IPath> failedRepoPath = new ArrayList<IPath>();
        List<Repository> repos = rootstrap.getRepoList();
        for (Repository repo : repos) {
            String url = repo.getUri();
            String type = repo.getType();
            if (!RepoManager.isLocalType(type) || !RepoManager.isLocalUrl(url) || LocalRepoMounter.umountLocalRepository(url, monitor)) continue;
            failedRepoPath.add(LocalRepoMounter.getMountedRepoPath(url));
        }
        return failedRepoPath;
    }

    public static List<IPath> clearMounted(IProgressMonitor monitor) {
        ArrayList<IPath> failedRepoPath = new ArrayList<IPath>();
        if (mountMap.size() < 1) {
            return failedRepoPath;
        }
        ArrayList<String> umountRepo = new ArrayList<String>();
        Set<String> keySet = mountMap.keySet();
        Iterator keys = keySet.iterator();
        while (keys.hasNext()) {
            umountRepo.add((String)keys.next());
        }
        for (String r : umountRepo) {
            if (LocalRepoMounter.umountLocalRepository(r, null)) continue;
            failedRepoPath.add(LocalRepoMounter.getMountedRepoPath(r));
            mountMap.remove(r);
            LocalRepoMounter.decreaseMountCount();
        }
        return failedRepoPath;
    }
}

