/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.tizen.nativeplatform.PlatformInstances;
import org.tizen.nativeplatform.command.launcher.HostCommandLauncher;
import org.tizen.nativeplatform.pkg.model.IPackage;
import org.tizen.nativeplatform.util.CachePackageChecksum;

public class LRCaching {
    private static Map<String, HashMap<String, String>> workingChecksums = new HashMap<String, HashMap<String, String>>();
    private static Map<String, HashMap<String, String>> stagingChecksums = new HashMap<String, HashMap<String, String>>();

    public static int getStagingSize() {
        return stagingChecksums.size();
    }

    public static int getWorkingSize() {
        return workingChecksums.size();
    }

    public static Map<String, HashMap<String, String>> getWorkingCaching() {
        return workingChecksums;
    }

    public static Map<String, HashMap<String, String>> getStagingCaching() {
        return stagingChecksums;
    }

    public static void workingCachingClear() {
        workingChecksums.clear();
    }

    public static boolean workingCachingIsEmpty() {
        return workingChecksums.isEmpty();
    }

    public static boolean containsStagingKey(String key) {
        return stagingChecksums.containsKey(key);
    }

    public static boolean containsWorkingKey(String key) {
        return workingChecksums.containsKey(key);
    }

    public static void stagingCachingPut(String key, HashMap<String, String> value) {
        stagingChecksums.put(key, value);
    }

    public static void workingCachingPut(String key, HashMap<String, String> value) {
        workingChecksums.put(key, value);
    }

    public static Map<String, String> stagingCachingGet(String key) {
        return stagingChecksums.get(key);
    }

    public static Map<String, String> workingCachingGet(String key) {
        return workingChecksums.get(key);
    }

    public static boolean postBuildCachePkgChecksums(IProject project, List<IPackage> pkgFiles) throws InterruptedException {
        boolean iscacheded = false;
        StringBuffer sbPaths = new StringBuffer();
        for (IPackage pkg : pkgFiles) {
            sbPaths.append(pkg.getPath());
            sbPaths.append(" ");
        }
        String pkgFileList = sbPaths.toString().trim();
        iscacheded = LRCaching.cacheWorkingPkgChecksum(project, pkgFileList);
        return iscacheded;
    }

    private static boolean cacheWorkingPkgChecksum(IProject project, String pkgFileList) throws InterruptedException {
        if (pkgFileList == null || pkgFileList.isEmpty()) {
            return false;
        }
        String command = PlatformInstances.getScriptProvider().genCacheChecksumScriptNoHash(project, pkgFileList);
        if (command == null) {
            return false;
        }
        LRCaching.workingCachingClear();
        if (!LRCaching.workingCachingIsEmpty()) {
            return false;
        }
        String output = HostCommandLauncher.executeOutput(command);
        PlatformInstances.getScriptProvider().cleanUpScript(command);
        String key = "";
        String[] stringArray = output.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            String[] strs = str.split("  ");
            if (strs.length == 2) {
                if (strs[0].equals("key:")) {
                    key = strs[1];
                    key = key.replace("\r", "");
                    LRCaching.workingCachingPut(key, new HashMap<String, String>());
                } else {
                    String s = strs[1].startsWith(".") ? strs[1].substring(1) : strs[1];
                    s = s.replace("\r", "");
                    Map<String, String> value = LRCaching.workingCachingGet(key);
                    if (value == null) {
                        LRCaching.workingCachingPut(key, new HashMap<String, String>());
                        value = LRCaching.workingCachingGet(key);
                    }
                    value.put(s, strs[0]);
                }
            }
            ++n2;
        }
        return true;
    }

    public static void copyWorkingtoStaging(List<IPackage> packages) {
        StringBuffer sbPaths = new StringBuffer();
        for (IPackage pkg : packages) {
            sbPaths.append(pkg.getPath());
            sbPaths.append(" ");
        }
        String pkgFileList = sbPaths.toString().trim();
        if (pkgFileList == null || pkgFileList.isEmpty()) {
            return;
        }
        Set<Map.Entry<String, HashMap<String, String>>> entries = LRCaching.getWorkingCaching().entrySet();
        for (Map.Entry<String, HashMap<String, String>> entry : entries) {
            String key = entry.getKey();
            HashMap<String, String> stagingValue = new HashMap<String, String>();
            Map workingChecksumsValue = entry.getValue();
            stagingValue.putAll(workingChecksumsValue);
            LRCaching.stagingCachingPut(key, stagingValue);
        }
    }

    public static String getCacheKeys(String pkgList) {
        StringBuffer cacheKeys = new StringBuffer();
        String[] stringArray = pkgList.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            try {
                cacheKeys.append(CachePackageChecksum.getCacheKey(path));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return null;
            }
            cacheKeys.append(" ");
            ++n2;
        }
        return cacheKeys.toString().trim();
    }

    public static Map<String, String> getWorkingCacheAsMap(String cacheKeys) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] stringArray = cacheKeys.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (LRCaching.containsWorkingKey(key)) {
                result.putAll(LRCaching.workingCachingGet(key));
            }
            ++n2;
        }
        return result;
    }

    public static Map<String, String> getStagingCacheAsMap(String cacheKeys) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] stringArray = cacheKeys.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (LRCaching.containsStagingKey(key)) {
                result.putAll(LRCaching.stagingCachingGet(key));
            }
            ++n2;
        }
        return result;
    }

    public static String getCacheKeys(String pkgList, String projectName) {
        StringBuffer cacheKeys = new StringBuffer();
        String[] stringArray = pkgList.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pkgName = stringArray[n2];
            cacheKeys.append(pkgName).append("_").append(projectName).append(" ");
            ++n2;
        }
        return cacheKeys.toString().trim();
    }
}

